/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.presentationstate.IPresStateApplicationFinishedListener;
import com.agfa.pacs.impaxee.splitsort.runtime.FrameContainer;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.View;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.layout.LytDisplay;
import java.util.HashSet;

public class TemporaryVisDisplay2
extends VisDisplay2 {
    private static final ALogger LOGGER = ALogger.getLogger(TemporaryVisDisplay2.class);
    private boolean isHotRegionsEnabled;
    private boolean isMouseWheelZoomEnabled;
    private boolean isDisplayLayoutChangeEnabled = true;
    private boolean is3D;

    public TemporaryVisDisplay2() {
        super(null);
    }

    public TemporaryVisDisplay2(IDisplaySet iDisplaySet) {
        this();
        this.initTemporaryVisDisplay(iDisplaySet);
    }

    public final void initTemporaryVisDisplay(IDisplaySet iDisplaySet) {
        this.setLytMode(MainLayoutType.variable.getNewLytDisplay(), 1, 1, false, false);
        this.setIsDetached(true);
        this.initVisDisplay(iDisplaySet, 0, true, ActivationMode.MANUAL);
        TEventDispatch.sendEvent(this, new TEvent(66), null, false);
        for (VisData visData : this.getVis()) {
            visData.getView().getMouseHandler().onROIDeleteAll(true);
        }
    }

    public void initTemporaryVisDisplay(View[] viewArray, int n, int n2, boolean bl) {
        this.is3D = bl;
        this.setLytMode(MainLayoutType.variable.getNewLytDisplay(), n, n2, false, false);
        this.setIsDetached(true);
        this.appendViews(viewArray);
        HashSet<IFrameObjectData> hashSet = new HashSet<IFrameObjectData>(viewArray.length);
        View[] viewArray2 = viewArray;
        int n3 = viewArray.length;
        int n4 = 0;
        while (n4 < n3) {
            View view = viewArray2[n4];
            hashSet.add(view.getFrameData());
            ++n4;
        }
        this.getData().setSequenceData(HangingFactory.getInstance().newDisplaySet(new FrameContainer(hashSet), DataSelectionManager.getInstance().getCurrentPatient().getDecompositionRuntime()));
        this.getVisView(0).makeTheLastModified();
    }

    @Override
    public synchronized void clearByUser() {
        LOGGER.warn("Manually clearing a temporary display is not allowed.");
    }

    @Override
    protected void applyMostRecentPresState(IPresStateApplicationFinishedListener iPresStateApplicationFinishedListener) {
        this.applyDefaultPresentationState(iPresStateApplicationFinishedListener);
    }

    public void setHotRegionsEnabled(boolean bl) {
        this.isHotRegionsEnabled = bl;
        if (bl) {
            int n = 2 * (int)Config.impaxee.jvision.HR_VISUAL.MinSize.get();
            for (Vis2 vis2 : this.getVisViews()) {
                if (vis2.getWidth() >= 0 && vis2.getHeight() >= 0) continue;
                vis2.setBounds(0, 0, n, n);
            }
            this.addAllVisHRs();
        }
    }

    public void setMouseWheelZoomEnabled(boolean bl) {
        this.isMouseWheelZoomEnabled = bl;
    }

    public void setDisplayLayoutChangeEnabled(boolean bl) {
        this.isDisplayLayoutChangeEnabled = bl;
    }

    @Override
    public boolean isAggregating() {
        return this.is3D || super.isAggregating();
    }

    @Override
    boolean isDisplayNextSeriesEnabled(boolean bl, PAction pAction) {
        return false;
    }

    @Override
    public boolean isDragAndDropEnabled() {
        return false;
    }

    @Override
    public boolean isHotRegionsEnabled() {
        return this.isHotRegionsEnabled;
    }

    @Override
    public boolean isMouseWheelZoomEnabled() {
        return this.isMouseWheelZoomEnabled;
    }

    @Override
    public boolean isPluginAllowed(IPlugin iPlugin) {
        return iPlugin.isDefaultPlugin();
    }

    @Override
    public boolean isPopupEnabled() {
        return false;
    }

    @Override
    public boolean performSimpleAnimation() {
        return !this.is3D && super.performSimpleAnimation();
    }

    @Override
    public void setLytMode(LytDisplay lytDisplay, int n, int n2, boolean bl, boolean bl2) {
        if (this.isDisplayLayoutChangeEnabled) {
            super.setLytMode(lytDisplay, n, n2, bl, bl2);
        }
    }
}

