/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.hap.pacs.data.valuemapping.RealWorldValueMapping;
import com.agfa.hap.pacs.impaxee.awt.IImageHolder;
import com.agfa.hap.pacs.impaxee.awt.OutlineFont;
import com.agfa.hap.pacs.impaxee.awt.OutlineFontCache;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransform;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IDisplaySetStatusIcon;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.keyimages.IKeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.splitsort.I4DProperties;
import com.agfa.pacs.jna.wintools.TouchUtils;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.controls.basic.RepaintListener;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorComponent;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.View;
import com.tiani.jvision.overlay.OverlayFontConfig;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.ImageFilterNode;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.jvision.vis.VisMouseHandler;
import com.tiani.util.message.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Vis2
extends MultiMonitorComponent
implements RepaintListener {
    private static final ALogger log = ALogger.getLogger(Vis2.class);
    private static final Color COLOR_NOSELECT = new Color(0x303030);
    public static final Color COLOR_SELECT = new Color(0xD0D0D0);
    public static final Color COLOR_LASTMODIFIED = new Color(3760479);
    public static final Color COLOR_FILLED = UIManager.getColor("color.secondary.5");
    public static final Color LIGHT_BLUE = new Color(209, 220, 240);
    private static IAIconFactory iconFactoryBw = IAIconFactory.createMonochromeIconFactory(22);
    private static IAIconFactory iconFactoryBwScaled = IAIconFactory.createMonochromeIconFactory(66);
    public static final PIcon ICON_JPEGLOSSY_ORIGINAL = iconFactoryBwScaled.loadIcon("jpeglossy.svg");
    public static final PIcon ICON_SECONDARYCAPTURE_ORIGINAL = iconFactoryBwScaled.loadIcon("seqlabel_secondarycapture.svg");
    private static final PIcon ICON_JPEGLOSSY = iconFactoryBw.loadIcon("jpeglossy.svg");
    private static final PIcon ICON_SECONDARYCAPTURE_UNSAVED = iconFactoryBw.loadIcon("seqlabel_notsaved.svg");
    private static final PIcon ICON_SECONDARYCAPTURE_SAVED = iconFactoryBw.loadIcon("seqlabel_secondarycapture.svg");
    private static final PIcon ICON_STOP = iconFactoryBwScaled.loadIcon("stops.svg");
    private static final PIcon ICON_INCORRECTLYORIENTED = IAIconFactory.DEFAULT_FACTORY.loadIcon("incorrectlyoriented.svg");
    private static final PIcon ICON_REGISTRATION_VERIFIED = IAIconFactory.DEFAULT_FACTORY.loadIcon("RegistrationVerified.svg");
    private static final PIcon ICON_REGISTRATION_UNVERIFIED = IAIconFactory.DEFAULT_FACTORY.loadIcon("RegistrationUnverified.svg");
    private static final PIcon ICON_EXTERNAL_PRESSTATE = iconFactoryBw.loadIcon("neutral_presstate_hr.svg");
    private static final PIcon ICON_RWVM_AVAILABLE = IAIconFactory.DEFAULT_FACTORY.loadIcon("rwvm_available.svg");
    private static final PIcon ICON_RWVM_ACTIVE = IAIconFactory.DEFAULT_FACTORY.loadIcon("rwvm_active.svg");
    private static final PIcon ICON_FRAMERATE_WARNING = IAIconFactory.DEFAULT_FACTORY.loadIcon("snail.png");
    private static final PIcon ICON_FILTER_ACTIVE = IAIconFactory.DEFAULT_FACTORY.loadIcon("overlay_filter.svg");
    private static final PIcon ICON_STATUS_4D_TEMPORAL = iconFactoryBw.loadIcon("hotregion_4d_temporal.svg");
    private static final PIcon ICON_STATUS_4D_SPATIAL = iconFactoryBw.loadIcon("hotregion_4d_spatial.svg");
    protected static final boolean whiteBackground = Config.impaxee.jvision.DISPLAY.whiteBackground.get();
    private static final int maxHROutsideWidth = 24;
    private static final int maxHROutsideHeight = 24;
    public static volatile boolean countFirstImage;
    private static double sliceSkipPerDXRelMinus;
    private static double sliceSkipPerDXRelPlus;
    private static int start4Dindex;
    private static int startIndex;
    private static int sliceCount;
    private static IDisplaySet displaySet;
    private static ThreadLocal<Pair<OutlineFont, RGBBufferedImageHolder>> fourDStatusRendering;
    private int xPosition;
    public static final Point zoomRectStartPt;
    public static final Point zoomRectEndPt;
    private boolean isZoomRectActive = false;
    private VisDisplay2 visDisplay;
    private VisData data;
    private VisMouseHandler mouseHandler;
    private VisHRSet hotRegions;
    private boolean isHRPaintMode = false;
    private boolean ignorePaint = false;
    private boolean hrInside = true;
    private int fourDtextWidth;
    private int fourDtextHeight;
    private Point mousePosition;

    static {
        fourDStatusRendering = new ThreadLocal<Pair<OutlineFont, RGBBufferedImageHolder>>(){

            @Override
            protected Pair<OutlineFont, RGBBufferedImageHolder> initialValue() {
                BufferedImage bufferedImage = new BufferedImage(80, 32, 2);
                RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(bufferedImage);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.setFont(OverlayFontConfig.displayFont);
                OutlineFont outlineFont = new OutlineFontCache(1, LIGHT_BLUE).getOutlineFont(OverlayFontConfig.displayFont, graphics.getFontMetrics());
                return Pair.of((Object)outlineFont, (Object)((Object)rGBBufferedImageHolder));
            }
        };
        zoomRectStartPt = new Point();
        zoomRectEndPt = new Point();
    }

    public Vis2(VisDisplay2 visDisplay2) {
        this.visDisplay = visDisplay2;
        this.setOpaque(false);
        this.setLayout(null);
        this.mouseHandler = new VisMouseHandler(this);
    }

    public void destruct() {
        this.clear(true);
        this.mouseHandler.destruct();
        if (this.hotRegions != null) {
            this.hotRegions.destroy();
            this.hotRegions = null;
        }
        this.mouseHandler = null;
    }

    public void clear(boolean bl) {
        this.setData(null, false);
        this.removeHRs();
        if (bl) {
            this.repaint();
        }
    }

    public VisDisplay2 getVisDisplay() {
        return this.visDisplay;
    }

    public JComponent getContentPane() {
        return this.mouseHandler;
    }

    public void setHRPaintMode(boolean bl) {
        this.setHRPaintMode(bl, true);
    }

    public void setHRPaintMode(boolean bl, boolean bl2) {
        if (bl == this.isHRPaintMode) {
            return;
        }
        this.isHRPaintMode = bl;
        if (bl2 && this.hotRegions != null) {
            for (HotRegion hotRegion : this.hotRegions) {
                hotRegion.setRepaintListener(this.isHRPaintMode ? this : null);
            }
        }
    }

    public VisMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public IViewMouseHandler getViewMouseHandler() {
        if (this.data == null) {
            return null;
        }
        if (this.data.getView() == null) {
            return null;
        }
        return this.data.getView().getMouseHandler();
    }

    public VisHRSet getHRSet() {
        return this.hotRegions;
    }

    public void setHRSet(VisHRSet visHRSet) {
        this.hotRegions = visHRSet;
    }

    public boolean isSelected() {
        if (this.data == null) {
            return false;
        }
        return this.data.isSelected();
    }

    public boolean makeTheLastModified() {
        if (VisData.isBlockLastModifiedChange()) {
            return false;
        }
        this.requestFocusInWindow();
        if (this.data == null) {
            return false;
        }
        VisData visData = VisData.getLastModified();
        this.data.makeTheLastModified();
        if (visData != null && visData.getVisual() != this) {
            if (visData.getVisual() != null) {
                visData.getVisual().repaintBorder();
            }
            return true;
        }
        return false;
    }

    public void startZoomRect(int n, int n2) {
        Vis2.zoomRectStartPt.x = n;
        Vis2.zoomRectStartPt.y = n2;
        Vis2.zoomRectEndPt.x = Vis2.zoomRectStartPt.x;
        Vis2.zoomRectEndPt.y = Vis2.zoomRectStartPt.y;
        this.isZoomRectActive = true;
    }

    public void dragZoomRect(int n, int n2) {
        int n3;
        int n4 = n - Vis2.zoomRectStartPt.x;
        int n5 = n2 - Vis2.zoomRectStartPt.y;
        float f = (float)this.getSize().width / (float)this.getSize().height;
        if (f > 1.0f || (double)(f - 1.0f) > 0.01 && Math.abs(n4) > Math.abs(n5)) {
            Vis2.zoomRectEndPt.x = n;
            n3 = Math.abs(Math.round((float)(Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x) / f));
            if (n5 < 0) {
                n3 = -n3;
            }
            Vis2.zoomRectEndPt.y = Vis2.zoomRectStartPt.y + n3;
        } else {
            Vis2.zoomRectEndPt.y = n2;
            n3 = Math.abs(Math.round((float)(Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y) * f));
            if (n4 < 0) {
                n3 = -n3;
            }
            Vis2.zoomRectEndPt.x = Vis2.zoomRectStartPt.x + n3;
        }
        n3 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (Vis2.zoomRectEndPt.x < 0) {
            Vis2.zoomRectEndPt.x = 0;
            bl = true;
        } else if (Vis2.zoomRectEndPt.x >= this.getSize().width) {
            Vis2.zoomRectEndPt.x = this.getSize().width - 1;
            bl = true;
        } else if (Vis2.zoomRectEndPt.y < 0) {
            Vis2.zoomRectEndPt.y = 0;
            bl2 = true;
        } else if (Vis2.zoomRectEndPt.y >= this.getSize().height) {
            Vis2.zoomRectEndPt.y = this.getSize().height - 1;
            bl2 = true;
        }
        if (bl) {
            n3 = Math.abs(Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x);
            n6 = Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y > 0 ? 1 : -1;
            n6 = (int)((float)(n6 * n3) / f);
            Vis2.zoomRectEndPt.y = Vis2.zoomRectStartPt.y + n6;
        } else if (bl2) {
            n6 = Math.abs(Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y);
            n3 = Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x > 0 ? 1 : -1;
            n3 = (int)((float)(n6 * n3) * f);
            Vis2.zoomRectEndPt.x = Vis2.zoomRectStartPt.x + n3;
        }
    }

    public void stopZoomRect(int n, int n2) {
        this.isZoomRectActive = false;
    }

    public View getView() {
        if (this.data != null) {
            return this.data.getView();
        }
        return null;
    }

    public VisData getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean canShowMenu() {
        if (this.hasData() && this.data != null) {
            return !this.data.isVideo();
        }
        return false;
    }

    public boolean canHandleMouseWheel() {
        if (this.hasData() && this.data != null) {
            return !this.data.isVideo();
        }
        return false;
    }

    public void setData(VisData visData, boolean bl) {
        boolean bl2 = this.ignorePaint = !bl;
        if (this.data == visData && this.data != null && this.data.getVisual() != this) {
            this.data.setView(this);
            return;
        }
        VisData visData2 = this.data;
        this.data = visData;
        if (visData2 != null && this.data == null) {
            visData2.setView(null);
        }
        this.onDataChanged();
        if (this.data != null) {
            this.data.setView(this);
        }
        if (this.data != null && this.data.getView() != null && this.data.getView().getMouseHandler() != null) {
            Rectangle rectangle = this.getBounds();
            this.data.getView().getMouseHandler().setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.data.setVisualBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.ignorePaint = false;
        this.isHRPaintMode = false;
    }

    public void onDataChanged() {
        if (VisDisplay2.pjvi1754_isNavigDragActive() && this.visDisplay == VisDisplay2.getNavigDrawOwner()) {
            return;
        }
        VisHRSet visHRSet = null;
        if (this.data != null && this.data.getView() != null) {
            visHRSet = this.data.getView().getHRSet(this.hotRegions, this);
        }
        if (this.hotRegions != null) {
            if (this.hotRegions == visHRSet) {
                this.hotRegions.setParent(this);
                return;
            }
            this.hotRegions.destroy();
            this.hotRegions = null;
        }
        this.hotRegions = visHRSet;
        if (this.hotRegions == null) {
            return;
        }
        this.updateHROutsideMode();
        this.addHRs();
    }

    public void paintNow() {
        if (!this.ignorePaint) {
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            this.paint(graphics);
            graphics.dispose();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isHRPaintMode) {
            this.paintComponent(graphics);
        } else {
            super.paint(graphics);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        this.render(graphics, n, n2);
    }

    @Override
    public void paintComponents(Graphics graphics) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        super.paintComponents(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        super.update(graphics);
    }

    @Override
    public void repaint() {
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        super.repaint();
    }

    @Override
    public boolean handleComponentRepaint(Component component) {
        if (!this.isHRPaintMode) {
            return false;
        }
        if (this.getView() != null) {
            this.getView().setImgInvalid(true);
        }
        this.repaint();
        return true;
    }

    private void renderEmpty(Graphics graphics, int n, int n2) {
        if (whiteBackground) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.fillRect(0, 0, n, n2);
    }

    private void render(Graphics graphics, int n, int n2) {
        try {
            int n3;
            View view = this.getView();
            if (this.data == null || !this.data.isImageAvailable() || !this.data.isLoaded()) {
                this.renderEmpty(graphics, n, n2);
                this.paintVisBorder(graphics);
                if (view != null) {
                    this.paintProgress(view, graphics, n, n2);
                    view.paintPoster(graphics);
                }
                return;
            }
            Collection<PIcon> collection = null;
            if (!VisDisplay2.pjvi1754_isNavigDragActive()) {
                collection = this.evaluateStatusIcons(view);
            }
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = this.data.getImage();
            }
            catch (Throwable throwable) {
                log.error("Vis2", throwable);
                ExceptionHandlerFactory.getInstance().handleException(throwable);
                bufferedImage = null;
            }
            this.paintVisBorder(graphics);
            Graphics graphics2 = graphics;
            if (bufferedImage != null) {
                if (!this.isHRPaintMode && this.data.isImageAvailable()) {
                    graphics.drawImage(bufferedImage, 1, 1, null);
                    this.data.getFrameData().getParent().getParent().displayed();
                    if (countFirstImage) {
                        try {
                            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
                            if (iHanging != null && iHanging.getStudyContainer() != null && iHanging.getStudyContainer().getBaseStudy() == this.data.getStudyData()) {
                                countFirstImage = false;
                                PerformanceProfiler.getInstance().setFirstDisplay(this.data.getImageInformation().getStudyInstanceUID());
                            }
                        }
                        catch (Exception exception) {
                            log.warn("Performance profiler error", (Throwable)exception);
                        }
                    }
                }
                this.paintProgress(view, graphics, n, n2);
                if (this.isHRPaintMode) {
                    graphics = bufferedImage.getGraphics();
                    this.paintChildren(graphics);
                }
            }
            if (CollectionUtils.isNotEmpty(collection)) {
                this.xPosition = n / 3;
                int n4 = (n - 2) / 7;
                n3 = (n2 - 2) / 7;
                for (PIcon pIcon : collection) {
                    this.drawIcon(graphics, pIcon, n4, n3, n2);
                    if (pIcon != ICON_STATUS_4D_TEMPORAL) continue;
                    Pair<OutlineFont, RGBBufferedImageHolder> pair = fourDStatusRendering.get();
                    graphics.drawImage(((RGBBufferedImageHolder)((Object)pair.getRight())).image, this.xPosition - 4, n2 - this.fourDtextHeight - (pIcon.getIconHeight() - this.fourDtextHeight) / 2, null);
                    this.xPosition += this.fourDtextWidth + 3;
                }
            }
            if (this.data != null && this.data.isStopSignTimerRunning()) {
                int n5 = ICON_STOP.getIconWidth();
                n3 = ICON_STOP.getIconHeight();
                int n6 = 0;
                n6 = n5 < n3 ? n5 : n3;
                if (n5 < n6) {
                    n6 = n5;
                }
                if (n3 < n6) {
                    n6 = n3;
                }
                if (this.data.isFirstInParent()) {
                    graphics.drawImage(ICON_STOP.getImage(), n6 / 4, n6 / 4, n6, n6, null);
                }
                if (this.data.isLastInParent()) {
                    graphics.drawImage(ICON_STOP.getImage(), n - n6 - n6 / 4 - 1, n2 - n6 - n6 / 4 - 1, n6, n6, null);
                }
            }
            if (this.isZoomRectActive) {
                graphics.setColor(Color.red);
                int n7 = Vis2.zoomRectStartPt.x;
                n3 = Vis2.zoomRectStartPt.y;
                if (Vis2.zoomRectEndPt.x < n7) {
                    n7 = Vis2.zoomRectEndPt.x;
                }
                if (Vis2.zoomRectEndPt.y < n3) {
                    n3 = Vis2.zoomRectEndPt.y;
                }
                int n8 = Math.abs(Vis2.zoomRectEndPt.x - Vis2.zoomRectStartPt.x + 1);
                int n9 = Math.abs(Vis2.zoomRectEndPt.y - Vis2.zoomRectStartPt.y + 1);
                graphics.drawRect(n7, n3, n8, n9);
            }
            if (this.isHRPaintMode) {
                graphics2.drawImage(bufferedImage, 1, 1, null);
            }
        }
        catch (Exception exception) {
            log.error("--- could not paint vis content!", (Throwable)exception);
        }
    }

    private void drawIcon(Graphics graphics, PIcon pIcon, int n, int n2, int n3) {
        int n4 = Math.min(pIcon.getIconWidth(), n2);
        int n5 = Math.min(pIcon.getIconHeight(), n);
        graphics.drawImage(pIcon.getImage(), this.xPosition, n3 - n5 - 2, n4, n5, null);
        this.xPosition += n4 + 2;
    }

    private Collection<PIcon> evaluateStatusIcons(View view) {
        ArrayList<PIcon> arrayList = new ArrayList<PIcon>();
        VisData visData = this.data;
        if (visData != null && !VisDisplay2.pjvi1754_isNavigDragActive()) {
            IDisplaySetStatusIcon iDisplaySetStatusIcon;
            VisDisplayData visDisplayData;
            Pair<OutlineFont, RGBBufferedImageHolder> pair;
            Object object;
            Object object2;
            IKeyImageInfo iKeyImageInfo;
            boolean bl = view.isCine();
            if (!this.getVisDisplay().isAggregating() && !bl && (iKeyImageInfo = this.getData().getFrameData().getKeyImageInfo()) != null) {
                object2 = KeyImageType.values();
                int n = ((KeyImageType[])object2).length;
                int n2 = 0;
                while (n2 < n) {
                    object = object2[n2];
                    if (iKeyImageInfo.isMarked((KeyImageType)((Object)object))) {
                        arrayList.add(((KeyImageType)((Object)object)).getIcon());
                    }
                    ++n2;
                }
            }
            if (!visData.isCorrectlyOriented()) {
                arrayList.add(ICON_INCORRECTLYORIENTED);
            }
            if ((iKeyImageInfo = this.getVisDisplay().getSynchronizationManager().getStatusIcon(this)) != null) {
                arrayList.add((PIcon)iKeyImageInfo);
            }
            object = visData.getView().getRenderer();
            if (!bl) {
                VisData visData2;
                IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
                if (iPatientRepresentation != null && iPatientRepresentation.getPatientData().existsWorldToWorldTransforms() && (visData2 = VisData.getLastModified()) != null && (object2 = this.getView().getWorldToWorldTransformer().getConversionType(visData.getImageInformation().getFrameOfReferenceUID(), visData2.getImageInformation().getFrameOfReferenceUID())) != null) {
                    pair = object2 == IWorldToWorldTransform.RegistrationType.UNVERIFIED ? ICON_REGISTRATION_UNVERIFIED : ICON_REGISTRATION_VERIFIED;
                    arrayList.add((PIcon)pair);
                }
                Renderer renderer = null;
                if (object != null) {
                    renderer = object.getLeaf();
                }
                if (renderer instanceof IRDCRenderer && (pair = (object2 = (IRDCRenderer)((Object)renderer)).getCurrentFramePresentationState()) != null && pair.isExternal() && !pair.isTemporary()) {
                    arrayList.add(ICON_EXTERNAL_PRESSTATE);
                }
            }
            if (view.getImageState().getCurrentValueMapping() instanceof RealWorldValueMapping) {
                arrayList.add(ICON_RWVM_ACTIVE);
            } else if (view.getImageInformation() != null && !view.getImageInformation().getRealWorldValueMappings().isEmpty()) {
                arrayList.add(ICON_RWVM_AVAILABLE);
            }
            if (visData.isSecondaryCapture()) {
                arrayList.add(visData.isSecondaryCaptureSaved() ? ICON_SECONDARYCAPTURE_SAVED : ICON_SECONDARYCAPTURE_UNSAVED);
            }
            if (visData.isLossy()) {
                arrayList.add(ICON_JPEGLOSSY);
            }
            if (bl && this.visDisplay.getFrameRateWarning()) {
                arrayList.add(ICON_FRAMERATE_WARNING);
            }
            if (!bl && object instanceof ImageFilterNode && ((ImageFilterNode)object).isFilterActive()) {
                arrayList.add(ICON_FILTER_ACTIVE);
            }
            if ((iKeyImageInfo = (visDisplayData = visData.getParent()).getDisplaySet().getOneObject().getStatusIcon()) != null) {
                arrayList.add((PIcon)iKeyImageInfo);
            }
            if ((iDisplaySetStatusIcon = visDisplayData.getDisplaySet().getStatusIcon()) != null && (iKeyImageInfo = iDisplaySetStatusIcon.getDisplayIcon()) != null) {
                arrayList.add((PIcon)iKeyImageInfo);
            }
            if ((iKeyImageInfo = visDisplayData.getDisplayPlugin().getStatusIcon()) != null) {
                arrayList.add((PIcon)iKeyImageInfo);
            }
            if (this.is4D()) {
                object2 = visDisplayData.get4DProperties();
                iKeyImageInfo = object2.isPrimaryNavigationInSpace() ? ICON_STATUS_4D_TEMPORAL : ICON_STATUS_4D_SPATIAL;
                arrayList.add((PIcon)iKeyImageInfo);
                if (iKeyImageInfo == ICON_STATUS_4D_TEMPORAL) {
                    pair = fourDStatusRendering.get();
                    FontMetrics fontMetrics = ((OutlineFont)pair.getLeft()).getFontMetrics();
                    String string = String.valueOf(Integer.toString(object2.getSecondaryIndex() + 1)) + '/' + Integer.toString(object2.getNumberOf4DRuns());
                    this.fourDtextWidth = fontMetrics.stringWidth(string);
                    this.fourDtextHeight = fontMetrics.getHeight();
                    ((RGBBufferedImageHolder)((Object)pair.getRight())).clear();
                    ((OutlineFont)pair.getLeft()).drawBytes(string.toCharArray(), (IImageHolder)pair.getRight(), 0, this.fourDtextHeight - 4);
                }
            }
        }
        return arrayList;
    }

    public void showStopSign() {
        this.getData().showStopSign();
    }

    public static void print(VisData visData, Graphics graphics, int n, int n2, View.OverlayMode overlayMode) {
        try {
            int n3;
            int n4;
            int n5;
            if (graphics == null) {
                return;
            }
            if (visData == null) {
                return;
            }
            Rectangle rectangle = new Rectangle(visData.getView().getBoundsForVis());
            visData.getView().setBounds(0, 0, n, n2);
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = visData.captureImage();
            }
            catch (Throwable throwable) {
                log.error("Vis2", throwable);
                bufferedImage = null;
            }
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 1, 1, null);
            }
            if (!visData.isCorrectlyOriented()) {
                int n6 = ICON_INCORRECTLYORIENTED.getIconWidth();
                n5 = ICON_INCORRECTLYORIENTED.getIconHeight();
                n4 = (n - 2) / 7;
                n3 = (n2 - 2) / 7;
                if (n6 > n4) {
                    n6 = n4;
                }
                if (n5 > n3) {
                    n5 = n3;
                }
                graphics.drawImage(ICON_INCORRECTLYORIENTED.getImage(), n / 3, n2 - n5 - 2, n6, n5, null);
            }
            if (visData.isLossy()) {
                int n7 = ICON_JPEGLOSSY.getIconWidth();
                n5 = ICON_JPEGLOSSY.getIconHeight();
                n4 = (n - 2) / 5;
                n3 = (n2 - 2) / 5;
                if (n4 > n7) {
                    n4 = n7;
                }
                if (n3 > n5) {
                    n3 = n5;
                }
                n7 = n4;
                n5 = n3;
                graphics.drawImage(ICON_JPEGLOSSY.getImage(), n / 2 - n7 / 2, n2 - n5 - 2, n7, n5, null);
            }
            visData.getView().setBoundsForVis(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        catch (Exception exception) {
            log.error("--- could not paint vis content!", (Throwable)exception);
        }
    }

    private void paintProgress(View view, Graphics graphics, int n, int n2) {
        Component component = view.getProgressDisplay();
        if (component != null) {
            int n3 = Math.min(n2 / 2 - 10, GUI.getScaledDiagnosticInt((int)16));
            if (n3 < 0) {
                n3 = 0;
            }
            component.setBounds(0, 0, n - 10, n3);
            graphics.translate(5, n2 - n3 - 10);
            component.paint(graphics);
            graphics.translate(-5, -(n2 - n3 - 10));
        }
    }

    public void repaintBorder() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paintVisBorder(graphics);
        graphics.dispose();
    }

    public void paintVisBorder(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (!this.isEnabled() || !this.isVisible()) {
            return;
        }
        if (this.getView() == null || !this.getView().visBorderEnabled()) {
            return;
        }
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        int n3 = 0;
        int n4 = 0;
        if (this.data == null) {
            graphics.setColor(COLOR_NOSELECT);
            graphics.drawRect(n3, n4, n - 1, n2 - 1);
            return;
        }
        if (VisData.getLastModified() == this.data) {
            int n5 = 21;
            int n6 = 21;
            float f = (float)n / (float)n5;
            float f2 = (float)n2 / (float)n6;
            int n7 = n - 1;
            int n8 = n2 - 1;
            boolean bl = this.isSelected();
            if (bl) {
                graphics.setColor(COLOR_SELECT);
            } else {
                graphics.setColor(COLOR_NOSELECT);
            }
            graphics.drawLine(n3, n4, n3 + n7, n4);
            graphics.drawLine(n3, n4 + n2 - 1, n3 + n7, n4 + n2 - 1);
            graphics.setColor(COLOR_LASTMODIFIED);
            float f3 = 0.5f;
            int n9 = 0;
            while (n9 < n5) {
                int n10 = (int)f3;
                f3 += f;
                f3 += f;
                int n11 = n10 + (int)f;
                if (n11 > n7) {
                    n11 = n7;
                }
                graphics.drawLine(n3 + n10, n4, n3 + n11, n4);
                graphics.drawLine(n3 + n10, n4 + n2 - 1, n3 + n11, n4 + n2 - 1);
                n9 += 2;
            }
            if (bl) {
                graphics.setColor(COLOR_SELECT);
            } else {
                graphics.setColor(COLOR_NOSELECT);
            }
            graphics.drawLine(n3, n4, n3, n4 + n8);
            graphics.drawLine(n3 + n - 1, n4, n3 + n - 1, n4 + n8);
            graphics.setColor(COLOR_LASTMODIFIED);
            float f4 = 0.5f;
            int n12 = 0;
            while (n12 < n6) {
                int n13 = (int)f4;
                f4 += f2;
                f4 += f2;
                int n14 = n13 + (int)f2;
                if (n14 > n8) {
                    n14 = n8;
                }
                graphics.drawLine(n3, n4 + n13, n3, n4 + n14);
                graphics.drawLine(n3 + n - 1, n4 + n13, n3 + n - 1, n4 + n14);
                n12 += 2;
            }
            return;
        }
        graphics.setColor(this.isSelected() ? COLOR_FILLED : COLOR_NOSELECT);
        graphics.drawRect(n3, n4, n - 1, n2 - 1);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getBounds().width;
        int n6 = this.getBounds().height;
        int n7 = this.getBounds().x;
        int n8 = this.getBounds().y;
        if (n5 == n3 && n6 == n4 && n7 == n && n8 == n2) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
        this.mouseHandler.setBounds(n, n2, n3, n4);
        if (this.data != null && this.data.getView() != null) {
            this.data.getView().getMouseHandler().setBounds(this.getHROutsideWidth(), this.getHROutsideHeight(), n3, n4);
        }
        this.geometryChanged(n, n2, n3, n4, n5, n6);
    }

    private void geometryChanged(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.data != null && (n5 != n3 || n6 != n4)) {
            if (this.visDisplay != null && this.visDisplay.getLyt().allVisSameSize()) {
                if (this.visDisplay.getVisView(0) == this) {
                    this.visDisplay.resizeVisuals(n3, n4);
                }
            } else {
                this.data.setVisualBounds(n, n2, n3, n4);
            }
        }
        this.relayout();
    }

    protected void relayout() {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        if (this.hotRegions != null) {
            this.hotRegions.relayout(n, n2, this.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().areHotRegionsInside());
        }
    }

    public void removeHRs() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof HotRegion) {
                HotRegion hotRegion = (HotRegion)componentArray[n];
                hotRegion.reset();
                this.remove(componentArray[n]);
            }
            ++n;
        }
    }

    public void addHRs() {
        if (TouchUtils.supportsTouchInput() || this.getData() != null && !this.getData().getView().addingHRsAllowed()) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof HotRegion) {
                this.remove(componentArray[n]);
            }
            ++n;
        }
        if (this.hotRegions == null) {
            return;
        }
        n = (int)Config.impaxee.jvision.HR_VISUAL.MinSize.get();
        if (this.getWidth() < n || this.getHeight() < n) {
            return;
        }
        this.hotRegions.relayout(this.getBounds().width, this.getBounds().height, this.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().areHotRegionsInside());
        for (HotRegion hotRegion : this.hotRegions) {
            if (this.visDisplay != null && !this.getVisDisplay().isHotRegionsEnabled()) continue;
            hotRegion.setRepaintListener(this);
            this.add(hotRegion);
        }
        if (this.visDisplay != null && this.visDisplay.getData() != null) {
            this.setZoomHREnabled(this.visDisplay.getData().getZoomMode() != ZoomMode.TRUESIZE);
        }
        this.repaint();
    }

    public void setZoomHREnabled(boolean bl) {
        if (this.hotRegions == null) {
            return;
        }
        HotRegion hotRegion = this.hotRegions.getHR("ZOOM");
        if (hotRegion != null) {
            hotRegion.setVisible(bl);
            hotRegion.setEnabled(bl);
        }
    }

    boolean isInPrimaryOrder() {
        return this.data != null && this.data.getParent().get4DProperties().isPrimaryNavigationInSpace();
    }

    public boolean is4D() {
        return this.data != null && this.data.is4D();
    }

    public void hotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.data == null || this.data.getView() == null) {
            return;
        }
        if (hotRegion.getName().equals("NAVIG_LEFT")) {
            this.getVisDisplay().startNavigDrag();
            this.getVisDisplay().doNavigDrag(-32);
            return;
        }
        if ("4D_SPATIAL".equals(hotRegion.getName()) || "4D_TEMPORAL".equals(hotRegion.getName())) {
            if (hotRegion.isVisible()) {
                start4Dindex = this.getData().getParent().get4DProperties().getSecondaryIndex();
                this.mousePosition = mouseEvent.getPoint();
            }
            return;
        }
        if (hotRegion.getName().equals("NAVIG_RIGHT")) {
            this.getVisDisplay().startNavigDrag();
            this.getVisDisplay().doNavigDrag(32);
            return;
        }
        if (hotRegion.getName().equals("SLICETHROUGH") && this.isSliceThroughHotRegionSupported()) {
            Rectangle rectangle = this.getMouseHandler().getBounds();
            double d = mouseEvent.getX() + hotRegion.getBounds().x;
            double d2 = rectangle.getWidth() - d;
            VisDisplay2 visDisplay2 = this.getVisDisplay();
            Vis2.initSliceSkips(visDisplay2, d, d2);
            return;
        }
        if (hotRegion.getName().equals("WINDOW_LEVEL")) {
            this.handleWindowingLevelEvent(mouseEvent);
            return;
        }
        this.removeHRs();
        this.repaint();
        this.data.getView().hotRegionPressed(hotRegion, mouseEvent);
    }

    private boolean isSliceThroughHotRegionSupported() {
        View view = this.getView();
        return view != null && view.isSliceThroughHotRegionSupported();
    }

    private static void initSliceSkips(VisDisplay2 visDisplay2, double d, double d2) {
        int n = visDisplay2.getNavigationHandler().getCurrentDragPosition();
        sliceCount = visDisplay2.getNavigationHandler().getDragPositionCount();
        sliceSkipPerDXRelPlus = Vis2.computeSliceSkip(sliceCount - n - 1, d2);
        sliceSkipPerDXRelMinus = Vis2.computeSliceSkip(n, d);
        startIndex = n;
        displaySet = visDisplay2.getData().getDisplaySet();
    }

    private static void updateSliceSkips(VisDisplay2 visDisplay2, boolean bl) {
        int n = visDisplay2.getNavigationHandler().getDragPositionCount();
        int n2 = bl ? n : -sliceCount;
        startIndex += n2;
        displaySet = visDisplay2.getData().getDisplaySet();
        sliceCount = n;
    }

    private static double computeSliceSkip(int n, double d) {
        if (n == 0) {
            return 1.0;
        }
        return (double)n / d;
    }

    public void hotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.data == null || this.data.getView() == null) {
            return;
        }
        if (hotRegion.getName().equals("NAVIG_LEFT") || hotRegion.getName().equals("NAVIG_RIGHT")) {
            this.getVisDisplay().stopNavigDrag();
        } else {
            if ("4D_SPATIAL".equals(hotRegion.getName()) || "4D_TEMPORAL".equals(hotRegion.getName())) {
                if (hotRegion.isVisible() && this.mousePosition.distance(mouseEvent.getPoint()) < 2.0) {
                    this.switch4DHotRegion();
                }
                return;
            }
            if (hotRegion.getName().equals("SLICETHROUGH") && this.isSliceThroughHotRegionSupported()) {
                return;
            }
            if (hotRegion.getName().equals("WINDOW_LEVEL")) {
                this.handleWindowingLevelEvent(mouseEvent);
                return;
            }
        }
        this.data.getView().hotRegionReleased(hotRegion, mouseEvent);
    }

    public void switch4DHotRegion() {
        if (!this.visDisplay.getData().getDisplaySet().isRegular4D()) {
            return;
        }
        AbstractPAction.notifyNonPActionPerformed("4D_DIMENSION_SWITCH");
        I4DProperties i4DProperties = this.data.getParent().get4DProperties();
        if (i4DProperties.isUpdateOn4DNavigationRequired()) {
            i4DProperties.setPrimaryNavigationInSpace(!i4DProperties.isPrimaryNavigationInSpace());
            for (Vis2 vis2 : this.visDisplay.getVisViews()) {
                HotRegion hotRegion;
                HotRegion hotRegion2;
                if (i4DProperties.isPrimaryNavigationInSpace()) {
                    hotRegion2 = vis2.getHRSet().getHR("4D_SPATIAL");
                    if (hotRegion2 == null) continue;
                    hotRegion = hotRegion2;
                    hotRegion.setImage(VisHRSet.ICON_4D_TEMPORAL);
                    hotRegion.setName("4D_TEMPORAL");
                } else {
                    hotRegion2 = vis2.getHRSet().getHR("4D_TEMPORAL");
                    if (hotRegion2 == null) continue;
                    hotRegion = hotRegion2;
                    hotRegion.setImage(VisHRSet.ICON_4D_SPATIAL);
                    hotRegion.setName("4D_SPATIAL");
                }
                vis2.getHRSet().replaceHR(hotRegion2, hotRegion);
            }
            this.visDisplay.updateData(true);
            this.visDisplay.updateScrollBar();
            this.getView().updateMapping(true);
            this.visDisplay.repaint();
        }
    }

    public void perform4DNavigation(int n, boolean bl) {
        I4DProperties i4DProperties = this.data.getParent().get4DProperties();
        if (n < 0) {
            n = 0;
        } else if (n >= i4DProperties.getNumberOf4DRuns()) {
            n = i4DProperties.getNumberOf4DRuns() - 1;
        }
        if (n == i4DProperties.getSecondaryIndex()) {
            return;
        }
        i4DProperties.setSecondaryIndex(n);
        if (i4DProperties.isUpdateOn4DNavigationRequired()) {
            this.makeTheLastModified();
            this.getVisDisplay().updateData(true);
            this.getVisDisplay().updateScrollBar();
            this.getView().updateMapping(true);
            if (bl) {
                this.getVisDisplay().repaint();
            }
            this.getView().invalidate();
        }
    }

    public void hotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        if (this.data == null || this.data.getView() == null) {
            return;
        }
        if (hotRegion.getName().equals("NAVIG_LEFT") || hotRegion.getName().equals("NAVIG_RIGHT")) {
            return;
        }
        if ("4D_SPATIAL".equals(hotRegion.getName()) || "4D_TEMPORAL".equals(hotRegion.getName())) {
            if (hotRegion.isVisible()) {
                int n5 = this.getVisDisplay().getHeight() / this.getData().getParent().get4DProperties().getNumberOf4DRuns();
                if (n5 < 5) {
                    n5 = 5;
                } else if (n5 > 50) {
                    n5 = 50;
                }
                int n6 = -n2 / n5;
                this.perform4DNavigation(start4Dindex + n6, true);
            }
            return;
        }
        if (hotRegion.getName().equals("SLICETHROUGH") && this.isSliceThroughHotRegionSupported()) {
            IDisplaySet iDisplaySet = this.data.getParent().getDisplaySet();
            if (!displaySet.equals(iDisplaySet)) {
                Vis2.updateSliceSkips(this.visDisplay, n3 < 0);
            }
            int n7 = (int)Math.round((double)n * (n > 0 ? sliceSkipPerDXRelPlus : sliceSkipPerDXRelMinus)) + startIndex;
            int n8 = this.getVisDisplay().getNavigationHandler().convertToMouseWheelMovement(n7);
            if (n8 != 0) {
                this.getVisDisplay().handleMouseWheelMovement(n8, true);
            }
            return;
        }
        if (hotRegion.getName().equals("WINDOW_LEVEL")) {
            this.handleWindowingLevelEvent(mouseEvent);
            return;
        }
        this.data.getView().hotRegionDragged(hotRegion, mouseEvent, n, n2, n3, n4);
    }

    private void handleWindowingLevelEvent(MouseEvent mouseEvent) {
        int n = ModifierKeys.isCtrl((InputEvent)mouseEvent) ? 1 : 0;
        TEvent tEvent = new TEvent();
        tEvent.id = 62;
        this.getView().handleTEvent(tEvent, mouseEvent, n);
    }

    public int getHROutsideWidth() {
        int n = this.getBounds().width / 8;
        if (n > 24) {
            n = 24;
        }
        return n;
    }

    public int getHROutsideHeight() {
        int n = this.getBounds().width / 8;
        if (n > 24) {
            n = 24;
        }
        return n;
    }

    public void updateHROutsideMode() {
        boolean bl = true;
        if (this.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo() != null) {
            bl = this.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().areHotRegionsInside();
        }
        this.updateHROutsideMode(bl);
    }

    public void updateHROutsideMode(boolean bl) {
        if (bl == this.hrInside) {
            return;
        }
        this.hrInside = bl;
        float f = 0.0f;
        if (!bl) {
            f = VisHRSet.alphaIn / 2.0f;
        } else {
            f = VisHRSet.alphaOut;
            Object object = this.getComponents();
            int n = 0;
            while (n < ((Component[])object).length) {
                if (object[n] instanceof HotRegion && object[n].isEnabled()) {
                    ((Component)object[n]).setVisible(true);
                }
                ++n;
            }
        }
        if (this.hotRegions != null) {
            for (Object object : this.hotRegions) {
                ((HotRegion)object).setAlphaOut(f);
                ((HotRegion)object).setAlpha(f);
                ((HotRegion)object).repaint();
            }
        }
    }

    public void refreshHRs() {
        if (this.visDisplay != null) {
            this.visDisplay.repaint();
        }
    }

    public List<VisData> getVisData(boolean bl, boolean bl2) {
        List<VisData> list = null;
        if (bl) {
            list = this.getVisDisplay().getSelectedVis();
            if (bl2 && list.size() == 0) {
                Message.info(Messages.getString("VISPOPUP_NO_SELECTED_IMAGES"));
                return null;
            }
        } else {
            list = this.getVisDisplay().getVis();
        }
        return list;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }
}

