/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.model.DisplayState;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.keyimages.IKeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.presentationstate.IPresentationStateProvider;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.math.Matrix2d;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageInformationProvider;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.TEventHandler;
import com.tiani.jvision.image.DoubleDimension;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.ImageDef;
import com.tiani.jvision.image.fithandler.PixelIdentityFitHandler;
import com.tiani.jvision.image.fithandler.TrueSizeFitHandler;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.ImageFilterNode;
import com.tiani.jvision.renderer.RDCRendererRGB;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.toptoolbar.PatientInfoAction;
import com.tiani.jvision.toptoolbar.SyncOptionsActionProvider;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Timer;
import javax.vecmath.Vector2d;

public class VisData
implements TEventHandler,
ActionListener,
IImageInformationProvider {
    private static volatile VisData lastModified;
    private static int lastModifiedDisplaySetID;
    private static DataSelectionManager dsm;
    private static final ALogger log;
    private static int timerStopSignDelay;
    private static AtomicInteger blockLastModifiedChanges;
    private static PatientInfoAction patientInfo;
    private final View view;
    private final VisDisplayData parent;
    private Vis2 vis;
    private boolean isSelected = true;
    private Timer timerStopSign;

    static {
        lastModifiedDisplaySetID = -1;
        dsm = DataSelectionManager.getInstance();
        log = ALogger.getLogger(VisData.class);
        timerStopSignDelay = 1100;
        blockLastModifiedChanges = new AtomicInteger(0);
        patientInfo = (PatientInfoAction)PActionRegistry.getAction("PATIENT_INFO");
    }

    public static VisData getLastModified() {
        return lastModified;
    }

    public static synchronized void resetLastModified() {
        if (VisData.getLastModified() != null) {
            dsm.notifyLastModifiedChanged(lastModifiedDisplaySetID, null);
        }
        VisData.reallySetLastModified(null);
        VisData.patientInfoUpdate(null);
    }

    public boolean isMagnifierOn() {
        if (this.view != null && this.view instanceof ImgView2) {
            return ((ImgView2)this.view).isMagnifierOn();
        }
        return false;
    }

    private static synchronized void reallySetLastModified(VisData visData) {
        lastModified = visData;
        lastModifiedDisplaySetID = -1;
        if (visData != null && visData.getParent().getDisplaySet() != null) {
            lastModifiedDisplaySetID = VisData.getDisplayAndDisplaySetID(visData.getParent());
        }
    }

    private static int getDisplayAndDisplaySetID(VisDisplayData visDisplayData) {
        return 0xFFFF0000 & visDisplayData.getID() << 16 | 0xFFFF & visDisplayData.getDisplaySetID();
    }

    public static void blockLastModifiedChange(boolean bl) {
        blockLastModifiedChanges.addAndGet(bl ? 1 : -1);
        if (blockLastModifiedChanges.get() < 0) {
            blockLastModifiedChanges.set(0);
        }
    }

    static boolean isBlockLastModifiedChange() {
        return blockLastModifiedChanges.get() > 0;
    }

    public static void patientInfoUpdate(IDisplaySet iDisplaySet) {
        patientInfo.setCurrentData(iDisplaySet);
    }

    public VisData(VisDisplayData visDisplayData, View view, Dimension dimension) {
        this(visDisplayData, view);
        if (dimension != null) {
            this.view.setBounds(0, 0, dimension.width, dimension.height);
        }
    }

    private VisData(VisDisplayData visDisplayData, View view) {
        this.parent = visDisplayData;
        this.view = view;
    }

    public VisDisplayData getParent() {
        return this.parent;
    }

    public void markAsKeyImage(KeyImageType keyImageType) {
        KeyImageManager.ofFrame(this.getFrameData()).mark(this.getFrameData(), keyImageType);
    }

    public void unmarkAsKeyImage(KeyImageType keyImageType) {
        KeyImageManager.ofFrame(this.getFrameData()).unmark(this.getFrameData(), keyImageType);
    }

    public boolean isMarkedAsKeyImage(KeyImageType keyImageType) {
        IKeyImageInfo iKeyImageInfo = this.getFrameData().getKeyImageInfo();
        return iKeyImageInfo != null && iKeyImageInfo.isMarked(keyImageType);
    }

    public boolean isLossy() {
        try {
            IImageInformation iImageInformation = this.view.getImageInformation();
            return iImageInformation == null ? false : iImageInformation.isLossy();
        }
        catch (NullPointerException nullPointerException) {
            log.error("Error during isLossy check.", (Throwable)nullPointerException);
            return false;
        }
    }

    public boolean isVideo() {
        IFrameObjectData iFrameObjectData = this.getFrameData();
        if (iFrameObjectData != null) {
            UIDType uIDType = UIDUtilities.getBaseType((String)iFrameObjectData.getSOPClassUID());
            return uIDType == UIDType.Video;
        }
        return false;
    }

    public boolean is4D() {
        VisDisplayData visDisplayData;
        if (this.getParent() != null && (visDisplayData = this.getParent()) != null) {
            IDisplaySet iDisplaySet = this.getParent().getDisplaySet();
            return iDisplaySet == null ? false : iDisplaySet.is4D();
        }
        return false;
    }

    public boolean isSecondaryCapture() {
        return this.getSequenceData().isSecondaryCapture();
    }

    public boolean isSecondaryCaptureSaved() {
        return this.getSequenceData().isSecondaryCaptureSaved();
    }

    @Override
    public IImageInformation getImageInformation() {
        return this.view.getImageInformation();
    }

    public IFrameObjectData getFrameData() {
        return this.view.getFrameData();
    }

    public ISeriesData getSequenceData() {
        IFrameObjectData iFrameObjectData = this.view.getFrameData();
        if (iFrameObjectData == null) {
            log.debug("VisData: getInstanceData() == null");
            return null;
        }
        return iFrameObjectData.getParent();
    }

    public IStudyData getStudyData() {
        return this.getSequenceData().getParent();
    }

    public IPatientData getPatientData() {
        return this.getStudyData().getParent();
    }

    public boolean isLoaded() {
        return this.view.isFunctional();
    }

    public void loadFinal() {
        if (this.view instanceof ImgView2) {
            ((ImgView2)this.view).loadFinal();
        }
    }

    void clear() {
        this.view.cleanUp();
    }

    public void setView(Vis2 vis2) {
        if (this.vis == null && vis2 != null) {
            this.vis = vis2;
            this.onEnterView();
        } else if (this.vis != null && vis2 == null) {
            this.onExitView();
            this.vis = vis2;
        } else {
            this.vis = vis2;
        }
        if (this.view != null) {
            this.view.visSet(vis2);
        }
    }

    public Vis2 getVisual() {
        return this.vis;
    }

    public View getView() {
        return this.view;
    }

    public BufferedImage getImage() {
        if (this.view == null) {
            return null;
        }
        return this.view.getImage();
    }

    public BufferedImage captureImage() {
        if (this.view == null) {
            return null;
        }
        return this.view.captureImage();
    }

    public boolean isInView() {
        return this.vis != null && this.vis.getWidth() > 0;
    }

    protected void onEnterView() {
        this.view.onEnterView();
    }

    protected void onExitView() {
        this.view.onExitView();
    }

    public void setVisualBounds(int n, int n2, int n3, int n4) {
        this.view.setBounds(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTheLastModified() {
        if (VisData.isBlockLastModifiedChange()) {
            return;
        }
        Class<VisData> clazz = VisData.class;
        synchronized (VisData.class) {
            boolean bl;
            if (this.parent == null || VisData.isBlockLastModifiedChange()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            VisData visData = VisData.getLastModified();
            VisDisplay2 visDisplay2 = this.parent.getVisDisplay();
            if (!VisDisplay2.pjvi1754_isNavigDragActive()) {
                LocalizerManager.notifyAllLocalizers(visDisplay2.getData());
                if (VisData.getLastModified() != this) {
                    TEvent tEvent = new TEvent();
                    tEvent.id = 53;
                    TEventDispatch.sendEvent(tEvent, (Object)this.getView(), 4096);
                    this.getView().handleTEvent(tEvent, this.getView(), 4096);
                }
            }
            boolean bl2 = bl = lastModifiedDisplaySetID < 0 || VisData.getDisplayAndDisplaySetID(this.parent) != lastModifiedDisplaySetID;
            if (bl) {
                dsm.notifyLastModifiedChanged(lastModifiedDisplaySetID, this.parent);
                VisData.patientInfoUpdate(this.parent.getDisplaySet());
            }
            if (visData == null || visData.getView() != this.getView()) {
                VisData.reallySetLastModified(this);
                IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
                if (bl && iPatientRepresentation != null && iPatientRepresentation.getPatientData().existsWorldToWorldTransforms()) {
                    for (VisDisplay2 visDisplay22 : JVision2.getMainFrame().getDisplays()) {
                        if (!visDisplay22.hasData()) continue;
                        visDisplay22.repaint();
                    }
                }
            } else {
                VisData.reallySetLastModified(this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        this.setSelected(bl, false);
    }

    public void setSelected(boolean bl, boolean bl2) {
        boolean bl3 = this.isSelected;
        this.isSelected = bl;
        if (bl2 && this.isInView() && bl3 != this.isSelected) {
            this.getVisual().repaintBorder();
        }
    }

    public void paintForVisual() {
        if (this.getVisual() == null) {
            return;
        }
        this.getVisual().paintNow();
    }

    void windowingValues(WindowValue windowValue, int n, Object object) {
        TEvent tEvent = new TEvent();
        tEvent.id = 63;
        tEvent.interactionModifier = 2;
        tEvent.source = object;
        if ((n & 0x100) != 0 && this == VisData.getLastModified()) {
            this.view.handleTEvent(tEvent, windowValue, n);
            return;
        }
        if (this.parent.getVisDisplay().isSynchronized() && SyncOptionsActionProvider.SyncOption.WINDOW_LEVEL.isSelected()) {
            TEventDispatch.sendEvent(tEvent, (Object)windowValue, n |= 0x28);
        } else {
            VisDisplay2 visDisplay2 = this.parent.getVisDisplay();
            TEventDispatch.sendEventToVis(visDisplay2, tEvent, windowValue, n);
        }
    }

    @Override
    public void handleTEvent(TEvent tEvent, Object object, int n) {
        switch (tEvent.id) {
            case 102: {
                if (this.getVisual() == null) break;
                this.getVisual().onDataChanged();
                break;
            }
            default: {
                this.view.handleTEvent(tEvent, object, n);
            }
        }
    }

    synchronized void showStopSign() {
        if (this.timerStopSign == null) {
            this.timerStopSign = new Timer(timerStopSignDelay, this);
            this.timerStopSign.setRepeats(false);
            this.timerStopSign.start();
        } else {
            this.timerStopSign.restart();
        }
        if (this.getVisual() != null) {
            this.getVisual().paintNow();
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timerStopSign) {
            this.timerStopSign.stop();
            this.timerStopSign = null;
            if (this.getVisual() != null) {
                this.getVisual().paintNow();
            }
        }
    }

    public synchronized boolean isStopSignTimerRunning() {
        return this.timerStopSign != null;
    }

    public boolean isFirstInParent() {
        return this == this.parent.getFirstVis();
    }

    public boolean isLastInParent() {
        return this == this.parent.getLastVis();
    }

    public boolean isCorrectlyOriented() {
        IMutableImageState iMutableImageState = this.view.getImageState();
        if (iMutableImageState != null) {
            Matrix2d matrix2d = iMutableImageState.getTransform();
            return matrix2d == null || matrix2d.isIdentity();
        }
        return true;
    }

    public BufferedImage renderVisData(int n, int n2, View.OverlayMode overlayMode) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Vis2.print(this, bufferedImage.getGraphics(), n, n2, overlayMode);
        return bufferedImage;
    }

    public boolean isImageAvailable() {
        return !(this.view instanceof ImgView2) || ((ImgView2)this.view).isComplete();
    }

    public void saveDisplayState(DisplayState displayState) {
        boolean bl;
        AreaFitHandler areaFitHandler;
        Object object;
        EnumSet<View.CAPTURE_STATES> enumSet = this.getView().captureStates();
        IPresentationStateProvider iPresentationStateProvider = this.getView().getPresentationStateProvider(PresentationStateType.HANGING_PROTOCOL_CAPTURE);
        IPresentationState iPresentationState = null;
        if (iPresentationStateProvider != null) {
            iPresentationState = iPresentationStateProvider.getPresentationState(enumSet);
        }
        Renderer renderer = this.getView().getRenderer();
        boolean bl2 = false;
        if (enumSet.contains((Object)View.CAPTURE_STATES.ZOOM_PAN) && renderer instanceof IRDCRenderer) {
            Object object2;
            object = (IRDCRenderer)((Object)renderer);
            areaFitHandler = object.getAreaFitHandler();
            if (areaFitHandler != null) {
                if (areaFitHandler instanceof FullVisualFitHandler) {
                    double d;
                    displayState.setZoomMode(ZoomMode.NORMAL);
                    object2 = (FullVisualFitHandler)areaFitHandler;
                    DoubleDimension doubleDimension = object.getDefaultDisplayedAreaSize();
                    if (doubleDimension != null && ((FullVisualFitHandler)object2).hasDisplayedAreaSize(doubleDimension)) {
                        d = 0.0;
                    } else {
                        DoubleDimension doubleDimension2 = ((FullVisualFitHandler)object2).getDisplayedAreaSize();
                        d = 1.0 / Math.min(doubleDimension2.width, doubleDimension2.height);
                    }
                    displayState.setMagnificationRatio(d);
                } else if (areaFitHandler instanceof PixelIdentityFitHandler) {
                    displayState.setZoomMode(ZoomMode.PIXELIDENTITY);
                    displayState.setMagnificationRatio(((PixelIdentityFitHandler)areaFitHandler).getZoomFactor());
                } else if (areaFitHandler instanceof TrueSizeFitHandler) {
                    displayState.setZoomMode(ZoomMode.TRUESIZE);
                }
                object2 = areaFitHandler.getViewportCenterAlignmentX();
                if (object2 != AreaFitHandler.ViewportCenterAlignmentX.CENTER) {
                    displayState.setViewPortCenterAlignmentX((AreaFitHandler.ViewportCenterAlignmentX)((Object)object2));
                }
            }
            if ((object2 = object.getActiveImageDef()) != null) {
                Vector2d vector2d = enumSet.contains((Object)View.CAPTURE_STATES.TRANSFORMATION) ? new Vector2d(((ImageDef)object2).getTransformedViewportCenter()) : ((ImageDef)object2).getViewportCenter();
                displayState.setViewPortCenter(vector2d.x, vector2d.y);
                bl2 = true;
            }
        }
        if (enumSet.contains((Object)View.CAPTURE_STATES.TRANSFORMATION) && !(bl = this.getView().captureSpatialTransformation(displayState, bl2)) && iPresentationState != null) {
            areaFitHandler = iPresentationState.createSpatialTransformationModule();
            displayState.setImageHorizontalFlip(areaFitHandler.getImageHorizontalFlip() == YN.Yes);
            displayState.setImageRotation(areaFitHandler.getImageRotation());
        }
        if (enumSet.contains((Object)View.CAPTURE_STATES.WINDOW_LEVEL)) {
            if (iPresentationState != null && (object = iPresentationState.getVOILUT(true)) != null && object.hasWindow()) {
                displayState.setWindowCenter(object.getWindowCenter());
                displayState.setWindowWidth(object.getWindowWidth());
            }
            if ((object = this.getInversionState()) != InversionState.UNDEFINED) {
                displayState.setImageInvert(object == InversionState.INVERTED);
            }
        }
        if (enumSet.contains((Object)View.CAPTURE_STATES.FILTER) && renderer instanceof ImageFilterNode) {
            displayState.setFilterName(((ImageFilterNode)renderer).getFilterName());
        }
    }

    InversionState getInversionState() {
        if (!(this.view instanceof ImgView2)) {
            return InversionState.UNDEFINED;
        }
        WindowHandlerBase windowHandlerBase = ((ImgView2)this.view).getWindowHandler();
        Renderer renderer = this.view.getRenderer();
        if (windowHandlerBase != null && windowHandlerBase.getGSTS() != null) {
            return InversionState.valueOf(windowHandlerBase.getGSTS().getUserInversion());
        }
        if (renderer instanceof RDCRendererRGB) {
            return InversionState.valueOf(((RDCRendererRGB)renderer).isInverted());
        }
        log.debug("Could not get invert information. Setting invert flag to false...");
        return InversionState.NOT_INVERTED;
    }

    public static enum InversionState {
        NOT_INVERTED,
        INVERTED,
        UNDEFINED;


        public static InversionState valueOf(String string) {
            return Enum.valueOf(InversionState.class, string);
        }
    }
}

