/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.splitsort.I4DProperties;
import com.agfa.pacs.impaxee.sync.ISynchronizableImageFrames;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.View;
import com.tiani.jvision.util.Index;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.NavigationLocation;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class VisDataHolder
implements Iterable<VisData>,
I4DProperties,
ISynchronizableImageFrames {
    private final VisDisplayData visDisplayData;
    private VisData[][] visDatas = null;
    private int stackLength;
    private boolean isPrimaryNavigationInSpace = true;
    private int secondaryIndex = 0;
    private Map<VisData, Index> visDataIndex = null;

    VisDataHolder(VisDisplayData visDisplayData) {
        this.visDisplayData = visDisplayData;
    }

    @Override
    public Iterator<VisData> iterator() {
        return new TwoDArrayIterator<VisData>(this.visDatas);
    }

    boolean isEmpty() {
        return this.visDatas == null;
    }

    @Override
    public IImageInformation getImagePlaneInformation(int n) {
        return this.getVisData(n).getImageInformation();
    }

    private VisData getVisData(int n) {
        return this.visDatas[this.secondaryIndex][n];
    }

    @Override
    public double getRelativeSliceLocation(int n) {
        IDisplaySet iDisplaySet = this.visDisplayData.getDisplaySet();
        if (!this.isPrimaryNavigationInSpace && iDisplaySet.isRegular4D()) {
            return 0.0;
        }
        return iDisplaySet.getRelativeSliceLocation(this.secondaryIndex, n);
    }

    @Override
    public boolean hasLocationInformation() {
        return this.visDisplayData.getDisplaySet().hasLocationInformation();
    }

    @Override
    public int getRunFrameCount() {
        return this.getStackLength();
    }

    int getStackLength() {
        return this.stackLength;
    }

    @Override
    public void setSecondaryIndex(int n) {
        this.secondaryIndex = n;
        this.stackLength = this.visDatas[n].length;
    }

    @Override
    public int getSecondaryIndex() {
        return this.secondaryIndex;
    }

    @Override
    public int getNumberOf4DRuns() {
        return this.visDatas.length;
    }

    void set(View[][] viewArray, VisDisplayData visDisplayData, Dimension dimension, boolean bl) {
        int n;
        this.visDataIndex = new HashMap<VisData, Index>(viewArray[0].length * viewArray.length);
        this.visDatas = new VisData[viewArray.length][];
        this.stackLength = viewArray[this.secondaryIndex].length;
        this.secondaryIndex = 0;
        int n2 = 0;
        while (n2 < viewArray.length) {
            this.visDatas[n2] = new VisData[viewArray[n2].length];
            n = 0;
            while (n < viewArray[n2].length) {
                VisData visData;
                this.visDatas[n2][n] = visData = new VisData(visDisplayData, viewArray[n2][n], dimension);
                this.visDataIndex.put(visData, new Index(n, n2));
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < viewArray.length) {
            n = 0;
            while (n < viewArray[n2].length) {
                viewArray[n2][n].setVis(this.visDatas[n2][n]);
                ++n;
            }
            ++n2;
        }
        if (visDisplayData.getDisplaySet().isRegular4D() && visDisplayData.getPlugin().isDefaultPlugin()) {
            this.setPrimaryNavigationInSpace(bl);
        }
    }

    int getTotalNavigationPosition(int n) {
        int n2 = n;
        int n3 = 0;
        while (n3 < this.secondaryIndex) {
            n2 += this.visDatas[n3].length;
            ++n3;
        }
        return n2;
    }

    VisData get(int n) {
        if (n < 0 || n >= this.stackLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.visDatas[this.secondaryIndex][n];
    }

    List<VisData> getCurrentStack() {
        if (this.visDatas == null) {
            return Collections.emptyList();
        }
        return new ArrayList<VisData>(Arrays.asList(this.visDatas[this.secondaryIndex]));
    }

    void append(View[] viewArray, VisDisplayData visDisplayData, Dimension dimension) {
        if (this.visDatas != null && this.visDatas.length > 1) {
            throw new UnsupportedOperationException();
        }
        if (this.visDatas == null) {
            this.visDataIndex = new HashMap<VisData, Index>(viewArray.length);
            this.visDatas = new VisData[1][];
            this.visDatas[0] = new VisData[0];
        }
        if (this.visDatas.length > 1) {
            throw new UnsupportedOperationException();
        }
        int n = this.visDatas[0].length;
        this.visDatas[0] = Arrays.copyOf(this.visDatas[0], n + viewArray.length);
        int n2 = 0;
        while (n2 < viewArray.length) {
            VisData visData;
            this.visDatas[0][n2 + n] = visData = new VisData(visDisplayData, viewArray[n2], dimension);
            viewArray[n2].setVis(visData);
            this.visDataIndex.put(visData, new Index(n + n2));
            ++n2;
        }
        this.stackLength = this.visDatas[this.secondaryIndex].length;
    }

    int getIndex(VisData visData) {
        if (this.visDataIndex == null) {
            return -1;
        }
        Index index2 = this.visDataIndex.get(visData);
        if (index2 == null) {
            return -1;
        }
        return index2.getIndex(this.isPrimaryNavigationInSpace);
    }

    void replace(int n, VisData visData) {
        VisData visData2 = this.getVisData(n);
        this.visDatas[this.secondaryIndex][n] = visData;
        this.visDataIndex.remove(visData2);
        this.visDataIndex.put(visData, new Index(n, this.secondaryIndex));
    }

    VisData remove(View view) {
        if (this.visDatas.length > 1) {
            throw new UnsupportedOperationException();
        }
        int n = 0;
        while (n < this.visDatas[0].length) {
            if (this.visDatas[0][n].getView() == view) {
                return this.remove(n);
            }
            ++n;
        }
        return null;
    }

    private VisData remove(int n) {
        if (this.visDatas.length > 1) {
            throw new UnsupportedOperationException();
        }
        VisData visData = this.visDatas[0][n];
        visData.clear();
        this.visDatas[0] = (VisData[])ArrayUtils.remove((Object[])this.visDatas[0], (int)n);
        this.visDataIndex.remove(visData);
        this.stackLength = this.visDatas[this.secondaryIndex].length;
        return visData;
    }

    @Override
    public boolean isPrimaryNavigationInSpace() {
        return this.isPrimaryNavigationInSpace;
    }

    @Override
    public void setPrimaryNavigationInSpace(boolean bl) {
        if (this.isPrimaryNavigationInSpace == bl) {
            return;
        }
        this.isPrimaryNavigationInSpace = bl;
        this.reorderVisData();
        VisDisplay2 visDisplay2 = this.visDisplayData.getVisDisplay();
        int n = visDisplay2.getNavigPos();
        int n2 = this.getSecondaryIndex();
        this.setSecondaryIndex(n);
        visDisplay2.setNavigationPosition(n2, VisDisplay2.NavigationPositionOption.SKIP_SCROLL_BAR_UPDATE);
    }

    private void reorderVisData() {
        int n = this.visDatas.length;
        int n2 = this.visDatas[0].length;
        VisData[][] visDataArray = new VisData[n2][n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                visDataArray[n4][n3] = this.visDatas[n3][n4];
                ++n4;
            }
            ++n3;
        }
        this.visDatas = visDataArray;
        this.stackLength = visDataArray[0].length;
    }

    int navigateTo4DLocation(int n) {
        NavigationLocation navigationLocation = new NavigationLocation(n, this.visDatas);
        this.setSecondaryIndex(navigationLocation.getSecondaryIndex());
        return navigationLocation.getPosition();
    }

    @Override
    public boolean isUpdateOn4DNavigationRequired() {
        return true;
    }

    public String toString() {
        return this.getClass().getName() + '[' + (this.getSecondaryIndex() + 1) + " of " + this.getNumberOf4DRuns() + "][" + this.getStackLength() + ']';
    }
}

