/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.User;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PSelectableAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.config.ConfigUtils;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseDisplay;
import com.agfa.pacs.impaxee.hanging.model.IDisplayState;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeInfoGlobal;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.IPluginActivationListener;
import com.agfa.pacs.impaxee.plugin.PluginActivationListenerFactory;
import com.agfa.pacs.impaxee.plugin.PluginManager;
import com.agfa.pacs.impaxee.presentationstate.PresentationStatePoolCollector;
import com.agfa.pacs.impaxee.presentationstate.PresentationStateType;
import com.agfa.pacs.impaxee.splitsort.I4DProperties;
import com.agfa.pacs.impaxee.sync.ISynchronizableImageFrames;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.actioncontext.ActionContextManager;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.CrossSliceAngleMeasurement;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.overlay.localizer.DisplayLocalizerInfo;
import com.tiani.jvision.plugin.DefaultDisplayPlugin;
import com.tiani.jvision.plugin.DefaultPlugin;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toptoolbar.PluginActions;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDataHolder;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.Lyt;
import com.tiani.jvision.vis.layout.LytDisplay;
import com.tiani.jvision.vis.layout.StateLytScreen;
import com.tiani.util.expressions.IEvaluationContext;
import com.tiani.util.message.Message;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;

public class VisDisplayData {
    private static final ALogger log = ALogger.getLogger(VisDisplayData.class);
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final VisDisplay2 parent;
    private ZoomMode zoomMode = ZoomMode.NORMAL;
    private IPlugin plugin;
    private IDisplayPlugin displayPlugin;
    private IPlugin defaultPlugin = new DefaultPlugin();
    private IDisplaySet displaySet;
    private final int id = COUNTER.incrementAndGet();
    private boolean wasDefaultPlugin;
    private VisDataHolder visDatas = new VisDataHolder(this);
    private int nColsBeforeTypeSwitch = -1;
    private int nRowsBeforeTypeSwitch = -1;
    private volatile DisplayLocalizerInfo localizerInfo = null;
    private boolean switchedLastPluginToFull = false;
    private StateLytScreen storedScreenLayout;
    private CrossSliceAngleMeasurement crossSliceAngleMeasurement;
    private Properties properties;

    static int getNumberOfImagesNearToScrollPos() {
        return 8;
    }

    public static int getKeyFrameDistance(int n) {
        return 20;
    }

    VisDisplayData(VisDisplay2 visDisplay2) {
        this.parent = visDisplay2;
        this.setType(this.defaultPlugin, ActivationMode.DEFAULT, null);
    }

    public IPlugin getPlugin() {
        return this.plugin;
    }

    public VisDisplay2 getVisDisplay() {
        return this.parent;
    }

    public List<IFrameObjectData> getFrameData() {
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
        for (VisData visData : this.visDatas) {
            arrayList.add(visData.getFrameData());
        }
        return arrayList;
    }

    public List<IFrameObjectData> getCurrentFrameData() {
        List<VisData> list = this.visDatas.getCurrentStack();
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>(list.size());
        for (VisData visData : list) {
            arrayList.add(visData.getFrameData());
        }
        return arrayList;
    }

    void save() {
        try {
            PresentationStatePoolCollector presentationStatePoolCollector = new PresentationStatePoolCollector(User.getUserNameAsPN(), Messages.getString("TemporaryPresentationStateLabel"), Messages.getString("TemporaryPresentationStateDescription"), PresentationStateType.TEMPORARY);
            for (VisData visData : this.visDatas) {
                presentationStatePoolCollector.addVisData(visData);
            }
            presentationStatePoolCollector.storeInStudies(this.getDisplaySet().getID());
        }
        catch (Exception exception) {
            log.error("Could not store State", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayLocalizerInfo getLocalizerInfo() {
        if (this.localizerInfo == null) {
            VisDisplayData visDisplayData = this;
            synchronized (visDisplayData) {
                if (this.localizerInfo == null) {
                    this.localizerInfo = !this.visDatas.isEmpty() ? new DisplayLocalizerInfo(this.visDatas.get(0).getImageInformation(), this.visDatas.get(this.visDatas.getStackLength() / 2).getImageInformation(), this.visDatas.get(this.visDatas.getStackLength() - 1).getImageInformation()) : DisplayLocalizerInfo.getEmptyInstance();
                }
            }
        }
        return this.localizerInfo;
    }

    void resetType() {
        if (this.plugin != this.defaultPlugin) {
            this.setType(this.defaultPlugin, ActivationMode.DEFAULT, null);
        }
    }

    public IDisplayPlugin getDisplayPlugin() {
        return this.displayPlugin;
    }

    void resetZoomMode() {
        this.setZoomMode(ZoomMode.NORMAL);
    }

    public ZoomMode getZoomMode() {
        return this.zoomMode;
    }

    private boolean isLicenseInUse(String string) {
        List<VisDisplay2> list = JVision2.getMainFrame().getAllDisplays();
        for (VisDisplay2 visDisplay2 : list) {
            String string2;
            if (visDisplay2.getData() == this || (string2 = visDisplay2.getData().getPlugin().getLicensingPluginID()) == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private void initializePlugin(IDisplayPlugin iDisplayPlugin, ActivationMode activationMode, IDisplayState iDisplayState) {
        boolean bl = false;
        if (iDisplayPlugin != null && !(iDisplayPlugin instanceof DefaultDisplayPlugin) && VisData.isBlockLastModifiedChange()) {
            VisData.blockLastModifiedChange(false);
            bl = true;
        }
        IDisplayPlugin iDisplayPlugin2 = this.displayPlugin;
        this.displayPlugin = iDisplayPlugin;
        if (this.displaySet == null) {
            return;
        }
        this.parent.clearForNewPlugin(activationMode == ActivationMode.HANGUP || activationMode == ActivationMode.AUTOSTART);
        if (!(this.wasDefaultPlugin || this.getVisDisplay().isDetached() || activationMode != ActivationMode.MANUAL && activationMode != ActivationMode.SET_LIVE || !(iDisplayPlugin instanceof DefaultDisplayPlugin) || this.nColsBeforeTypeSwitch == -1 || this.nRowsBeforeTypeSwitch == -1)) {
            if (this.switchedLastPluginToFull) {
                if (this.parent.getScreen().getLytMode() == MainLayoutType.variable && this.parent.getScreen().getLyt().getCols() == 1 && this.parent.getScreen().getLyt().getRows() == 1) {
                    this.parent.getScreen().setLytMode(MainLayoutType.variable, this.storedScreenLayout, false);
                }
                this.switchedLastPluginToFull = false;
                this.storedScreenLayout = null;
            }
            this.parent.setLytMode(this.parent.getScreen().getLytMode().getNewLytDisplay(), this.nColsBeforeTypeSwitch, this.nRowsBeforeTypeSwitch, true, this.parent.isSwitchedFullFull());
            this.nRowsBeforeTypeSwitch = -1;
            this.nColsBeforeTypeSwitch = -1;
        }
        this.initDisplayMode(this.displaySet, this.visDatas, activationMode, iDisplayPlugin2);
        this.parent.applyMostRecentPresState(null);
        this.parent.updateData(true);
        this.parent.updateScrollBar();
        this.parent.addAllVisHRs();
        this.parent.updateAllVisHRsOutsideMode();
        this.parent.repaint();
        if (this.getVis(0) != null) {
            VisData.resetLastModified();
            this.getVis(0).makeTheLastModified();
        }
        ActionContextManager.singleton.contextChanged(this);
        if (bl) {
            VisData.blockLastModifiedChange(true);
        }
        if (this.displayPlugin instanceof DefaultDisplayPlugin) {
            this.getVisDisplay().updateActionStates();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setType(IPlugin iPlugin, ActivationMode activationMode, IDisplayState iDisplayState) {
        void var7_21;
        Object object3;
        log.info("Setting display plugin: " + iPlugin);
        LicenseManager licenseManager = LicenseManager.getInstance();
        if (iPlugin == null) {
            iPlugin = this.defaultPlugin;
        }
        if (!this.parent.isPluginAllowed(iPlugin)) {
            Message.error(Messages.getString("VisDisplayData.PluginNotAllowed.Title"), (Object)MessageFormat.format(Messages.getString("VisDisplayData.PluginNotAllowed.Message"), iPlugin.getDescription()));
            return;
        }
        if (iPlugin.getLicensingPluginID() != null && licenseManager.getLicense(iPlugin.getLicensingPluginID()) == null) {
            Message.error(Messages.getString("VisDisplayData.PluginLicenseMissingTitle"), (Object)(String.valueOf(Messages.getString("VisDisplayData.PluginLicenseMissing")) + "."));
            return;
        }
        if (!iPlugin.isDefaultPlugin() && this.displaySet.isBeingLossyPrefetched()) {
            Message.error(Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Title"), (Object)MessageFormat.format(Messages.getString("PluginStarter.LossyImageWarning.Message"), iPlugin.getDescription()));
            return;
        }
        IPlugin iPlugin2 = this.plugin;
        if ((activationMode == ActivationMode.MANUAL || activationMode == ActivationMode.SET_LIVE) && iPlugin2 == iPlugin) {
            return;
        }
        boolean bl = this.wasDefaultPlugin = iPlugin2 == this.defaultPlugin;
        if (this.wasDefaultPlugin && (object3 = this.parent.getLyt()) != null) {
            this.nColsBeforeTypeSwitch = ((Lyt)object3).getCols();
            this.nRowsBeforeTypeSwitch = ((Lyt)object3).getRows();
        }
        if ((object3 = this.getDisplayPlugin()) != null) {
            for (PAction pAction : this.displayPlugin.getInvalidDisplayToolbarActions()) {
                pAction.setEnabled(true);
            }
            object3.cleanUp();
        }
        this.plugin = iPlugin;
        if (iPlugin2 != null && iPlugin2.getLicensingPluginID() != null && !this.isLicenseInUse(iPlugin2.getLicensingPluginID())) {
            licenseManager.releaseLicense(iPlugin2.getLicensingPluginID());
        }
        for (IPluginActivationListener iPluginActivationListener : PluginActivationListenerFactory.getInstance().getPluginsActivationListeners()) {
            iPluginActivationListener.pluginWillBeActivated(this, this.plugin.getPluginName());
        }
        IDisplayPlugin iDisplayPlugin = iPlugin.createDisplayPlugin(this, iDisplayState);
        if (iDisplayPlugin == null) {
            this.plugin = this.defaultPlugin;
            for (IPluginActivationListener iPluginActivationListener : PluginActivationListenerFactory.getInstance().getPluginsActivationListeners()) {
                iPluginActivationListener.pluginWillBeActivated(this, this.plugin.getPluginName());
            }
            IDisplayPlugin iDisplayPlugin2 = this.plugin.createDisplayPlugin(this);
        }
        this.initializePlugin((IDisplayPlugin)var7_21, activationMode, iDisplayState);
        for (PAction pAction : this.displayPlugin.getInvalidDisplayToolbarActions()) {
            pAction.setEnabled(false);
        }
        VisDisplay2 visDisplay2 = this.getVisDisplay();
        if (iPlugin2 != null && visDisplay2.hasAction(iPlugin2.getActionID())) {
            PAction pAction = visDisplay2.getAction(iPlugin2.getActionID());
            ((PSelectableAction)((Object)pAction)).setSelected(false);
        }
        if (visDisplay2.hasAction(this.plugin.getActionID())) {
            PAction pAction = visDisplay2.getAction(this.plugin.getActionID());
            ((PSelectableAction)((Object)pAction)).setSelected(true);
        }
        visDisplay2.updateAllActionsRegardingLayoutChanges();
        IMouseModeInfo iMouseModeInfo = this.displayPlugin.getMouseModeInfo();
        MouseModeInfoGlobal mouseModeInfoGlobal = MouseModeInfoGlobal.getInstance();
        if (iMouseModeInfo != mouseModeInfoGlobal || iPlugin2 != null && iMouseModeInfo == mouseModeInfoGlobal && !this.wasDefaultPlugin) {
            if (!this.displayPlugin.isMeasuringAllowed() && mouseModeInfoGlobal.getSubMode().isMeasurement()) {
                mouseModeInfoGlobal.resetSubMode();
            } else {
                iMouseModeInfo.setPresentationObjectCreationStatus(mouseModeInfoGlobal.getPresentationObjectCreationStatus());
                iMouseModeInfo.setSubMode(mouseModeInfoGlobal.getSubMode());
            }
        } else if (!this.displayPlugin.isMeasuringAllowed() && mouseModeInfoGlobal.getSubMode().isMeasurement()) {
            mouseModeInfoGlobal.resetSubMode();
        }
    }

    public void setZoomMode(ZoomMode zoomMode) {
        if (zoomMode == this.zoomMode) {
            return;
        }
        this.zoomMode = zoomMode;
        if (this.getVisDisplay() != null) {
            int n = 0;
            while (n < this.getVisDisplay().getVisViewCount()) {
                this.getVisDisplay().getVisView(n).setZoomHREnabled(zoomMode != ZoomMode.TRUESIZE);
                ++n;
            }
        }
    }

    public void clear(boolean bl) {
        if (!this.visDatas.isEmpty()) {
            try {
                FrameOfReferenceManager.clearLocalizerDataForDisplay(this.parent);
            }
            catch (Exception exception) {
                log.warn("Some damaged display", (Throwable)exception);
            }
        }
        for (VisData visData : this.visDatas) {
            visData.clear();
        }
        this.clearVisDatas();
        if (!bl) {
            if (this.isDisplayShownOnScreen()) {
                this.displaySet.decrementLoadCount();
            }
            this.displaySet = null;
            this.resetType();
        }
        this.localizerInfo = null;
        this.crossSliceAngleMeasurement = null;
        if (!bl) {
            this.properties = null;
        }
    }

    public IDisplaySet getDisplaySet() {
        return this.displaySet;
    }

    public int getDisplaySetID() {
        if (this.displaySet == null) {
            return -1;
        }
        return this.displaySet.getID();
    }

    public int getID() {
        return this.id;
    }

    public IPatientRepresentation getPatientRepresentation() {
        if (this.displaySet == null) {
            return null;
        }
        return this.displaySet.getSplitAndSortRuntime().getPatientRepresentation();
    }

    private void clearVisDatas() {
        this.visDatas = new VisDataHolder(this);
    }

    public int getVisCount() {
        return this.visDatas.getStackLength();
    }

    public boolean hasData() {
        return !this.visDatas.isEmpty();
    }

    public int indexOf(VisData visData) {
        return this.visDatas.getIndex(visData);
    }

    public List<VisData> getSelectedVis() {
        ArrayList<VisData> arrayList = new ArrayList<VisData>();
        for (VisData visData : this.visDatas) {
            if (!visData.isSelected()) continue;
            arrayList.add(visData);
        }
        return arrayList;
    }

    public List<VisData> getVis() {
        return this.visDatas.getCurrentStack();
    }

    public VisData getVis(int n) {
        if (this.visDatas.isEmpty() || n < 0) {
            return null;
        }
        if (n < this.visDatas.getStackLength()) {
            return this.visDatas.get(n);
        }
        return null;
    }

    public VisData getFirstVis() {
        if (this.visDatas.isEmpty()) {
            return null;
        }
        return this.visDatas.get(0);
    }

    public VisData getLastVis() {
        if (this.visDatas.isEmpty()) {
            return null;
        }
        return this.visDatas.get(this.visDatas.getStackLength() - 1);
    }

    public VisData getFirstSelectedVis() {
        for (VisData visData : this.visDatas) {
            if (!visData.isSelected()) continue;
            return visData;
        }
        return null;
    }

    public void setAllVisSelected(boolean bl) {
        for (VisData visData : this.visDatas) {
            visData.setSelected(bl);
        }
    }

    public ISynchronizableImageFrames getCurrentRun() {
        return this.visDatas;
    }

    public I4DProperties get4DProperties() {
        return this.displayPlugin.get4DProperties();
    }

    public I4DProperties get4DPropertiesBasedOnVisDataHolder() {
        return this.visDatas;
    }

    public Iterable<VisData> getVisInAllRuns() {
        return this.visDatas;
    }

    VisDataHolder getVisDataHolder() {
        return this.visDatas;
    }

    boolean initVisDisplayData(IDisplaySet iDisplaySet, IPlugin iPlugin, boolean bl, boolean bl2) {
        if (iDisplaySet != this.displaySet) {
            if (this.displaySet != null && this.isDisplayShownOnScreen()) {
                this.displaySet.decrementLoadCount();
            }
            iDisplaySet.incrementLoadCount();
        }
        this.displaySet = iDisplaySet;
        return this.initVisDisplay(this.displaySet, iPlugin, bl, bl2);
    }

    private static PluginName findPluginWithMatchingAutostartCondition(IEvaluationContext iEvaluationContext) {
        PluginName pluginName;
        IConfigurationProvider iConfigurationProvider = ConfigUtils.getFirstMatchOfList(iEvaluationContext, Config.impaxee.jvision.PLUGINS.autoUsePlugin.getList(), null, "conditionText");
        if (iConfigurationProvider != null && (pluginName = PluginName.getItemWithName(iConfigurationProvider.getString("pluginName"))) != PluginName.DEFAULT) {
            return pluginName;
        }
        return null;
    }

    private static PluginName findCompatibleAutostartPlugin(IDisplaySet iDisplaySet) {
        PluginName[] pluginNameArray = PluginName.values();
        int n = pluginNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPlugin iPlugin;
            PluginName pluginName = pluginNameArray[n2];
            if (pluginName.isAutostartPlugin() && (iPlugin = PluginManager.getPlugin(pluginName.getPluginName())) != null && iPlugin.areDataSuitable(iDisplaySet)) {
                return pluginName;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean initVisDisplay(IDisplaySet iDisplaySet, IPlugin iPlugin, boolean bl, boolean bl2) {
        View view;
        Object object2;
        Object object3;
        this.localizerInfo = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = iPlugin != null;
        IDisplayPlugin iDisplayPlugin = this.displayPlugin;
        PluginName pluginName = null;
        if (!(this.displayPlugin == null || bl && this.displayPlugin.isReusable() || bl5)) {
            object3 = this.defaultPlugin;
            pluginName = VisDisplayData.findPluginWithMatchingAutostartCondition(new DisplaySetEvaluable(iDisplaySet));
            if (pluginName == null) {
                pluginName = VisDisplayData.findCompatibleAutostartPlugin(iDisplaySet);
            }
            if (pluginName != null) {
                object3 = PluginManager.getPlugin(pluginName.getPluginName());
            }
            if (object3 != null) {
                if (object3.getLicensingPluginID() != null && LicenseManager.getInstance().getLicense(object3.getLicensingPluginID()) == null) {
                    log.error("Could not start auto use plugin as not valid license found");
                    object3 = this.defaultPlugin;
                }
                if (!object3.isDefaultPlugin() && iDisplaySet.isBeingLossyPrefetched()) {
                    log.error("Plugin start on lossy prefetched data is disallowed.");
                    object3 = this.defaultPlugin;
                }
                if (!object3.areDataSuitable(iDisplaySet)) {
                    log.error("Plugin {} does not support selected display set.", (Object)this.plugin.getDescription());
                    object3 = this.defaultPlugin;
                }
                if (!this.parent.isPluginAllowed((IPlugin)object3)) {
                    log.error("Plugin {} disallowed on current display.", (Object)this.plugin.getDescription());
                    object3 = this.defaultPlugin;
                }
                if (this.plugin != null && this.parent.hasAction(this.plugin.getActionID())) {
                    object2 = this.parent.getAction(this.plugin.getActionID());
                    ((PSelectableAction)object2).setSelected(false);
                }
                this.plugin = object3;
                if (this.parent.hasAction(this.plugin.getActionID())) {
                    object2 = this.parent.getAction(this.plugin.getActionID());
                    ((PSelectableAction)object2).setSelected(true);
                }
                this.displayPlugin.cleanUp();
                for (IPluginActivationListener object4 : PluginActivationListenerFactory.getInstance().getPluginsActivationListeners()) {
                    object4.pluginWillBeActivated(this, this.plugin.getPluginName());
                }
                this.displayPlugin = this.plugin.createDisplayPlugin(this);
                if (this.displayPlugin == null) {
                    this.plugin = this.defaultPlugin;
                    for (IPluginActivationListener iPluginActivationListener : PluginActivationListenerFactory.getInstance().getPluginsActivationListeners()) {
                        iPluginActivationListener.pluginWillBeActivated(this, this.defaultPlugin.getPluginName());
                    }
                    this.displayPlugin = this.defaultPlugin.createDisplayPlugin(this);
                }
            }
        }
        object3 = ActivationMode.MANUAL;
        object3 = bl2 ? ActivationMode.HANGUP : (pluginName != null && pluginName.isPlugin() ? ActivationMode.AUTOSTART : ActivationMode.MANUAL);
        this.initDisplayMode(iDisplaySet, null, (ActivationMode)((Object)object3), iDisplayPlugin);
        if (pluginName != null && !pluginName.isPlugin() && !bl2) {
            log.info("Autostart will apply:" + pluginName.getPluginName());
            if (pluginName == PluginName.INVERT) {
                bl3 = true;
            } else if (pluginName == PluginName.TRUESIZE_ZOOM) {
                HangingCaseDisplay.applyZoomMode(this.getVisDisplay(), ZoomMode.TRUESIZE, 1.0);
            } else if (pluginName == PluginName.PIXELIDENTITY_ZOOM) {
                HangingCaseDisplay.applyZoomMode(this.getVisDisplay(), ZoomMode.PIXELIDENTITY, 1.0);
            } else if (pluginName == PluginName.FLIP) {
                HangingCaseDisplay.applyHorizonalFlip(this.getVisDisplay());
            } else if (pluginName == PluginName.LOCALIZER) {
                bl4 = true;
            }
        }
        if (bl4 && ((VisDisplay2)(object2 = this.getVisDisplay())).hasData() && (view = ((VisDisplay2)object2).getVis(0).getView()) instanceof ImgView2 && ((ImgView2)view).canHaveLocalizer()) {
            Iterator<IPluginActivationListener> iterator = new TEvent(116);
            TEventDispatch.sendEventToVis((VisDisplay2)object2, (TEvent)((Object)iterator), (Object)Localizer.LocalizerState.UserForcedOn, 16);
        }
        if (this.hasData() && (bl5 || this.displayPlugin != null && !(this.displayPlugin instanceof DefaultDisplayPlugin))) {
            void var12_21;
            boolean bl6 = VisData.isBlockLastModifiedChange();
            if (VisData.isBlockLastModifiedChange()) {
                VisData.blockLastModifiedChange(false);
            }
            this.getFirstVis().makeTheLastModified();
            if (bl6) {
                VisData.blockLastModifiedChange(true);
            }
            if (bl5) {
                IPlugin iPlugin2 = iPlugin;
            } else {
                IPlugin iPlugin3 = this.plugin;
            }
            if (object3 == ActivationMode.MANUAL || object3 == ActivationMode.SET_LIVE) {
                JVision2.getMainFrame().getPluginToolbox().attachToDisplayOnPluginStart(this.getVisDisplay(), (IPlugin)var12_21);
            } else {
                JVision2.getMainFrame().getPluginToolbox().attachToDisplayOnPluginAutoStart(this.getVisDisplay(), (IPlugin)var12_21);
            }
        }
        return bl3;
    }

    public void appendViews(View[] viewArray, Dimension dimension) {
        this.visDatas.append(viewArray, this, dimension);
    }

    private void setViews(View[][] viewArray, Dimension dimension) {
        this.visDatas.set(viewArray, this, dimension, this.displaySet.isPrimaryNavigationInSpace());
    }

    VisData replaceView(View view, Dimension dimension, int n) {
        VisData visData = new VisData(this, view, dimension);
        view.setVis(visData);
        this.visDatas.replace(n, visData);
        return visData;
    }

    VisData removeView(View view) {
        return this.visDatas.remove(view);
    }

    public void removeAllVisDatas() {
        this.clearVisDatas();
    }

    private void initDisplayMode(IDisplaySet iDisplaySet, VisDataHolder visDataHolder, ActivationMode activationMode, IDisplayPlugin iDisplayPlugin) {
        View[][] viewArray;
        Object object;
        if (this.displayPlugin == null) {
            log.error("Can't init displaymode, no displayplugin loaded");
            return;
        }
        if (VisDisplayData.isScreenRelayoutRequired(iDisplayPlugin, this.displayPlugin)) {
            EventUtil.invoke(this.parent.getScreen()::doLayout);
        }
        if (this.displayPlugin.wantsFullscreenOnStart() && this.parent.getScreen().getLytMode() == MainLayoutType.variable && activationMode == ActivationMode.MANUAL && !this.getVisDisplay().isDetached()) {
            this.storedScreenLayout = new StateLytScreen(this.parent.getScreen().getLyt());
            this.switchedLastPluginToFull = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VisDisplayData.this.parent.getScreen().setLytMode(VisDisplayData.this.parent.getScreen().getLytMode(), 1, 1, true);
                }
            });
        }
        Dimension dimension = this.displayPlugin.getPreferredVisLayout();
        LytDisplay lytDisplay = this.displayPlugin.getSpecialLayout();
        if (dimension != null) {
            object = lytDisplay != null ? lytDisplay : this.parent.getScreen().getLytMode().getNewLytDisplay();
            EventUtil.invoke((Runnable)new Runnable((LytDisplay)object, dimension){
                private final /* synthetic */ LytDisplay val$appliedLayout;
                private final /* synthetic */ Dimension val$preferredVisLayout;
                {
                    this.val$appliedLayout = lytDisplay;
                    this.val$preferredVisLayout = dimension;
                }

                @Override
                public void run() {
                    VisDisplayData.this.parent.setLytMode(this.val$appliedLayout, this.val$preferredVisLayout.width, this.val$preferredVisLayout.height, true, VisDisplayData.this.parent.isSwitchedFullFull());
                }
            });
        }
        object = null;
        if (this.getVisDisplay().getVisView(0) != null) {
            object = this.getVisDisplay().getVisView(0).getSize();
        }
        try {
            viewArray = this.displayPlugin.createDisplayViews(iDisplaySet, (Dimension)object, activationMode);
        }
        catch (RuntimeException runtimeException) {
            log.error("Creating {} views failed for {}", new Object[]{this.plugin.getPluginName(), iDisplaySet, runtimeException});
            EventQueue.invokeLater(() -> Message.warning(Messages.getString("VisDisplayData.PluginStartFailed.Title"), MessageFormat.format(Messages.getString("VisDisplayData.PluginStartFailed.Message"), this.plugin.getDescription())));
            viewArray = null;
        }
        if (this.getVisDisplay().getVisView(0) != null) {
            object = this.getVisDisplay().getVisView(0).getSize();
        }
        if (viewArray != null) {
            this.setViews(viewArray, (Dimension)object);
        } else {
            IFrameObjectData[][] iFrameObjectDataArray = iDisplaySet.getFrames();
            viewArray = new View[iFrameObjectDataArray.length][];
            int n = 0;
            while (n < iFrameObjectDataArray.length) {
                viewArray[n] = new View[iFrameObjectDataArray[n].length];
                int n2 = 0;
                while (n2 < iFrameObjectDataArray[n].length) {
                    viewArray[n][n2] = new ImgView2(iFrameObjectDataArray[n][n2], this.displaySet);
                    ++n2;
                }
                ++n;
            }
            this.setViews(viewArray, (Dimension)object);
            EventQueue.invokeLater(() -> {
                boolean bl = this.getVisDisplay().getAction(PluginActions.PLUGIN_OFF).perform(null);
            });
        }
    }

    private static boolean isScreenRelayoutRequired(IDisplayPlugin iDisplayPlugin, IDisplayPlugin iDisplayPlugin2) {
        if (iDisplayPlugin == iDisplayPlugin2 || iDisplayPlugin == null || iDisplayPlugin2 == null) {
            return false;
        }
        return iDisplayPlugin.wantsDisplayToolbar() != iDisplayPlugin2.wantsDisplayToolbar() || iDisplayPlugin.wantsScrollbar() != iDisplayPlugin2.wantsScrollbar();
    }

    public void setSequenceData(IDisplaySet iDisplaySet) {
        this.displaySet = iDisplaySet;
    }

    private boolean isDisplayShownOnScreen() {
        VisScreen2 visScreen2 = this.parent.getScreen();
        return visScreen2 == null || visScreen2.getDisplays().contains(this.parent);
    }

    public boolean isDefaultPluginActive() {
        return this.getPlugin() instanceof DefaultPlugin;
    }

    public void copyAngleMeasurements(View view) {
        this.crossSliceAngleMeasurement = CrossSliceAngleMeasurement.newInstance(view);
    }

    public void pasteAngleMeasurements(View view) {
        if (this.crossSliceAngleMeasurement == null) {
            CrossSliceAngleMeasurement.showPasteWarningDialog(Messages.getString("CrossSliceAngleMeasurement.PasteFailure.NoData"));
        } else {
            this.crossSliceAngleMeasurement.paste(view);
        }
    }

    public String getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        if (this.properties == null) {
            if (string2 == null) {
                return;
            }
            this.properties = new Properties();
        }
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.setProperty(string, string2);
        }
    }
}

