/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.tiani.config.LayoutConfig;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorComponent;
import com.tiani.jvision.actioncontext.ActionContextManager;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewMouseHandler;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.VisInfoManager;
import com.tiani.jvision.mouse.MouseWrapper;
import com.tiani.jvision.vis.DragInfo;
import com.tiani.jvision.vis.IMouseInfoProvider;
import com.tiani.jvision.vis.MouseConfiguration;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.dnd.VisDisplayDropTargetListener;
import com.tiani.jvision.vis.dnd.VisDragGestureRecognizer;
import com.tiani.jvision.vis.event.mouse.ContextMenuAction;
import com.tiani.jvision.vis.event.mouse.MouseUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VisMouseHandler
extends MultiMonitorComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final int ANY_MOUSE_BUTTON_MASK = 0x1C00 | MouseEvent.getMaskForButton(4) | MouseEvent.getMaskForButton(5);
    private static boolean globalNavigEnabled = true;
    private static final ZoomWheelMode zoomWheelMoude = ZoomWheelMode.valueOf(Config.impaxee.jvision.MEASUREMENT.ZoomDuringMeasurement.get().toUpperCase(Locale.ENGLISH));
    private static VisMouseEventInfo currentLeftClick = null;
    private static DragInfo dragInfo = null;
    private static MouseConfiguration configuration = MouseConfiguration.getInstance();
    public static final int POPUP_DRAG_TOLERANCE = VisMouseHandler.getPercentageOfMonitorSize(0.007);
    private static final int MAX_TIME_FOR_DRAG_TOLERANCE = 400;
    private static long lastMouseButtonPressedTime;
    private static boolean ignoreNextDrag;
    private static boolean isMousePositionWithinImageShown;
    private IMouseInfoProvider mouseInfoProvider;
    private Vis2 vis;
    private DragSource dndSource;
    private VisDragGestureRecognizer dndRecognizer;
    private DropTarget dndTarget;
    private int exModifier;
    private Point lastMovementPt = new Point();
    private MouseWrapper mouseWrapper;

    static {
        ignoreNextDrag = false;
    }

    public static int getPercentageOfMonitorSize(double d) {
        return (int)(Math.max((double)LayoutConfig.getInstance().getScreenWidth() * d, (double)LayoutConfig.getInstance().getScreenHeight()) * d);
    }

    public static void setGlobalNavigEnabled(boolean bl) {
        globalNavigEnabled = bl;
    }

    public static boolean isMousePositionWithinImageShown() {
        return isMousePositionWithinImageShown;
    }

    public static void toggleMousePositionWithinImageShown() {
        isMousePositionWithinImageShown = !isMousePositionWithinImageShown;
    }

    VisMouseHandler(Vis2 vis2) {
        this.vis = vis2;
        if (vis2.getVisDisplay().isDragAndDropEnabled()) {
            this.dndSource = new DragSource();
            this.dndRecognizer = new VisDragGestureRecognizer(vis2, this.dndSource, this, 0x40000003);
            this.dndTarget = new DropTarget(this, new VisDisplayDropTargetListener(vis2.getVisDisplay()));
        }
        this.mouseWrapper = new MouseWrapper(JVision2.getMainFrame());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setCursor(vis2.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().getCursor(vis2));
    }

    public Vis2 getVis() {
        return this.vis;
    }

    void destruct() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
    }

    private List<Component> getComponentsAt(Point point) {
        Component component;
        Rectangle rectangle;
        ArrayList<Component> arrayList = new ArrayList<Component>(4);
        if (this.vis.getView() != null && this.vis.getView().getMouseHandler() != null && (rectangle = (component = (Component)((Object)this.vis.getView().getMouseHandler())).getBounds()).contains(point.x + rectangle.x, point.y + rectangle.y)) {
            arrayList.add(component);
        }
        Component[] componentArray = this.vis.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2;
            component = componentArray[n2];
            if (component instanceof MouseListener && component instanceof MouseMotionListener && (rectangle2 = component.getBounds()).contains(point)) {
                arrayList.add(component);
            }
            ++n2;
        }
        return arrayList;
    }

    public void externalDragStarted() {
        if (dragInfo != null) {
            dragInfo.release(MouseUtils.generateMouseRelease(this, 64));
            dragInfo = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.densityVisInfo(mouseEvent);
        this.handleMouseEnterExit(mouseEvent);
    }

    private void handleMouseMoved(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2;
        MouseListener mouseListener;
        List<Component> list = this.getComponentsAt(mouseEvent.getPoint());
        List<Component> list2 = this.getComponentsAt(this.lastMovementPt);
        for (Component component : list) {
            mouseListener = (MouseListener)((Object)component);
            if (list2.remove(component)) {
                mouseEvent2 = VisMouseHandler.convertMouseEvent(mouseEvent, component);
                ((MouseMotionListener)((Object)mouseListener)).mouseMoved(mouseEvent2);
                continue;
            }
            mouseEvent2 = VisMouseHandler.convertMouseEvent(mouseEvent, component, 504);
            mouseListener.mouseEntered(mouseEvent2);
        }
        for (Component component : list2) {
            mouseListener = (MouseListener)((Object)component);
            mouseEvent2 = VisMouseHandler.convertMouseEvent(mouseEvent, component, 505);
            mouseListener.mouseExited(mouseEvent2);
        }
        this.lastMovementPt = mouseEvent.getPoint();
    }

    private void handleMouseEnterExit(MouseEvent mouseEvent) {
        List<Component> list = this.getComponentsAt(mouseEvent.getID() == 505 ? this.lastMovementPt : mouseEvent.getPoint());
        for (Component component : list) {
            MouseListener mouseListener = (MouseListener)((Object)component);
            MouseEvent mouseEvent2 = VisMouseHandler.convertMouseEvent(mouseEvent, component);
            if (mouseEvent.getID() == 504) {
                mouseListener.mouseEntered(mouseEvent2);
                continue;
            }
            if (mouseEvent.getID() != 505) continue;
            mouseListener.mouseExited(mouseEvent2);
        }
        this.lastMovementPt = mouseEvent.getPoint();
    }

    private void densityVisInfo(MouseEvent mouseEvent) {
        int[] nArray;
        View view = this.vis.getView();
        if (view != null) {
            view.broadcastPointOfInterest(mouseEvent.getX(), mouseEvent.getY());
        }
        String string = null;
        if (this.mouseInfoProvider != null) {
            string = mouseEvent.getID() == 505 ? "" : this.mouseInfoProvider.getInfoAt(mouseEvent.getX(), mouseEvent.getY());
        } else if (view != null) {
            string = view.getInfoAt(mouseEvent.getX(), mouseEvent.getY());
        }
        if (isMousePositionWithinImageShown && view != null && string != null && !string.isEmpty() && (nArray = view.getImageCoordsAtScreenPosition(mouseEvent.getX(), mouseEvent.getY())) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(" [");
            stringBuilder.append(nArray[0]);
            stringBuilder.append(',');
            stringBuilder.append(nArray[1]);
            stringBuilder.append(']');
            string = stringBuilder.toString();
        }
        VisInfoManager.setVisInfoText(string);
    }

    public void setMouseInfoProvider(IMouseInfoProvider iMouseInfoProvider) {
        this.mouseInfoProvider = iMouseInfoProvider;
    }

    public void unsetMouseInfoProvider(IMouseInfoProvider iMouseInfoProvider) {
        if (iMouseInfoProvider == this.mouseInfoProvider) {
            this.mouseInfoProvider = null;
        }
    }

    public void resetMouseInfoProvider() {
        this.mouseInfoProvider = null;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.densityVisInfo(mouseEvent);
        this.handleMouseEnterExit(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (VisDisplay2.pjvi1754_isNavigDragActive()) {
            return;
        }
        if (this.vis.getVisDisplay() != null) {
            this.vis.getVisDisplay().getScrollBar().decreaseHidingCounter();
        }
        this.densityVisInfo(mouseEvent);
        if (this.isPlainLeftClick(mouseEvent) && currentLeftClick != null && !currentLeftClick.released) {
            VisMouseHandler.currentLeftClick.handleMouseEvent(mouseEvent);
        }
        this.handleMouseMoved(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!globalNavigEnabled) {
            return;
        }
        if (ignoreNextDrag) {
            ignoreNextDrag = false;
            return;
        }
        if (dragInfo == null) {
            this.mousePressed(this.convertMouseEvent(mouseEvent, 501));
        }
        this.densityVisInfo(mouseEvent);
        this.lastMovementPt = mouseEvent.getPoint();
        if (dragInfo != null) {
            dragInfo.drag(mouseEvent);
        }
        if (this.mouseWrapper != null && dragInfo != null && !this.vis.getVisDisplay().isDetached() && this.mouseWrapper.doWrap(dragInfo.getLastPoint())) {
            ignoreNextDrag = true;
        }
        if (currentLeftClick != null && dragInfo != null && VisMouseHandler.currentLeftClick.handleMouseEvent(VisMouseHandler.dragInfo.translatePoint(mouseEvent))) {
            return;
        }
    }

    private boolean isPlainLeftClick(MouseEvent mouseEvent) {
        if (this.exModifier == 0 || this.exModifier == 1024) {
            if (mouseEvent.getID() == 500 || mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
                return mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1;
            }
            return true;
        }
        return false;
    }

    private boolean isAltLeftClick(MouseEvent mouseEvent) {
        if (this.exModifier == 512 || this.exModifier == 1536) {
            if (mouseEvent.getID() == 500 || mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
                return mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1;
            }
            return true;
        }
        return false;
    }

    private boolean isShiftLeftClick(MouseEvent mouseEvent) {
        if (this.exModifier == 64 || this.exModifier == 1088) {
            if (mouseEvent.getID() == 500 || mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
                return mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1;
            }
            return true;
        }
        return false;
    }

    private boolean isPlainDoubleLeftClick(MouseEvent mouseEvent) {
        if (this.exModifier == 0 || this.exModifier == 1024) {
            if (mouseEvent.getID() == 500 || mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
                return mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.exModifier = ModifierKeys.getExtendedModifier((int)mouseEvent.getModifiersEx());
        if (!globalNavigEnabled) {
            return;
        }
        lastMouseButtonPressedTime = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        List<Component> list = this.getComponentsAt(mouseEvent.getPoint());
        VisMouseEventInfo visMouseEventInfo = this.analyzeEvent(mouseEvent, list);
        if (this.useDefaultGlobalClickHandler(mouseEvent, visMouseEventInfo)) {
            currentLeftClick = visMouseEventInfo;
            bl3 = currentLeftClick.type == ClickType.LOCALIZER;
        } else {
            currentLeftClick = null;
        }
        if (this.vis.hasData() && VisData.getLastModified() != this.vis.getData() && !bl3) {
            VisDisplayData visDisplayData = null;
            if (VisData.getLastModified() != null) {
                visDisplayData = VisData.getLastModified().getParent();
            }
            bl2 = visDisplayData != this.vis.getData().getParent();
            bl = true;
            this.vis.makeTheLastModified();
            ActionContextManager.singleton.contextChanged(this.vis.getVisDisplay().getData());
        }
        if (bl2 && Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get()) {
            this.vis.getVisDisplay().getSynchronizationManager().startAutomaticSynchronization();
        }
        boolean bl4 = bl;
        dragInfo = new DragInfo(mouseEvent, this);
        if (this.mouseWrapper != null && !this.vis.getVisDisplay().isDetached()) {
            this.mouseWrapper.startWrap();
        }
        if (currentLeftClick != null && VisMouseHandler.currentLeftClick.handleMouseEvent(mouseEvent)) {
            return;
        }
        dragInfo.press(mouseEvent);
        if (bl4) {
            this.vis.repaintBorder();
        }
    }

    private boolean useDefaultGlobalClickHandler(MouseEvent mouseEvent, VisMouseEventInfo visMouseEventInfo) {
        String string;
        boolean bl = this.isPlainLeftClick(mouseEvent);
        boolean bl2 = this.isPlainDoubleLeftClick(mouseEvent);
        boolean bl3 = this.isAltLeftClick(mouseEvent);
        boolean bl4 = this.isShiftLeftClick(mouseEvent);
        if (bl) {
            return true;
        }
        if (bl3 && (visMouseEventInfo.type == ClickType.HR || visMouseEventInfo.type == ClickType.HR_DIRECT)) {
            return true;
        }
        if (bl2 && (visMouseEventInfo.type == ClickType.ROI || visMouseEventInfo.type == ClickType.HR_DIRECT)) {
            return true;
        }
        if ((bl3 || bl4) && visMouseEventInfo.type == ClickType.ROI) {
            return true;
        }
        return bl2 && visMouseEventInfo.type == ClickType.HR && ((string = ((HotRegion)visMouseEventInfo.target).getName()).equals("NAVIG_LEFT") || string.equals("NAVIG_RIGHT"));
    }

    private VisMouseEventInfo analyzeEvent(MouseEvent mouseEvent, List<Component> list) {
        VisMouseEventInfo visMouseEventInfo = new VisMouseEventInfo();
        for (Component component : list) {
            MouseListener mouseListener;
            MouseEvent mouseEvent2 = VisMouseHandler.convertMouseEvent(mouseEvent, component);
            if (component instanceof HotRegion) {
                mouseListener = (HotRegion)component;
                visMouseEventInfo.addCompoment(ClickType.HR, component);
                if (((HotRegion)mouseListener).wasImageDirectlyPressed(mouseEvent2)) {
                    visMouseEventInfo.addCompoment(ClickType.HR_DIRECT, component);
                }
            }
            if (!(component instanceof IViewMouseHandler)) continue;
            mouseListener = (IViewMouseHandler)((Object)component);
            if (mouseListener.editableRoiLocatedAt(mouseEvent2.getX(), mouseEvent2.getY())) {
                visMouseEventInfo.addCompoment(ClickType.ROI, component);
            }
            if (visMouseEventInfo.type != ClickType.ROI && mouseListener.priorityRoiLocatedAt(mouseEvent2.getX(), mouseEvent2.getY())) {
                visMouseEventInfo.addCompoment(ClickType.PRIORITY_ROI, component);
            }
            if (!mouseListener.wantsEvent(mouseEvent2)) continue;
            visMouseEventInfo.addCompoment(ClickType.GREEDY, component);
        }
        if (this.vis.getView() != null && this.vis.getView().getMouseHandler().localizerWants(mouseEvent)) {
            visMouseEventInfo.addCompoment(ClickType.LOCALIZER, (Component)((Object)this.vis.getView().getMouseHandler()));
        }
        return visMouseEventInfo;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!globalNavigEnabled) {
            return;
        }
        if (currentLeftClick != null && dragInfo != null && VisMouseHandler.currentLeftClick.handleMouseEvent(VisMouseHandler.dragInfo.translatePoint(mouseEvent))) {
            return;
        }
        if (dragInfo != null && System.currentTimeMillis() - lastMouseButtonPressedTime < (long)this.getMaxTimeForDragTolerance() && dragInfo.getAbsoluteDistance() <= POPUP_DRAG_TOLERANCE && dragInfo.getAbsoluteDistance() > 0) {
            this.mouseClicked(this.convertMouseEvent(mouseEvent, 500));
        }
        if (dragInfo != null && (mouseEvent.getModifiersEx() & ANY_MOUSE_BUTTON_MASK) == 0) {
            dragInfo.release(mouseEvent);
            dragInfo = null;
        }
    }

    private int getMaxTimeForDragTolerance() {
        View view = this.vis.getView();
        int n = 400;
        if (view != null && !ContextMenuAction.isTraditionalPopupMenuEnabled(view)) {
            n *= 4;
        }
        return n;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!globalNavigEnabled) {
            return;
        }
        if (mouseEvent.getButton() == 0) {
            return;
        }
        if (currentLeftClick != null) {
            VisMouseHandler.currentLeftClick.handleMouseEvent(mouseEvent);
            return;
        }
        int n = ModifierKeys.getExtendedModifier((int)this.exModifier);
        KeyShortcut keyShortcut = new KeyShortcut(mouseEvent.getClickCount() % 2 == 1 ? 400 : 402, n |= MouseEvent.getMaskForButton(mouseEvent.getButton()));
        configuration.handleAction(keyShortcut, this);
    }

    public static boolean isZoomByMouseWheelActive(View view) {
        if (!view.getDisplay().isMouseWheelZoomEnabled()) {
            return false;
        }
        if (ModifierKeys.isSpacePressed() || ModifierKeys.isCtrl()) {
            return true;
        }
        MouseSubModes mouseSubModes = view.getDisplayData().getDisplayPlugin().getMouseModeInfo().getSubMode();
        if (mouseSubModes == MouseSubModes.ZOOM_PAN) {
            return true;
        }
        if (mouseSubModes.isMeasurement() && view.getVis() == VisData.getLastModified()) {
            if (zoomWheelMoude == ZoomWheelMode.AUTO && ViewMouseHandler.deactivateMeasurementAfterDrawing) {
                return true;
            }
            if (zoomWheelMoude == ZoomWheelMode.ON) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        VisMouseHandler.handleMouseWheelMoved(this.vis, mouseWheelEvent);
    }

    public static void handleMouseWheelMoved(Vis2 vis2, MouseWheelEvent mouseWheelEvent) {
        MouseWheelListener mouseWheelListener;
        if (vis2 == null || mouseWheelEvent.getWheelRotation() == 0 || !vis2.hasData()) {
            return;
        }
        int n = ModifierKeys.getExtendedModifier((MouseEvent)mouseWheelEvent);
        if (vis2.getView().wantsMouseWheelEvent(mouseWheelEvent)) {
            if (VisData.getLastModified() != vis2.getData() && n != 0) {
                vis2.makeTheLastModified();
            }
            if (vis2.getView().handleMouseWheel(mouseWheelEvent)) {
                return;
            }
        }
        if ((mouseWheelListener = configuration.getWheelHandler(n)) != null) {
            mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
        }
    }

    private static MouseEvent convertMouseEvent(MouseEvent mouseEvent, Component component) {
        return VisMouseHandler.convertMouseEvent(mouseEvent, component, mouseEvent.getID());
    }

    private MouseEvent convertMouseEvent(MouseEvent mouseEvent, int n) {
        return VisMouseHandler.convertMouseEvent(mouseEvent, null, n);
    }

    private static MouseEvent convertMouseEvent(MouseEvent mouseEvent, Component component, int n) {
        MouseEvent mouseEvent2 = mouseEvent;
        mouseEvent2 = component instanceof IViewMouseHandler || component == null ? new MouseEvent(mouseEvent.getComponent(), n, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()) : new MouseEvent(mouseEvent.getComponent(), n, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX() - component.getBounds().x, mouseEvent.getY() - component.getBounds().y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        return mouseEvent2;
    }

    public IMouseModeInfo getMouseModeInfo() {
        if (this.vis != null && this.vis.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo() != null) {
            return this.vis.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo();
        }
        return null;
    }

    private static enum ClickType {
        PRIORITY_ROI,
        HR_DIRECT,
        LOCALIZER,
        ROI,
        HR,
        GREEDY,
        OTHER;

    }

    private static class VisMouseEventInfo {
        private ClickType type = ClickType.OTHER;
        private Component target = null;
        private Component secondaryTarget = null;
        private boolean released = false;

        private VisMouseEventInfo() {
        }

        private void addCompoment(ClickType clickType, Component component) {
            if (clickType.ordinal() < this.type.ordinal()) {
                this.secondaryTarget = this.target;
                this.target = component;
                this.type = clickType;
            }
        }

        private void sendEventToMouseHandler(MouseEvent mouseEvent, Component component) {
            MouseListener mouseListener = (MouseListener)((Object)component);
            MouseMotionListener mouseMotionListener = (MouseMotionListener)((Object)component);
            MouseEvent mouseEvent2 = VisMouseHandler.convertMouseEvent(mouseEvent, component);
            if (mouseEvent.getID() == 501) {
                mouseListener.mousePressed(mouseEvent2);
            } else if (mouseEvent.getID() == 502) {
                mouseListener.mouseReleased(mouseEvent2);
            } else if (mouseEvent.getID() == 500) {
                mouseListener.mouseClicked(mouseEvent2);
            } else if (mouseEvent.getID() == 506) {
                mouseMotionListener.mouseDragged(mouseEvent2);
            } else if (mouseEvent.getID() == 503) {
                mouseMotionListener.mouseMoved(mouseEvent2);
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private boolean handleMouseEvent(MouseEvent mouseEvent) {
            if (this.target == null) {
                return false;
            }
            if (mouseEvent.getID() == 502) {
                this.released = true;
            }
            if (mouseEvent.getID() == 503 && this.released) {
                return false;
            }
            switch (this.type) {
                case HR: {
                    if (mouseEvent.getID() == 500 && !((HotRegion)this.target).isClickable() && this.secondaryTarget != null) {
                        this.sendEventToMouseHandler(mouseEvent, this.secondaryTarget);
                        return true;
                    }
                }
                case PRIORITY_ROI: 
                case HR_DIRECT: 
                case ROI: 
                case GREEDY: {
                    this.sendEventToMouseHandler(mouseEvent, this.target);
                    return true;
                }
                case LOCALIZER: {
                    IViewMouseHandler iViewMouseHandler = (IViewMouseHandler)((Object)this.target);
                    iViewMouseHandler.handleLocalizer(mouseEvent);
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return (Object)((Object)this.type) + " at " + this.target;
        }
    }

    private static enum ZoomWheelMode {
        AUTO,
        ON,
        OFF;

    }
}

