/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.controls.hotregion.HotRegionGroup;
import com.tiani.gui.controls.hotregion.HotRegionListener;
import com.tiani.gui.controls.hotregion.ToolbarHotRegion;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.toptoolbar.StripeColumnsActionProvider;
import com.tiani.jvision.vis.PrintUtils;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class VisScreenToolBar2
extends JPanel
implements HotRegionListener {
    private static final IAIconFactory iconFactory = new IAIconFactory(28);
    private static final PIcon imgCols1 = iconFactory.loadIcon("icon_stripe_layout_cols1.svg");
    private static final PIcon imgCols2 = iconFactory.loadIcon("icon_stripe_layout_cols2.svg");
    private static final PIcon imgCols3 = iconFactory.loadIcon("icon_stripe_layout_cols3.svg");
    private static final PIcon imgCols4 = iconFactory.loadIcon("icon_stripe_layout_cols4.svg");
    private static final PIcon imgCols5 = iconFactory.loadIcon("icon_stripe_layout_cols5.svg");
    private static final PIcon imgCols6 = iconFactory.loadIcon("icon_stripe_layout_cols6.svg");
    private static final PIcon imgCols7 = iconFactory.loadIcon("icon_stripe_layout_cols7.svg");
    private static final PIcon imgCols8 = iconFactory.loadIcon("icon_stripe_layout_cols8.svg");
    private static final PIcon imgClear = iconFactory.loadIcon("clear.svg");
    private static final PIcon imgPrint = iconFactory.loadIcon("print.svg");
    private VisScreen2 screen;
    private Hashtable<String, HotRegion> allHRs = new Hashtable();
    private HotRegionGroup groupCols = new HotRegionGroup();
    private HotRegion hotCols1;
    private HotRegion hotCols2;
    private HotRegion hotCols3;
    private HotRegion hotCols4;
    private HotRegion hotCols5;
    private HotRegion hotCols6;
    private HotRegion hotCols7;
    private HotRegion hotCols8;
    private List<Component> globalActions;

    public VisScreenToolBar2(VisScreen2 visScreen2) {
        this.screen = visScreen2;
        this.setBackground(Color.BLACK);
        this.setLayout(new BoxLayout(this, 1));
        this.hotCols1 = this.createHR(StripeColumnsActionProvider.getActionIDForColumnCount(1), imgCols1, Messages.getString("VISSCREEN_TOOLTIP_HR_COLS1"), HotRegion.HotRegionType.Twostate_On);
        this.hotCols2 = this.createHR(StripeColumnsActionProvider.getActionIDForColumnCount(2), imgCols2, Messages.getString("VISSCREEN_TOOLTIP_HR_COLS2"), HotRegion.HotRegionType.Twostate_On);
        this.hotCols3 = this.createHR(StripeColumnsActionProvider.getActionIDForColumnCount(3), imgCols3, Messages.getString("VISSCREEN_TOOLTIP_HR_COLS3"), HotRegion.HotRegionType.Twostate_On);
        this.hotCols4 = this.createHR(StripeColumnsActionProvider.getActionIDForColumnCount(4), imgCols4, Messages.getString("VISSCREEN_TOOLTIP_HR_COLS4"), HotRegion.HotRegionType.Twostate_On);
        this.hotCols5 = this.createHR(StripeColumnsActionProvider.getActionIDForColumnCount(5), imgCols5, Messages.getString("VISSCREEN_TOOLTIP_HR_COLS5"), HotRegion.HotRegionType.Twostate_On);
        this.hotCols6 = this.createHR(StripeColumnsActionProvider.getActionIDForColumnCount(6), imgCols6, Messages.getString("VISSCREEN_TOOLTIP_HR_COLS6"), HotRegion.HotRegionType.Twostate_On);
        this.hotCols7 = this.createHR(StripeColumnsActionProvider.getActionIDForColumnCount(7), imgCols7, Messages.getString("VISSCREEN_TOOLTIP_HR_COLS7"), HotRegion.HotRegionType.Twostate_On);
        this.hotCols8 = this.createHR(StripeColumnsActionProvider.getActionIDForColumnCount(8), imgCols8, Messages.getString("VISSCREEN_TOOLTIP_HR_COLS8"), HotRegion.HotRegionType.Twostate_On);
        this.createHR("PRINT", imgPrint, Messages.getString("VISSCREEN_TOOLTIP_HR_PRINT"), HotRegion.HotRegionType.Normal);
        this.createHR("CLEAR_DISPLAY", imgClear, Messages.getString("VISSCREEN_TOOLTIP_HR_CLEAR"), HotRegion.HotRegionType.Normal);
        this.groupCols.add(this.hotCols1);
        this.groupCols.add(this.hotCols2);
        this.groupCols.add(this.hotCols3);
        this.groupCols.add(this.hotCols4);
        this.groupCols.add(this.hotCols5);
        this.groupCols.add(this.hotCols6);
        this.groupCols.add(this.hotCols7);
        this.groupCols.add(this.hotCols8);
    }

    public void addGlobalActions(Container container) {
        if (this.globalActions != null) {
            throw new IllegalStateException("Can not set global actions twice!");
        }
        this.globalActions = new ArrayList<Component>(container.getComponentCount());
        int n = 0;
        while (n < container.getComponentCount()) {
            this.globalActions.add(container.getComponent(n));
            ++n;
        }
    }

    public void updateHRs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.screen.getLytHRs(arrayList);
        this.screen.getHRs(arrayList);
        this.screen.getActiveHRs(arrayList2);
        this.activateHRs(arrayList2);
        this.addHRs(arrayList);
    }

    @Override
    public void hotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent) {
        if (this.groupCols.contains(hotRegion)) {
            PActionRegistry.getAction(hotRegion.getName()).perform(null);
            return;
        }
        if (hotRegion.getName().equals("CLEAR_DISPLAY")) {
            VisScreenToolBar2.onButtonClearScreen(this.screen);
        } else if (hotRegion.getName().equals("PRINT")) {
            VisScreenToolBar2.onButtonPrintScreen(this.screen);
        }
    }

    public static void onButtonPrintScreen(VisScreen2 visScreen2) {
        if (visScreen2.hasData()) {
            ArrayList<VisData> arrayList = new ArrayList<VisData>();
            for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                List<VisData> list = visDisplay2.getData().getSelectedVis();
                arrayList.addAll(list);
            }
            PrintUtils.print(arrayList, null);
        }
    }

    public static void onButtonClearScreen(VisScreen2 visScreen2) {
        visScreen2.clear();
        visScreen2.repaint();
    }

    @Override
    public void hotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
    }

    @Override
    public void hotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
    }

    @Override
    public void paint(Graphics graphics) {
        if (!JVision2.getMainFrame().isInitialized()) {
            return;
        }
        super.paint(graphics);
    }

    private boolean hasComponent(Component component) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void addHRs(List<String> list) {
        this.removeAll();
        int n = 0;
        while (n < this.globalActions.size()) {
            this.globalActions.get(n).setVisible(true);
            if (this.globalActions.get(n).getName().equals("TOOLBAR")) {
                this.globalActions.get(n).setVisible(false);
            }
            this.add(this.globalActions.get(n));
            ++n;
        }
        for (String string : list) {
            Component component = this.allHRs.get(string);
            if (component == null || this.hasComponent(component)) continue;
            this.add(component);
        }
    }

    private void activateHRs(List<String> list) {
        int n = 0;
        while (n < list.size()) {
            String string = list.get(n);
            HotRegion hotRegion = this.allHRs.get(string);
            if (hotRegion != null) {
                this.groupCols.setActive(hotRegion);
            }
            ++n;
        }
    }

    private HotRegion createHR(String string, PIcon pIcon, String string2, HotRegion.HotRegionType hotRegionType) {
        ToolbarHotRegion toolbarHotRegion = new ToolbarHotRegion();
        toolbarHotRegion.addListener(this);
        toolbarHotRegion.setImage(pIcon);
        toolbarHotRegion.setToolTipText(string2);
        toolbarHotRegion.setType(hotRegionType);
        toolbarHotRegion.setName(string);
        this.allHRs.put(string, toolbarHotRegion);
        return toolbarHotRegion;
    }
}

