/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.dnd;

import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.logging.ALogger;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.dnd.IVisDisplayDataFlavorProvider;
import com.tiani.jvision.vis.dnd.VisDisplayDataFlavorProviderFactory;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import sun.awt.dnd.SunDragSourceContextPeer;

public class VisDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private static final ALogger log = ALogger.getLogger(VisDragGestureRecognizer.class);
    private static boolean isSingleImageDrag = false;
    private static final long serialVersionUID = -4150786648176674043L;
    private boolean isDragAllowed = false;

    public VisDragGestureRecognizer(Vis2 vis2, DragSource dragSource, Component component, int n) {
        super(dragSource, component, n, new DragListener(dragSource, vis2));
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isDragAllowed) {
            this.isDragAllowed = false;
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(1, mouseEvent.getPoint());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
            int n = ModifierKeys.getExtendedModifier((MouseEvent)mouseEvent);
            if (n == 1088) {
                this.isDragAllowed = true;
                isSingleImageDrag = false;
            } else if (n == 1216) {
                this.isDragAllowed = true;
                isSingleImageDrag = true;
            }
        }
    }

    private static class DragListener
    extends DragSourceAdapter
    implements DragGestureListener {
        private DragSource dragSource;
        private Vis2 vis;

        public DragListener(DragSource dragSource, Vis2 vis2) {
            this.dragSource = dragSource;
            this.vis = vis2;
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultLinkDrop);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            try {
                SunDragSourceContextPeer.setDragDropInProgress(false);
            }
            catch (Throwable throwable) {}
            this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultLinkDrop, new VisDisplayTransferable(this.vis, isSingleImageDrag), this);
        }
    }

    private static class ImageEncoder
    implements Runnable {
        private static final int DPI = 300;
        private List<VisData> toProcess;
        private List<File> result;
        private Semaphore done = new Semaphore(0);

        private ImageEncoder(List<VisData> list) {
            this.toProcess = list;
        }

        public List<File> getResult() {
            this.done.acquireUninterruptibly();
            return this.result;
        }

        @Override
        public void run() {
            ArrayList<File> arrayList = new ArrayList<File>(this.toProcess.size());
            HashSet<String> hashSet = new HashSet<String>(this.toProcess.size());
            for (VisData visData : this.toProcess) {
                IFrameObjectData iFrameObjectData = visData.getFrameData();
                String string = iFrameObjectData.getSOPInstanceUID();
                if (hashSet.contains(string)) {
                    int n = 1;
                    while (hashSet.contains(String.valueOf(string) + "_" + n)) {
                        ++n;
                    }
                    string = String.valueOf(string) + "_" + n;
                }
                hashSet.add(string);
                File file = new File("tmp/" + string + ".jpg");
                if (file.exists()) {
                    file.delete();
                }
                try {
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                        BufferedImage bufferedImage = visData.getView().captureImage();
                        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
                        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                        jPEGEncodeParam.setDensityUnit(1);
                        jPEGEncodeParam.setXDensity(300);
                        jPEGEncodeParam.setYDensity(300);
                        jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
                        jPEGImageEncoder.encode(bufferedImage);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    log.error("IO Error", (Throwable)iOException);
                }
                arrayList.add(file);
                file.deleteOnExit();
            }
            this.result = arrayList;
            this.done.release();
        }
    }

    private static class VisDisplayTransferable
    implements Transferable {
        private static final List<DataFlavor> flavors = VisDisplayTransferable.getSupportedFlavors();
        private Vis2 vis;
        private boolean isSingleImage;

        public VisDisplayTransferable(Vis2 vis2, boolean bl) {
            this.vis = vis2;
            this.isSingleImage = bl;
            vis2.getMouseHandler().externalDragStarted();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return flavors.toArray(new DataFlavor[flavors.size()]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return flavors.contains(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            try {
                if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    File file = new File("tmp");
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    Vector<File> vector = new Vector<File>();
                    VisDisplayData visDisplayData = this.vis.getData().getParent();
                    List<VisData> list = visDisplayData == null || this.isSingleImage ? Collections.singletonList(this.vis.getData()) : visDisplayData.getSelectedVis();
                    ImageEncoder imageEncoder = new ImageEncoder(list);
                    new Thread((Runnable)imageEncoder, "DragDrop").start();
                    vector.addAll(imageEncoder.getResult());
                    return vector;
                }
                if (dataFlavor.equals(VisDisplay2.dataFlavor)) {
                    return this.vis.getVisDisplay();
                }
                if (dataFlavor.equals(IDisplaySet.dataFlavor)) {
                    return this.vis.getVisDisplay().getData().getDisplaySet();
                }
                Collection<IVisDisplayDataFlavorProvider> collection = VisDisplayDataFlavorProviderFactory.getInstance().getVisDisplayDataFlavorProvider();
                if (collection != null) {
                    for (IVisDisplayDataFlavorProvider iVisDisplayDataFlavorProvider : collection) {
                        if (!iVisDisplayDataFlavorProvider.isFlavorSupported(dataFlavor)) continue;
                        return iVisDisplayDataFlavorProvider.getTransferData(dataFlavor, this.vis);
                    }
                }
            }
            catch (Exception exception) {
                log.error("VisDragGestureRecognizer", (Throwable)exception);
            }
            return null;
        }

        private static List<DataFlavor> getSupportedFlavors() {
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
            if (LicenseManager.getInstance().getLicense("IMAGE_EXPORT_DD") != null || Product.isCDViewer()) {
                arrayList.add(DataFlavor.javaFileListFlavor);
            }
            arrayList.add(VisDisplay2.dataFlavor);
            arrayList.add(IDisplaySet.dataFlavor);
            Collection<IVisDisplayDataFlavorProvider> collection = VisDisplayDataFlavorProviderFactory.getInstance().getVisDisplayDataFlavorProvider();
            if (collection != null) {
                for (IVisDisplayDataFlavorProvider iVisDisplayDataFlavorProvider : collection) {
                    DataFlavor[] dataFlavorArray = iVisDisplayDataFlavorProvider.getSupportedFlavors();
                    if (dataFlavorArray == null) continue;
                    DataFlavor[] dataFlavorArray2 = dataFlavorArray;
                    int n = dataFlavorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataFlavor dataFlavor = dataFlavorArray2[n2];
                        if (!arrayList.contains(dataFlavor)) {
                            arrayList.add(dataFlavor);
                        }
                        ++n2;
                    }
                }
            }
            return arrayList;
        }
    }
}

