/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.event.mouse;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeActionProvider;
import com.agfa.pacs.impaxee.vismenu.VisMenu;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.event.mouse.MouseUtils;
import java.awt.Component;
import java.awt.Point;

public class ContextMenuAction
extends AbstractPAction {
    public static final String ID = "CONTEXT_MENU";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getGroupName() {
        return "INTERNAL";
    }

    @Override
    public String getCaption() {
        return Messages.getString("ContextMenu");
    }

    @Override
    public String getToolTipText() {
        return this.getCaption();
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(400, 4096);
    }

    private static IMouseModeInfo getMouseModeInfo(VisDisplay2 visDisplay2) {
        if (visDisplay2 != null && visDisplay2.getData().getDisplayPlugin().getMouseModeInfo() != null) {
            return visDisplay2.getData().getDisplayPlugin().getMouseModeInfo();
        }
        return null;
    }

    private VisMenu newPopupMenu(Vis2 vis2) {
        return vis2.canShowMenu() ? new VisMenu(vis2) : null;
    }

    private void showTraditionalPopupMenu(Vis2 vis2, Component component, Point point) {
        if (!vis2.getVisDisplay().isPopupEnabled()) {
            return;
        }
        VisMenu visMenu = this.newPopupMenu(vis2);
        if (visMenu != null) {
            visMenu.show(component, (int)point.getX(), (int)point.getY());
        }
    }

    @Override
    public boolean perform(Component component) {
        View view = MouseUtils.getAssociatedView(component);
        if (view == null || !view.showContextMenu()) {
            return false;
        }
        if (ContextMenuAction.isTraditionalPopupMenuEnabled(view)) {
            this.notifyActionPerformed();
            this.showTraditionalPopupMenu(view.getVisView(), component, MouseUtils.mouseLocationForComponent(component));
        } else {
            this.notifyActionPerformed("INTERRUPT_MEASUREMENT_MODE");
            MouseModeActionProvider.handleEscape();
        }
        return true;
    }

    public static boolean isTraditionalPopupMenuEnabled(View view) {
        IMouseModeInfo iMouseModeInfo = ContextMenuAction.getMouseModeInfo(view.getDisplay());
        return iMouseModeInfo != null && !iMouseModeInfo.getSubMode().isQuickAbortEnabled();
    }
}

