/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.event.mouse;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.config.Gestures;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.agfa.pacs.impaxee.navigation.IDisplayNavigationHandler;
import com.agfa.pacs.jna.wintools.TouchUtils;
import com.tiani.jvision.image.View;
import com.tiani.jvision.keypress.KeypressRegistry;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.util.TouchConfigUtils;
import com.tiani.jvision.vis.DragHandler;
import com.tiani.jvision.vis.DragInfo;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisMouseHandler;
import com.tiani.jvision.vis.event.mouse.MousePreChargeHandlerFactory;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class DefaultDraggerHandler
extends DragHandler {
    private static final int NO_GESTURE_DISTANCE = VisMouseHandler.getPercentageOfMonitorSize(0.05);
    private static final int SMALL_GESTURE_DISTANCE = VisMouseHandler.getPercentageOfMonitorSize(0.1);
    private static final double SMALL_GESTURE_ANGLE_TAN = Math.tan(0.7853981633974483);
    private static final double LARGE_GESTURE_ANGLE_TAN = Math.tan(1.0471975511965976);
    private static final long GESTURE_MAX_TIME = 1500L;
    private static final boolean SCROLLING_IMPAX_ES = TouchConfigUtils.isSliceNavigationWithLeftMouseBtnEnabled();
    private double sliceSkipPerDY;
    private int sliceStartIndex;
    private int sliceCount;
    private int displaySetID;
    private MouseInputListener activeMousePreChargeHandler;
    private Gestures lastGesture = null;
    private long dragStart;

    @Override
    public void drag(MouseEvent mouseEvent, DragInfo dragInfo, VisMouseHandler visMouseHandler) {
        if (this.activeMousePreChargeHandler != null) {
            this.activeMousePreChargeHandler.mouseDragged(mouseEvent);
            return;
        }
        View view = visMouseHandler.getVis().getView();
        if (view != null && view.getDisplayData() != null && view.getDisplayData().getDisplayPlugin().getMouseModeInfo().getSubMode() != MouseSubModes.DEFAULT) {
            return;
        }
        IsGesture isGesture = this.isGesture(dragInfo);
        if (SCROLLING_IMPAX_ES && isGesture == IsGesture.No) {
            this.performScrolling(dragInfo, visMouseHandler);
        }
    }

    private IsGesture isGesture(DragInfo dragInfo) {
        boolean bl = TouchUtils.supportsTouchInput();
        if (System.currentTimeMillis() - this.dragStart > 1500L || !bl && dragInfo.getDragAbsX() == 0 || !bl && !KeypressRegistry.getInstance().useGestures()) {
            this.lastGesture = null;
            return IsGesture.No;
        }
        int n = dragInfo.getAbsoluteDistance();
        double d = Math.abs((double)dragInfo.getDragAbsY() / (double)dragInfo.getDragAbsX());
        IsGesture isGesture = IsGesture.No;
        if (d > SMALL_GESTURE_ANGLE_TAN) {
            isGesture = IsGesture.No;
        } else if (n < NO_GESTURE_DISTANCE) {
            isGesture = IsGesture.Maybe;
        } else if (n < SMALL_GESTURE_DISTANCE) {
            isGesture = IsGesture.Yes;
        } else {
            IsGesture isGesture2 = isGesture = d <= LARGE_GESTURE_ANGLE_TAN ? IsGesture.Yes : IsGesture.No;
        }
        if (isGesture == IsGesture.Yes) {
            if (bl) {
                if (Math.abs(dragInfo.getDragAbsY()) < 50) {
                    this.lastGesture = dragInfo.getDragAbsX() > 0 ? Gestures.RIGHT : Gestures.LEFT;
                }
            } else {
                this.lastGesture = dragInfo.getDragAbsX() > 0 ? (dragInfo.getDragAbsY() > 0 ? Gestures.RIGHT_DOWN : Gestures.RIGHT_UP) : (dragInfo.getDragAbsY() > 0 ? Gestures.LEFT_DOWN : Gestures.LEFT_UP);
            }
        } else {
            this.lastGesture = null;
        }
        return isGesture;
    }

    @Override
    public void startDragging(MouseEvent mouseEvent, VisMouseHandler visMouseHandler) {
        this.activeMousePreChargeHandler = MousePreChargeHandlerFactory.getInstance().createMousePreChargeHandler(visMouseHandler);
        if (this.activeMousePreChargeHandler != null) {
            this.activeMousePreChargeHandler.mousePressed(mouseEvent);
            return;
        }
        this.dragStart = System.currentTimeMillis();
        if (SCROLLING_IMPAX_ES && DefaultDraggerHandler.hasData(visMouseHandler)) {
            Rectangle rectangle = visMouseHandler.getBounds();
            VisDisplay2 visDisplay2 = visMouseHandler.getVis().getVisDisplay();
            IDisplayNavigationHandler iDisplayNavigationHandler = visDisplay2.getNavigationHandler();
            this.sliceStartIndex = iDisplayNavigationHandler.getCurrentDragPosition();
            this.sliceCount = iDisplayNavigationHandler.getDragPositionCount();
            this.sliceSkipPerDY = (double)this.sliceCount / rectangle.getHeight();
            IDisplaySet iDisplaySet = visDisplay2.getData().getDisplaySet();
            if (iDisplaySet != null) {
                this.displaySetID = iDisplaySet.getID();
            }
        }
    }

    @Override
    public void endDragging(MouseEvent mouseEvent, VisMouseHandler visMouseHandler) {
        if (this.activeMousePreChargeHandler != null) {
            this.activeMousePreChargeHandler.mouseReleased(mouseEvent);
            this.activeMousePreChargeHandler = null;
        } else if (this.lastGesture != null) {
            PAction pAction = this.lastGesture.getAction();
            if (pAction != null && pAction.isEnabled() && pAction.isAvailable()) {
                pAction.perform(visMouseHandler);
            }
            this.lastGesture = null;
        }
    }

    private boolean performScrolling(DragInfo dragInfo, VisMouseHandler visMouseHandler) {
        int n;
        Vis2 vis2 = visMouseHandler.getVis();
        if (!DefaultDraggerHandler.hasData(visMouseHandler) || JVision2.getMainFrame() != null && Math.abs(dragInfo.getDragRelY()) > JVision2.getMainFrame().getSize().height / 2) {
            return false;
        }
        int n2 = visMouseHandler.getVis().getVisDisplay().getData().getDisplaySet().getID();
        if (this.displaySetID != n2) {
            n = dragInfo.getDragRelY() < 0 ? visMouseHandler.getVis().getVisDisplay().getNavigationHandler().getDragPositionCount() : -this.sliceCount;
            this.sliceStartIndex += n;
            this.displaySetID = n2;
            this.sliceCount = visMouseHandler.getVis().getVisDisplay().getNavigationHandler().getDragPositionCount();
        }
        n = (int)Math.round((double)dragInfo.getDragAbsY() * this.sliceSkipPerDY) + this.sliceStartIndex;
        int n3 = vis2.getVisDisplay().getNavigationHandler().convertToMouseWheelMovement(n);
        if (n3 != 0) {
            vis2.getVisDisplay().handleMouseWheelMovement(n3, true);
            return true;
        }
        return false;
    }

    private static boolean hasData(VisMouseHandler visMouseHandler) {
        Vis2 vis2 = visMouseHandler.getVis();
        return vis2 != null && vis2.hasData() && vis2.getVisDisplay() != null;
    }

    private static enum IsGesture {
        Yes,
        No,
        Maybe;

    }
}

