/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.event.mouse;

import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.event.mouse.MouseUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DoubleClickAction
extends AbstractPAction {
    private static final String ID = "DOUBLE_CLICK";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getGroupName() {
        return "INTERNAL";
    }

    @Override
    public String getCaption() {
        return "Double click";
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(402, 1024);
    }

    @Override
    public String getToolTipText() {
        return this.getCaption();
    }

    @Override
    public boolean perform(Component component) {
        View view = MouseUtils.getAssociatedView(component);
        if (view == null) {
            return false;
        }
        Vis2 vis2 = view.getVisView();
        if (vis2 == null) {
            return false;
        }
        VisDisplay2 visDisplay2 = view.getDisplay();
        IMouseModeInfo iMouseModeInfo = visDisplay2.getData().getDisplayPlugin().getMouseModeInfo();
        if (iMouseModeInfo.getSubMode() == MouseSubModes.DEFAULT) {
            this.notifyActionPerformed();
            Point point = MouseUtils.mouseLocationForComponent(component);
            if (DoubleClickAction.switchFullSize(point, vis2)) {
                MouseEvent mouseEvent = new MouseEvent(vis2, 502, System.currentTimeMillis(), 0, point.x, point.y, 0, false, 1);
                Vis2 vis22 = view.getVisView();
                if (vis22 != null) {
                    vis22.getMouseHandler().mouseReleased(mouseEvent);
                }
            }
        }
        return true;
    }

    public static boolean switchFullSize(Point point, Vis2 vis2) {
        if (point.getY() < (double)(vis2.getSize().height / 2)) {
            if (vis2.getVisDisplay().canDoFullSwitch()) {
                vis2.getVisDisplay().switchFullDisplay(true);
            } else {
                vis2.getVisDisplay().switchFullScreen(true);
            }
            return true;
        }
        if (point.getY() >= (double)(vis2.getSize().height / 2)) {
            vis2.getVisDisplay().switchFullScreen(true);
            return true;
        }
        return false;
    }
}

