/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.event.mouse;

import com.tiani.gui.util.LocationUtil;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisMouseHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.annotation.Nullable;

public class MouseUtils {
    @Nullable
    public static MouseEvent generateVirtualClick(Component component) {
        Point point = LocationUtil.getCurrentAbsoluteMousepointerLocation();
        if (component.isShowing()) {
            Point point2 = component.getLocationOnScreen();
            return new MouseEvent(component, 500, System.currentTimeMillis(), 0, point.x - point2.x, point.y - point2.y, 1, false, 1);
        }
        return null;
    }

    public static MouseEvent generateMouseRelease(Component component, int n) {
        Point point = LocationUtil.getCurrentAbsoluteMousepointerLocation();
        Point point2 = component.getLocationOnScreen();
        return new MouseEvent(component, 502, System.currentTimeMillis(), n, point.x - point2.x, point.y - point2.y, 1, false, 1);
    }

    public static Point mouseLocationForComponent(Component component) {
        Point point = LocationUtil.getCurrentAbsoluteMousepointerLocation();
        Point point2 = component.getLocationOnScreen();
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    public static View getAssociatedView(Component component) {
        View view = null;
        if (component instanceof VisMouseHandler) {
            view = ((VisMouseHandler)component).getVis().getView();
        } else {
            VisData visData = VisData.getLastModified();
            if (visData != null) {
                view = visData.getView();
            }
        }
        return view;
    }
}

