/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.layout;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.LayoutConfig;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.layout.IStateLyt;
import com.tiani.jvision.vis.layout.StateLyt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public abstract class Lyt<T extends StateLyt>
implements LayoutManager,
IStateLyt {
    protected static ALogger log = ALogger.getLogger(Lyt.class);
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int UNDEFINED = -1;
    public static final int SCROLLBARTHICKNESS = 18;
    protected int minCols = 1;
    protected int maxCols = 1;
    protected int minRows = 1;
    protected int maxRows = 1;
    protected int cols = 1;
    protected int rows = 1;
    protected int realCols = this.cols;
    protected int realRows = this.rows;
    private T savedState;

    public abstract MainLayoutType getMainLayoutType();

    @Override
    public int getCols() {
        return this.cols;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    public Dimension getDim() {
        return new Dimension(this.cols, this.rows);
    }

    public void setCols(int n) {
        if (n < this.minCols) {
            log.debug(this + ": cant set less than " + this.minCols + " cols! tried: " + n);
            n = this.minCols;
        }
        if (n > this.maxCols) {
            log.debug(this + ": cant set more than " + this.maxCols + " cols! tried: " + n);
            n = this.maxCols;
        }
        this.cols = n;
        this.recalcRealCols(null);
    }

    public void setRows(int n) {
        if (n < this.minRows) {
            n = this.minRows;
        }
        if (n > this.maxRows) {
            n = this.maxRows;
        }
        this.rows = n;
        this.recalcRealRows(null);
    }

    public boolean isSupportedDimension(int n, int n2) {
        return this.minCols <= n && n <= this.maxCols && this.minRows <= n2 && n2 <= this.maxRows;
    }

    protected void recalcRealCols(Container container) {
        this.realCols = this.cols;
    }

    protected void recalcRealRows(Container container) {
        this.realRows = this.rows;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(1, 1);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return container.getSize();
    }

    protected int getVisDisplayToolbarThickness(Container container) {
        int n = 0;
        n = JVision2.getMainFrame() != null ? JVision2.getMainFrame().getBounds().width : container.getBounds().width;
        int n2 = LayoutConfig.getInstance().getScreenColumns();
        int n3 = n / n2;
        int n4 = n3 / 30;
        int n5 = GUI.getScaledDiagnosticInt((int)20);
        int n6 = GUI.getScaledDiagnosticInt((int)28);
        if (n4 < n5) {
            return n5;
        }
        if (n4 > n6) {
            return n6;
        }
        return n4;
    }

    public void saveStateLyt(T t) {
        this.savedState = t;
    }

    public T getSavedStateLyt() {
        return this.savedState;
    }

    public void clearSavedStateLyt() {
        this.savedState = null;
    }
}

