/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.layout;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.tiani.config.LayoutConfig;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.util.TouchConfigUtils;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.LytDisplay;
import java.awt.Container;

public class LytDisplayStripe
extends LytDisplay {
    private static final boolean mergedSingleMonitor = Config.impaxee.local.MONITORS.UseMonitorsTogetherInStripeLayout.get();

    public LytDisplayStripe() {
        this.minRows = 1;
        this.maxRows = 1;
        this.minCols = 1;
        this.maxCols = 8;
        this.init();
    }

    protected void init() {
        this.setCols(8);
    }

    @Override
    protected void recalcRealCols(Container container) {
        int n;
        this.realCols = this.cols;
        int n2 = this.getMonitorCount();
        if (n2 <= 1) {
            return;
        }
        int n3 = this.getVisDisplayToolbarThickness(container);
        int n4 = 0;
        int n5 = 0;
        int n6 = n = 0;
        while (n6 < n2) {
            int n7 = this.getWidthInMonitorEstimate(container, n6, n, n2, n3);
            if (n6 == n) {
                n5 = n7 / this.cols;
            }
            n4 = (int)((long)n4 + Math.round((double)n7 / (double)n5));
            ++n6;
        }
        this.realCols = n4;
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        if (container == null) {
            return;
        }
        int n2 = container.getBounds().width;
        int n3 = container.getBounds().height;
        int n4 = this.getMonitorCount();
        int n5 = this.getVisDisplayToolbarThickness(container);
        Vis2[] vis2Array = this.getVis(container);
        Vis2 vis2 = null;
        int n6 = 1;
        int n7 = 2;
        int n8 = n2 - 3;
        int n9 = n3 - 4;
        if (vis2Array.length == 0) {
            return;
        }
        n8 = 1;
        int n10 = 0;
        int n11 = 0;
        int n12 = n = 0;
        while (n12 < n4) {
            int n13 = this.getWidthInMonitorExact(container, n12, n, n4, n5);
            if (n12 == n) {
                n8 = n13 / this.cols;
            }
            n8 = n8 == 0 ? 1 : n8;
            int n14 = this.cols;
            n6 = n11;
            int n15 = n13 - n8 * n14 + 1;
            if (n15 == 1) {
                ++n6;
            }
            n6 += n15 / 2;
            String string = Config.impaxee.jvision.DISPLAY.ScrollBarAlign.get();
            if (n12 == 0 && n4 > 1 && string.equalsIgnoreCase("RIGHT")) {
                n6 += 18;
                n11 += 18;
            }
            int n16 = 0;
            while (n16 < n14 && n10 < vis2Array.length) {
                vis2 = vis2Array[n10];
                vis2.setBounds(n6, n7, n8, n9);
                n6 += n8;
                ++n16;
                ++n10;
            }
            n11 += n13;
            ++n12;
        }
    }

    private int getWidthInMonitorEstimate(Container container, int n, int n2, int n3, int n4) {
        MainFrame2 mainFrame2 = JVision2.getMainFrame();
        VisScreen2 visScreen2 = mainFrame2.getScreens().get(0);
        int n5 = mainFrame2.getBounds().width;
        int n6 = (n5 - 8) / n3 / 5;
        if (!visScreen2.getMainToolBar().isActive()) {
            n6 = 0;
        }
        if (JVision2.getMainFrame().getToolBarMode() != 0) {
            n6 = 0;
        }
        int n7 = n6 + n4 + 4;
        int n8 = n4 + 4;
        boolean bl = TouchConfigUtils.useScrollBars();
        int n9 = 1;
        if (bl) {
            String string = Config.impaxee.jvision.DISPLAY.ScrollBarAlign.get();
            if (string.equalsIgnoreCase("LEFT")) {
                n9 = 0;
            }
            if (string.equalsIgnoreCase("TOP")) {
                n9 = 2;
            }
            if (string.equalsIgnoreCase("BOTTOM")) {
                n9 = 3;
            }
        }
        int n10 = 0;
        if (bl) {
            n10 = 18;
            if (n9 == 2 || n9 == 3) {
                n10 = 0;
            }
        }
        if (bl && n9 == 0) {
            n7 += n10;
        } else if (bl && n9 == 1) {
            n8 += n10;
        }
        int n11 = LayoutConfig.getInstance().getImageAreaWidth();
        int n12 = n11 / n3;
        int n13 = (n5 - 8) / n3;
        if (n > n2 && n < n2 + n3 - 1) {
            return n12;
        }
        if (n > n2) {
            n8 += n6;
        }
        int n14 = n13;
        if (n == n2) {
            n14 -= n7;
        }
        if (n == n2 + n3 - 1) {
            n14 -= n8;
        }
        if (container != null && container.getWidth() > 0) {
            return this.calculateWidthInMonitor(container.getWidth(), n3, n2, n, n4, n9);
        }
        return n14 - 8;
    }

    protected int calculateWidthInMonitor(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = TouchConfigUtils.useScrollBars();
        int n7 = LayoutConfig.getInstance().getImageAreaWidth();
        int n8 = n7 / n2;
        int n9 = n;
        if (n2 > 2) {
            n9 = n - n8 * (n2 - 2);
        }
        if (bl && (n6 == 0 || n6 == 1)) {
            n9 += 18;
        }
        if (n2 > 1) {
            n9 /= 2;
        }
        if (n4 == n3) {
            if (bl && (n6 == 0 || n6 == 1)) {
                n9 -= 18;
            }
        } else if (n4 == n3 + n2 - 1) {
            if (bl && n6 == 1) {
                n9 -= 18;
            }
        } else {
            n9 = n8;
        }
        return n9;
    }

    protected int getWidthInMonitorExact(Container container, int n, int n2, int n3, int n4) {
        if (container == null) {
            return 0;
        }
        int n5 = 0;
        if (mergedSingleMonitor) {
            int n6 = 0;
            while (n6 < n3) {
                n5 += this.getWidthInMonitorEstimate(container, n6, n2, n3, n4);
                ++n6;
            }
        } else {
            n5 = this.getWidthInMonitorEstimate(container, n, n2, n3, n4);
        }
        return n5;
    }

    protected int getMonitorCount() {
        if (mergedSingleMonitor) {
            return 1;
        }
        return LayoutConfig.getInstance().getScreenCount();
    }

    @Override
    public MainLayoutType getMainLayoutType() {
        return MainLayoutType.stripe;
    }
}

