/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.layout;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.toptoolbar.TopToolbarPane;
import com.tiani.config.LayoutConfig;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainToolBar2;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.VisScreenToolBar2;
import com.tiani.jvision.vis.layout.LytMain;
import java.awt.Container;

public class LytMainVariable
extends LytMain {
    public LytMainVariable() {
        this.init();
    }

    protected void init() {
        this.maxCols = this.cols = LayoutConfig.getInstance().getScreenColumns();
        this.minCols = this.cols;
        this.minRows = 1;
        this.maxRows = 99;
        this.rows = LayoutConfig.getInstance().getScreenRows();
    }

    @Override
    public boolean allowsOneMoreToolBar(Container container) {
        if (container == null) {
            return false;
        }
        if (!JVision2.getMainFrame().possiblyMoreThanOneToolbar()) {
            return this.getToolBarCount(container) < 1;
        }
        int n = 1;
        if (this.cols > 1) {
            n = 2;
        }
        return this.getToolBarCount(container) < n;
    }

    @Override
    public void setRows(int n) {
        int n2 = LayoutConfig.getInstance().getScreenRows();
        n = n2;
        if (n < this.minRows) {
            log.debug(this + ": cant set less than " + this.minRows + " rows! tried: " + n);
            n = this.minRows;
        }
        if (n > this.maxRows) {
            log.debug(this + ": cant set more than " + this.maxRows + " rows! tried: " + n);
            n = this.maxRows;
        }
        this.rows = n;
        this.recalcRealRows(null);
    }

    public int getRowOfScreen(VisScreen2 visScreen2) {
        VisScreen2[] visScreen2Array = this.getScreens(visScreen2.getParent());
        int n = 0;
        while (n < visScreen2Array.length) {
            if (visScreen2Array[n] == visScreen2) {
                return n / this.cols;
            }
            ++n;
        }
        return -1;
    }

    public int getColumnOfScreen(VisScreen2 visScreen2) {
        VisScreen2[] visScreen2Array = this.getScreens(visScreen2.getParent());
        int n = 0;
        while (n < visScreen2Array.length) {
            if (visScreen2Array[n] == visScreen2) {
                return n % this.cols;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        if (container == null) {
            return;
        }
        int n2 = container.getBounds().width;
        int n3 = container.getBounds().height;
        Modes.PaletteOrientation paletteOrientation = JVision2.getMainFrame().getPaletteOrientation();
        int n4 = n2;
        if (!paletteOrientation.isHorizontal()) {
            n4 += JVision2.getMainFrame().getLeftSeriesPaletteWidth() + JVision2.getMainFrame().getRightSeriesPaletteWidth();
        }
        int n5 = n4 / this.cols;
        int n6 = 0;
        VisScreen2[] visScreen2Array = this.getScreens(container);
        if (visScreen2Array.length == 0) {
            return;
        }
        int n7 = 0;
        int n8 = 0;
        TopToolbarPane topToolbarPane = JVision2.getMainFrame().getTopToolbar();
        if (topToolbarPane != null && topToolbarPane.getBehaviour() == 2) {
            n7 += topToolbarPane.getHeight();
        }
        if (paletteOrientation.isHorizontal()) {
            n = JVision2.getMainFrame().getSeriesPaletteHeight();
            if (paletteOrientation == Modes.PaletteOrientation.NORTH) {
                n7 += n;
            } else {
                n8 += n;
            }
        }
        n = this.getVisDisplayToolbarThickness(container);
        MainToolBar2 mainToolBar2 = visScreen2Array[0].getMainToolBar();
        MainToolBar2 mainToolBar22 = this.getLastMonitorColumnMainToolBar(container, visScreen2Array);
        int n9 = n3;
        if (this.rows > 1) {
            n9 = (n3 + n7 + n8) / this.rows - n7;
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < visScreen2Array.length) {
            VisScreenToolBar2 visScreenToolBar2;
            boolean bl;
            int n13 = n12 % this.cols;
            int n14 = n12 / this.cols;
            boolean bl2 = n13 == 0;
            boolean bl3 = bl = n13 + 1 == this.cols;
            if (n12 > 0 && bl2) {
                n11 += n9;
                n9 = (n3 + n7 + n8) / this.rows;
                if (n14 == this.rows - 1) {
                    n9 -= n8;
                }
            }
            int n15 = n5;
            if (bl2) {
                n10 = 0;
            }
            if (bl2) {
                if (n14 == 0 && JVision2.getMainFrame().getToolBarMode() == 0 && mainToolBar2.isActive()) {
                    mainToolBar2.setBounds(0, 0, n6, n3);
                }
                n10 += n6;
                n15 -= n6;
                if (!paletteOrientation.isHorizontal()) {
                    n15 -= JVision2.getMainFrame().getLeftSeriesPaletteWidth();
                }
            }
            if (bl && (mainToolBar22 != null || JVision2.getMainFrame().getRightSeriesPaletteWidth() > 0)) {
                n15 -= n6;
                n15 -= JVision2.getMainFrame().getRightSeriesPaletteWidth();
            }
            boolean bl4 = false;
            if (this.useVisScreenToolBar() && bl2) {
                visScreenToolBar2 = visScreen2Array[n12].getToolBar();
                visScreenToolBar2.setBounds(n10, n11, n, n9);
                n10 += n;
                bl4 = true;
            } else {
                visScreen2Array[n12].getToolBar().setVisible(this.useVisScreenToolBar());
            }
            visScreen2Array[n12].setBounds(n10, n11, n15 -= this.useVisScreenToolBar() ? n : 0, n9);
            n10 += n15;
            if (this.useVisScreenToolBar() && !bl4) {
                visScreenToolBar2 = visScreen2Array[n12].getToolBar();
                visScreenToolBar2.setBounds(n10, n11, n, n9);
                visScreenToolBar2.setVisible(this.useVisScreenToolBar());
                n10 += n;
            } else {
                visScreen2Array[n12].getToolBar().setVisible(this.useVisScreenToolBar());
            }
            if (mainToolBar22 != null && bl && this.cols > 1) {
                mainToolBar22.setBounds(n10, 0, n6, n3);
                n10 += n6;
                mainToolBar22 = null;
            }
            ++n12;
        }
    }

    protected MainToolBar2 getLastMonitorColumnMainToolBar(Container container, VisScreen2[] visScreen2Array) {
        if (JVision2.getMainFrame().possiblyMoreThanOneToolbar() && visScreen2Array.length > 1) {
            MainToolBar2 mainToolBar2 = visScreen2Array[visScreen2Array.length - 1].getMainToolBar();
            return mainToolBar2.isActive() ? mainToolBar2 : null;
        }
        return null;
    }

    public static int getCommanderWidth(Modes.PaletteOrientation paletteOrientation) {
        int n = JVision2.getMainFrame().getContentPane().getWidth();
        LayoutConfig layoutConfig = LayoutConfig.getInstance();
        if (n <= 0) {
            n = layoutConfig.getImageAreaWidth();
        }
        n /= layoutConfig.getScreenColumns();
        int n2 = JVision2.getMainFrame().getContentPane().getHeight();
        if (n2 <= 0) {
            n2 = layoutConfig.getImageAreaHeight();
        }
        n2 /= layoutConfig.getScreenRows();
        int n3 = GUI.getScaledDiagnosticInt((int)((int)Config.impaxee.jvision.SEQPANEL.TokenSize.get()));
        double d = Config.impaxee.workstation.MONITORS.SeriesPanelDockedWidth.get();
        if (d < 0.3) {
            d = paletteOrientation.isHorizontal() ? d * (double)n2 + 20.0 : d * (double)n + 20.0;
        }
        d = Math.max(d, (double)(!paletteOrientation.isHorizontal() ? GUI.getScaledDiagnosticInt((int)210) : GUI.getScaledDiagnosticInt((int)115) + n3));
        return (int)d;
    }

    public boolean useVisScreenToolBar() {
        return false;
    }

    @Override
    public MainLayoutType getMainLayoutType() {
        return MainLayoutType.variable;
    }
}

