/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.layout;

import com.agfa.pacs.impaxee.hanging.model.enums.VariableLayout;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolBar;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayScrollBar;
import com.tiani.jvision.vis.layout.IStateLytScreen;
import com.tiani.jvision.vis.layout.Lyt;
import com.tiani.jvision.vis.layout.StateLytScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public abstract class LytScreen
extends Lyt<StateLytScreen>
implements IStateLytScreen {
    private Map<Point, Dimension> mergedCells;

    public boolean isEquivalent(int n, int n2, Map<Point, Dimension> map) {
        return this.isEquivalent(new StateLytScreen(n, n2, map));
    }

    public boolean isEquivalent(IStateLytScreen iStateLytScreen) {
        return StateLytScreen.isEquivalent(this, iStateLytScreen);
    }

    public String getType() {
        return StateLytScreen.getType(this);
    }

    public String getDescription() {
        VariableLayout[] variableLayoutArray = VariableLayout.values();
        int n = variableLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLayout variableLayout = variableLayoutArray[n2];
            if (this.isEquivalent(variableLayout)) {
                return variableLayout.getDescription();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Map<Point, Dimension> getMergedCells() {
        if (this.mergedCells == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.mergedCells);
    }

    public void setMergedCells(Map<Point, Dimension> map) {
        this.mergedCells = map;
    }

    public boolean hasMergedCells() {
        return this.mergedCells != null && !this.mergedCells.isEmpty();
    }

    public int getDisplayCount(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof VisDisplay2) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public VisDisplay2[] getDisplays(Container container) {
        Component[] componentArray = container.getComponents();
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>(componentArray.length);
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof VisDisplay2) {
                arrayList.add((VisDisplay2)componentArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new VisDisplay2[arrayList.size()]);
    }

    public boolean allowsOneMoreDisplay(Container container) {
        if (container == null) {
            return false;
        }
        return this.getDisplayCount(container) < this.getRequiredDisplayCount();
    }

    public int getMissingDisplayCount(Container container) {
        if (container == null) {
            return 0;
        }
        return this.getRequiredDisplayCount() - this.getDisplayCount(container);
    }

    protected int getRequiredDisplayCount() {
        return StateLytScreen.getRequiredDisplayCount(this);
    }

    public int getRowOfDisplay(VisDisplay2 visDisplay2) {
        VisDisplay2[] visDisplay2Array = this.getDisplays(visDisplay2.getScreen());
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n < visDisplay2Array.length && n3 < this.cols) {
                if (visDisplay2Array[n] == visDisplay2) {
                    return n2;
                }
                ++n3;
                ++n;
            }
            ++n2;
        }
        return -1;
    }

    public int getColumnOfDisplay(VisDisplay2 visDisplay2) {
        VisDisplay2[] visDisplay2Array = this.getDisplays(visDisplay2.getScreen());
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n < visDisplay2Array.length && n3 < this.cols) {
                if (visDisplay2Array[n] == visDisplay2) {
                    return n3;
                }
                ++n3;
                ++n;
            }
            ++n2;
        }
        return -1;
    }

    protected boolean isToolBarMouseKnockingConfigured() {
        return VisDisplayToolBar.isToolbarMouseKnockingConfigured();
    }

    protected int getToolbarAlignment() {
        return VisDisplayToolBar.getConfiguredAlignment();
    }

    protected int getVerticalToolbarWidth(int n, Container container) {
        if (n == 0 || n == 1) {
            return this.getVisDisplayToolbarThickness(container);
        }
        return 0;
    }

    protected int getHorizontalToolbarHeight(int n, Container container) {
        if (n == 2 || n == 3) {
            return this.getVisDisplayToolbarThickness(container);
        }
        return 0;
    }

    protected boolean isScrollBarMouseKnockingConfigured() {
        return VisDisplayScrollBar.isHideScrollbar();
    }

    protected int getScrollbarAlignment() {
        return VisDisplayScrollBar.getConfiguredAlignment();
    }

    protected int getVerticalScrollbarWidth(int n) {
        if (n == 0 || n == 1) {
            return 18;
        }
        return 0;
    }

    protected int getHorizontalScrollbarHeight(int n) {
        if (n == 2 || n == 3) {
            return 18;
        }
        return 0;
    }

    protected void setScrollbarOrientation(VisDisplay2 visDisplay2, int n) {
        if (n != -1) {
            visDisplay2.getScrollBar().setOrientation(n == 0 || n == 1 ? 1 : 0);
        }
    }

    void tileLayout(Container container) {
        if (container == null) {
            return;
        }
        VisDisplay2[] visDisplay2Array = this.getDisplays(container);
        if (visDisplay2Array.length == 0) {
            return;
        }
        int n = container.getBounds().width;
        int n2 = container.getBounds().height;
        int n3 = this.getToolbarAlignment();
        int n4 = this.getScrollbarAlignment();
        n4 = VisDisplayScrollBar.adjustScrollBarAlignment(n4, n3);
        int n5 = this.getVerticalScrollbarWidth(n4);
        int n6 = this.getHorizontalScrollbarHeight(n4);
        int n7 = this.getVerticalToolbarWidth(n3, container);
        int n8 = this.getHorizontalToolbarHeight(n3, container);
        int n9 = 0;
        int n10 = n - 0;
        int n11 = n2 - 0;
        int n12 = n10 / this.cols;
        int n13 = n11 / this.rows;
        int n14 = 0;
        HashSet<Point> hashSet = new HashSet<Point>();
        int n15 = 0;
        while (n15 < this.rows) {
            int n16 = 0;
            int n17 = 0;
            while (n14 < visDisplay2Array.length && n17 < this.cols) {
                Point point = new Point(n17, n15);
                if (hashSet.contains(point)) {
                    n16 = 0 + (n17 + 1) * n12;
                } else {
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    VisDisplay2 visDisplay2 = visDisplay2Array[n14];
                    ++n14;
                    VisDisplayToolBar visDisplayToolBar = visDisplay2.getToolBar();
                    boolean bl = visDisplay2.getData().getDisplayPlugin().wantsDisplayToolbar();
                    boolean bl2 = visDisplay2.getData().getDisplayPlugin().wantsScrollbar();
                    int n22 = this.isScrollBarMouseKnockingConfigured() || !bl2 ? 0 : n5;
                    int n23 = this.isScrollBarMouseKnockingConfigured() || !bl2 ? 0 : n6;
                    int n24 = this.isToolBarMouseKnockingConfigured() || !bl ? 0 : n7;
                    int n25 = this.isToolBarMouseKnockingConfigured() || !bl ? 0 : n8;
                    int n26 = n9;
                    int n27 = n12 - n22 - n24;
                    int n28 = n13 - n23 - n25;
                    Dimension dimension = this.getDisplayExtent(point);
                    if (dimension != null && (dimension.width != 1 || dimension.height != 1)) {
                        n21 = n17;
                        while (n21 < n17 + dimension.width) {
                            n20 = n15;
                            while (n20 < n15 + dimension.height) {
                                hashSet.add(new Point(n21, n20));
                                ++n20;
                            }
                            ++n21;
                        }
                        n27 *= dimension.width;
                        n27 += (dimension.width - 1) * (n22 + n24);
                        n28 *= dimension.height;
                        n28 += (dimension.height - 1) * (n23 + n25);
                    }
                    if (!bl) {
                        visDisplayToolBar.setBounds(0, 0, 0, 0);
                    } else {
                        n21 = this.isToolBarMouseKnockingConfigured() && visDisplayToolBar.isHidden() ? 0 : this.getVerticalToolbarWidth(n3, container);
                        n20 = this.isToolBarMouseKnockingConfigured() && visDisplayToolBar.isHidden() ? 0 : this.getHorizontalToolbarHeight(n3, container);
                        switch (n3) {
                            case 0: {
                                visDisplayToolBar.setBounds(n16, n9, n21, n28 + n23);
                                n16 += n24;
                                break;
                            }
                            case 2: {
                                visDisplayToolBar.setBounds(n16, n9, n27 + n22, n20);
                                n26 += n25;
                                break;
                            }
                            case 1: {
                                n19 = n16 + n27 + (!this.isScrollBarMouseKnockingConfigured() ? n22 : 0) - (this.isToolBarMouseKnockingConfigured() ? n21 : 0);
                                visDisplayToolBar.setBounds(n19, n9, n21, n28 + n23);
                                break;
                            }
                            case 3: {
                                n18 = n9 + n28 + (!this.isScrollBarMouseKnockingConfigured() ? n23 : 0) - (this.isToolBarMouseKnockingConfigured() ? n20 : 0);
                                visDisplayToolBar.setBounds(n16, n18, n27 + n22, n20);
                            }
                        }
                    }
                    VisDisplayScrollBar visDisplayScrollBar = visDisplay2.getScrollBar();
                    if (!bl2) {
                        visDisplayScrollBar.setBounds(0, 0, 0, 0);
                    } else {
                        this.setScrollbarOrientation(visDisplay2, n4);
                        n20 = this.isScrollBarMouseKnockingConfigured() && !visDisplayScrollBar.isVisible() ? 0 : this.getVerticalScrollbarWidth(n4);
                        n19 = this.isScrollBarMouseKnockingConfigured() && !visDisplayScrollBar.isVisible() ? 0 : this.getHorizontalScrollbarHeight(n4);
                        switch (n4) {
                            case 0: {
                                visDisplayScrollBar.setBounds(n16, n26, n20, n28);
                                n16 += n22;
                                break;
                            }
                            case 2: {
                                visDisplayScrollBar.setBounds(n16, n26, n27, n19);
                                n26 += n23;
                                break;
                            }
                            case 1: {
                                n18 = n16 + n27 - (this.isScrollBarMouseKnockingConfigured() ? n20 : 0);
                                visDisplayScrollBar.setBounds(n18, n26, n20, n28);
                                break;
                            }
                            case 3: {
                                int n29 = n26 + n28 - (this.isScrollBarMouseKnockingConfigured() ? n19 : 0);
                                visDisplayScrollBar.setBounds(n16, n29, n27, n19);
                            }
                        }
                    }
                    visDisplay2.setBounds(n16, n26, n27, n28);
                    n16 = 0 + (n17 + 1) * n12;
                }
                ++n17;
            }
            n9 += n13;
            ++n15;
        }
    }

    private Dimension getDisplayExtent(Point point) {
        if (this.mergedCells == null) {
            return null;
        }
        return this.mergedCells.get(point);
    }
}

