/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.sessions.gui.WorklistChooser;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.util.StorageLicense;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KeyImageModificationAction
extends AbstractPAction {
    private static final ALogger log = ALogger.getLogger(KeyImageModificationAction.class);
    public static final String ID = "STORE_FLAGS";

    @Override
    public String getCaption() {
        IStudyData iStudyData = this.getStudy();
        if (iStudyData != null) {
            if (this.isEnabledForEdit(iStudyData)) {
                return Messages.getString("KeyImageModificationAction.Edit.Caption");
            }
            if (this.isEnabledForSave(iStudyData)) {
                if (iStudyData.getKeyImageManager().hasSavedKeyImages()) {
                    return Messages.getString("KeyImageModificationAction.Save.Caption");
                }
                return Messages.getString("ImgView2.StoreFlags");
            }
        }
        return Messages.getString("KeyImageModificationAction.Default.Caption");
    }

    @Override
    public String getGroupName() {
        return WORKFLOW_HANDLING_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public boolean perform(Component component) {
        this.notifyActionPerformed();
        IStudyData iStudyData = this.getStudy();
        if (iStudyData != null) {
            if (this.isEnabledForEdit(iStudyData)) {
                iStudyData.getKeyImageManager().startEditMode();
            } else if (this.isEnabledForSave(iStudyData)) {
                KeyImageModificationAction.saveKeyImages(iStudyData);
            }
        }
        return true;
    }

    @Override
    public boolean isAvailable() {
        return StorageLicense.canStoreKO();
    }

    @Override
    protected boolean isEnabledImpl() {
        IStudyData iStudyData;
        if (this.isAvailable() && (iStudyData = this.getStudy()) != null) {
            return this.isEnabledForEdit(iStudyData) || this.isEnabledForSave(iStudyData);
        }
        return false;
    }

    private boolean isEnabledForEdit(IStudyData iStudyData) {
        return !iStudyData.getKeyImageManager().isInEditMode() && iStudyData.getKeyImageManager().hasKeyImages();
    }

    private boolean isEnabledForSave(IStudyData iStudyData) {
        return iStudyData.getKeyImageManager().hasUnsavedKeyImages();
    }

    private IStudyData getStudy() {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData != null) {
            return visData.getStudyData();
        }
        return null;
    }

    private static void saveKeyImages(IStudyData iStudyData) {
        KeyImageType[] keyImageTypeArray = iStudyData.getKeyImageManager().getModifiedTypes();
        if (keyImageTypeArray != null) {
            KeyImageType[] keyImageTypeArray2 = keyImageTypeArray;
            int n = keyImageTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyImageType keyImageType = keyImageTypeArray2[n2];
                if (KeyImageType.ForConference == keyImageType) {
                    KeyImageModificationAction.addToWorklistsAndSaveKeyImages(iStudyData, keyImageType);
                } else {
                    iStudyData.getKeyImageManager().save(keyImageType, false);
                }
                ++n2;
            }
        }
    }

    private static void addToWorklistsAndSaveKeyImages(IStudyData iStudyData, KeyImageType keyImageType) {
        List<IFrameObjectData> list = iStudyData.getKeyImageManager().getKeyImages(keyImageType);
        KeyImageModificationAction.addToWorklists(list, () -> {
            boolean bl = iStudyData.getKeyImageManager().save(keyImageType, false);
        });
    }

    public static void addToWorklists(Collection<IFrameObjectData> collection) {
        KeyImageModificationAction.addToWorklists(collection, null);
    }

    private static void addToWorklists(final Collection<IFrameObjectData> collection, final Runnable runnable) {
        if (collection != null && !collection.isEmpty()) {
            try {
                IPerform iPerform;
                Collection<IWorklistContext> collection2;
                IStore iStore = DataManager.getInstance().getDataStore();
                ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>(iStore.getAvailableWorklistContexts());
                WorklistChooser worklistChooser = new WorklistChooser(JVision2.getMainFrame(), arrayList, null);
                if ("OK_OPTION".equals(worklistChooser.getDialogResult()) && (collection2 = worklistChooser.getSelectedWorklistContexts()) != null && !collection2.isEmpty() && (iPerform = DataManager.getInstance().getDataPerform("ADD_TO_WORKLIST")) != null) {
                    EventUtil.invokeNotOnEDT((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IPerform.IPerformResult iPerformResult = iPerform.perform(new IPerform.DefaultPerformContext(JVision2.getMainFrame(), collection2), collection);
                            if (iPerformResult != null && iPerformResult.getReturnCode() >= 0 && runnable != null) {
                                runnable.run();
                            }
                        }
                    });
                }
            }
            catch (Exception exception) {
                log.error("Adding marked images to worklist(s) failed!", (Throwable)exception);
            }
        }
    }
}

