/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractDynamicGroupPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;

public class MeasuringUnitSelector
extends AbstractDynamicGroupPAction {
    public static final String ID = "MEASURING_UNITS";

    @Override
    public PAction[] createSubactions() {
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData == null) {
            return new PAction[0];
        }
        ArrayList<MeasuringUnitAction> arrayList = new ArrayList<MeasuringUnitAction>();
        IMutableImageState iMutableImageState = visData.getView().getImageState();
        SpacingDef spacingDef = iMutableImageState.getCurrentSpacingDef();
        for (SpacingDef spacingDef2 : iMutableImageState.spacingDefs()) {
            arrayList.add(new MeasuringUnitAction(visData.getView(), spacingDef2, spacingDef == spacingDef2));
        }
        return arrayList.toArray(new PAction[arrayList.size()]);
    }

    @Override
    public boolean isUpdatingListeners() {
        return false;
    }

    @Override
    public String getCaption() {
        return Messages.getString("ImageSettings.MeasuringUnit");
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    private static class MeasuringUnitAction
    extends AnonymousPAction {
        private SpacingDef spacing;
        private View view;
        private boolean selected;

        public MeasuringUnitAction(View view, SpacingDef spacingDef, boolean bl) {
            this.view = view;
            this.spacing = spacingDef;
            this.selected = bl;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public String getCaption() {
            return this.spacing.toString();
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed(MeasuringUnitSelector.ID);
            for (VisData object2 : this.view.getDisplay().getVis()) {
                object2.getView().getImageState().selectCurrentSpacingDef(this.spacing);
            }
            SpacingDef spacingDef = this.view.getImageState().getCurrentSpacingDef();
            TEvent tEvent = new TEvent(95);
            tEvent.source = null;
            TEventDispatch.sendEvent(this.view.getDisplay(), tEvent, (Object)spacingDef, false);
            return true;
        }
    }
}

