/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.hap.pacs.data.valuemapping.IValueMapping;
import com.agfa.hap.pacs.data.valuemapping.IValueMappingOption;
import com.agfa.hap.pacs.data.valuemapping.RealWorldValueMapping;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractDynamicGroupPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.valuemapping.DefaultValueMappingOption;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.WindowDef;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class RealWorldValueMappingSelector
extends AbstractDynamicGroupPAction {
    public static final String ID = "REAL_WORLD_VALUE_MAPPING_SELECTOR";
    private static final ALogger LOGGER = ALogger.getLogger(RealWorldValueMappingSelector.class);

    @Override
    public PAction.ActionType getActionType() {
        return PAction.ActionType.SubmenuExclusive;
    }

    @Override
    public PAction[] createSubactions() {
        ImgView2 imgView2;
        List<RealWorldValueMapping> list;
        VisData visData = AbstractPDataAction.getCurrentImage();
        if (visData == null) {
            return new PAction[0];
        }
        List<Object> list2 = new ArrayList();
        if (visData.getView() instanceof ImgView2 && !(list = (imgView2 = (ImgView2)visData.getView()).getImageInformation().getRealWorldValueMappings()).isEmpty()) {
            list2 = this.collectValueMappings(imgView2, list);
        }
        return list2.toArray(new PAction[list2.size()]);
    }

    private List<PAction> collectValueMappings(ImgView2 imgView2, List<RealWorldValueMapping> list) {
        ArrayList<PAction> arrayList = new ArrayList<PAction>(list.size() + 1);
        IValueMapping iValueMapping = imgView2.getImageState().getCurrentValueMapping();
        WindowDef windowDef = imgView2.getWindowHandler().getWindow();
        arrayList.add(new RealWorldValueMappingAction(imgView2, new DefaultValueMappingOption(windowDef.getUnit()), windowDef.equals(iValueMapping)));
        for (RealWorldValueMapping realWorldValueMapping : list) {
            boolean bl = realWorldValueMapping.isEquivalent(iValueMapping);
            arrayList.add(new RealWorldValueMappingAction(imgView2, (IValueMappingOption)realWorldValueMapping, bl));
        }
        return arrayList;
    }

    @Override
    public boolean isUpdatingListeners() {
        return false;
    }

    @Override
    public String getCaption() {
        return Messages.getString("ValueMapping.Label");
    }

    @Override
    public String getGroupName() {
        return IMAGE_DISPLAY_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    private static class RealWorldValueMappingAction
    extends AnonymousPAction {
        private final ImgView2 view;
        private final IValueMappingOption option;
        private final boolean selected;

        public RealWorldValueMappingAction(ImgView2 imgView2, IValueMappingOption iValueMappingOption, boolean bl) {
            this.view = imgView2;
            this.option = iValueMappingOption;
            this.selected = bl;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public String getCaption() {
            return this.option.getLabel();
        }

        @Override
        public String getToolTipText() {
            return this.option.getDescription();
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed(RealWorldValueMappingSelector.ID);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Activating value mapping: " + this.option);
            }
            TEvent tEvent = new TEvent(120);
            TEventDispatch.sendEventToVis(this.view.getDisplay(), tEvent, this.option, 16);
            return true;
        }
    }
}

