/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.event.mouse.MouseUtils;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class SelectionActionProvider
implements PActionProvider {
    public static final String SELECT_ALL_ID = "SELECT_ALL";
    public static final String DESELECT_ALL_ID = "DESELECT_ALL";
    public static final String INVERT_SELECTION_ID = "INVERT_SELECTION";
    public static final String SELECTION_GROUP_ID = "SELECTION_GROUP";
    private static final String SELECT_RANGE = "SELECT_RANGE_ACTION";
    private static final String SELECT_ONE = "SELECT_ONE_ACTION";
    public static final String STEPWISE_SELECTION_GROUP_ID = "STEPWISE_SELECTION_GROUP";
    private static final Object STEPWISE_SELECTION_ID_PREFIX = "STEPWISE_SELECTION_";

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new SelectAll());
        arrayList.add(new DeselectAll());
        arrayList.add(new InvertSelection());
        arrayList.add(new SelectionGroupAction(arrayList));
        arrayList.add(new SelectImageAction(true));
        arrayList.add(new SelectImageAction(false));
        arrayList.add(new SelectRangeAction(true));
        arrayList.add(new SelectRangeAction(false));
        ArrayList<PAction> arrayList2 = new ArrayList<PAction>(4);
        int n = 2;
        while (n <= 5) {
            arrayList2.add(new StepwiseSelectionAction(n));
            ++n;
        }
        arrayList.addAll(arrayList2);
        arrayList.add(new StepwiseSelectionGroupAction(arrayList2));
        return arrayList;
    }

    static VisDisplay2 getVisDisplay(Component component) {
        View view = MouseUtils.getAssociatedView(component);
        if (view == null) {
            return null;
        }
        return view.getDisplay();
    }

    public static String getStepwiseActionID(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STEPWISE_SELECTION_ID_PREFIX);
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private static abstract class AbstractSelectionAction
    extends AbstractPAction {
        protected boolean select;

        public AbstractSelectionAction(boolean bl) {
            this.select = bl;
        }

        @Override
        public String getToolTipText() {
            return this.getCaption();
        }

        @Override
        public String getGroupName() {
            return "INTERNAL";
        }
    }

    private static class DeselectAll
    extends AbstractPAction {
        @Override
        public String getName() {
            return Messages.getString("SelectionHandler.DeselectAllImages.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.DeselectAllImages.Caption");
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(402, 4160);
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.DESELECT_ALL_ID;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisDisplay2 visDisplay2 = SelectionActionProvider.getVisDisplay(component);
            if (visDisplay2 != null) {
                for (VisData visData : visDisplay2.getData().getVis()) {
                    visData.setSelected(false);
                    Vis2 vis2 = visData.getVisual();
                    if (vis2 == null) continue;
                    vis2.repaintBorder();
                }
                return true;
            }
            return false;
        }
    }

    private static class InvertSelection
    extends AbstractPAction {
        @Override
        public String getName() {
            return Messages.getString("SelectionHandler.InvertSelection.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.InvertSelection.Caption");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.INVERT_SELECTION_ID;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            for (VisData visData : AbstractPDataAction.getVisDatas(PDataScope.CurrentDisplay)) {
                visData.setSelected(!visData.isSelected(), true);
            }
            return true;
        }
    }

    private static class SelectAll
    extends AbstractPAction {
        @Override
        public String getName() {
            return Messages.getString("SelectionHandler.SelectAllImages.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.SelectAllImages.Caption");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.SELECT_ALL_ID;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(402, 1088);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisDisplay2 visDisplay2 = SelectionActionProvider.getVisDisplay(component);
            if (visDisplay2 != null) {
                for (VisData visData : visDisplay2.getData().getVis()) {
                    visData.setSelected(true);
                    Vis2 vis2 = visData.getVisual();
                    if (vis2 == null) continue;
                    vis2.repaintBorder();
                }
                return true;
            }
            return false;
        }
    }

    private static class SelectImageAction
    extends AbstractSelectionAction {
        public SelectImageAction(boolean bl) {
            super(bl);
        }

        @Override
        public String getID() {
            return String.valueOf(!this.select ? "DE" : "") + SelectionActionProvider.SELECT_ONE;
        }

        @Override
        public String getCaption() {
            return this.select ? "Select one" : "Deselect one";
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(400, (this.select ? 1024 : 4096) | 0x40);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            View view = MouseUtils.getAssociatedView(component);
            if (view != null) {
                VisData visData = view.getVis();
                visData.setSelected(this.select);
                Vis2 vis2 = visData.getVisual();
                if (vis2 != null) {
                    vis2.repaintBorder();
                }
                return true;
            }
            return false;
        }
    }

    private static class SelectRangeAction
    extends AbstractSelectionAction {
        public SelectRangeAction(boolean bl) {
            super(bl);
        }

        @Override
        public String getID() {
            return String.valueOf(!this.select ? "DE" : "") + SelectionActionProvider.SELECT_RANGE;
        }

        @Override
        public String getCaption() {
            return this.select ? "Select range" : "Deselect range";
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(400, (this.select ? 1024 : 4096) | 0x40 | 0x80);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            View view = MouseUtils.getAssociatedView(component);
            if (view != null) {
                VisDisplay2 visDisplay2 = view.getDisplay();
                VisData visData = view.getVis();
                int n = visDisplay2.getData().indexOf(visData);
                int n2 = n - 1;
                while (n2 >= 0) {
                    if (visDisplay2.getData().getVis(n2).isSelected() == this.select) break;
                    --n2;
                }
                visData.setSelected(this.select);
                ++n2;
                while (n2 < n) {
                    visDisplay2.getData().getVis(n2).setSelected(this.select, true);
                    ++n2;
                }
                return true;
            }
            return false;
        }
    }

    private static class SelectionGroupAction
    extends CompoundAbstractPAction {
        public SelectionGroupAction(List<PAction> list) {
            this.init(list);
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.Selection");
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.SELECTION_GROUP_ID;
        }
    }

    private static class StepwiseSelectionAction
    extends AbstractPAction {
        private final int step;

        public StepwiseSelectionAction(int n) {
            this.step = n;
        }

        @Override
        public String getName() {
            return MessageFormat.format(Messages.getString("SelectionHandler.StepwiseSelection.Step.Name"), this.step);
        }

        @Override
        public String getCaption() {
            return MessageFormat.format(Messages.getString("SelectionHandler.StepwiseSelection.Step.Caption"), this.step);
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.getStepwiseActionID(this.step);
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            List<VisData> list = AbstractPDataAction.getVisDatas(PDataScope.CurrentDisplay);
            VisData visData = AbstractPDataAction.getCurrentImage();
            int n = 0;
            int n2 = 0;
            while (n2 < list.size()) {
                VisData visData2 = list.get(n2);
                visData2.setSelected(false, true);
                if (visData2 == visData) {
                    n = n2;
                }
                ++n2;
            }
            n2 = n;
            while (n2 < list.size()) {
                list.get(n2).setSelected(true, true);
                n2 += this.step;
            }
            return true;
        }
    }

    private static class StepwiseSelectionGroupAction
    extends CompoundAbstractPAction {
        public StepwiseSelectionGroupAction(List<PAction> list) {
            this.init(list);
        }

        @Override
        public String getName() {
            return Messages.getString("SelectionHandler.StepwiseSelection.Group.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("SelectionHandler.StepwiseSelection.Group.Caption");
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SelectionActionProvider.STEPWISE_SELECTION_GROUP_ID;
        }
    }
}

