/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.xds.source.XDSDocumentSourceFactory;
import com.agfa.pacs.listtext.lta.util.referencedobject.XDSDataInfoNode;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.menu.AbstractFlagGroupAction;

public class XDSFlagGroupAction
extends AbstractFlagGroupAction {
    private static final String CONFIGURATION_KEY_USE_PIX = "listtext.lta.xdsi.pix.usePIX";
    private static final String CONFIGURATION_KEY_TARGET_ISSUER = "listtext.lta.xdsi.targetIssuer";

    public XDSFlagGroupAction() {
        super(KeyImageType.ForXDS);
    }

    @Override
    public boolean isAvailable() {
        return XDSDocumentSourceFactory.getInstance().xdsRepositoryAvailable();
    }

    @Override
    public boolean isEnabledImpl() {
        return XDSFlagGroupAction.flagForXDSAvailableForCurrentImage();
    }

    private static boolean flagForXDSAvailable(VisData visData) {
        if (visData != null) {
            IDataInfoSource iDataInfoSource = visData.getParent().getDisplaySet().getOneObject().getQueryObject().getSource();
            if (iDataInfoSource instanceof XDSDataInfoNode) {
                return false;
            }
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
            if (iConfigurationProvider.getBoolean(CONFIGURATION_KEY_USE_PIX)) {
                return true;
            }
            String string = visData.getPatientData().getDicomObject().getString(0x100021);
            String string2 = iConfigurationProvider.getString(CONFIGURATION_KEY_TARGET_ISSUER);
            if (string2.equals(string) || string2.length() == 0 && string == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean flagForXDSAvailableForCurrentImage() {
        return XDSFlagGroupAction.flagForXDSAvailable(AbstractPDataAction.getCurrentImage());
    }
}

