/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.util.expressions;

import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.util.expressions.BooleanNode;
import com.tiani.util.expressions.DataEvaluationContext;
import com.tiani.util.expressions.EvaluationContext;
import com.tiani.util.expressions.IEvaluableData;
import com.tiani.util.expressions.IEvaluationContext;
import com.tiani.util.expressions.parser;
import com.tiani.util.expressions.scanner;
import java_cup.runtime.Symbol;

public class BooleanExpression {
    private static ALogger log = ALogger.getLogger(BooleanExpression.class);
    private String expression;
    private BooleanNode node;

    public BooleanExpression(String string) {
        this(string, false);
    }

    public BooleanExpression(String string, boolean bl) {
        this.expression = string;
        if (this.expression != null && string.length() > 0) {
            this.node = this.compile(bl);
        }
    }

    public BooleanExpression(BooleanNode booleanNode) {
        this.node = booleanNode;
    }

    public boolean isEmpty() {
        return this.node == null;
    }

    public boolean evaluate(IEvaluableData iEvaluableData) {
        if (iEvaluableData instanceof IDataObject) {
            return this.evaluate(new DataEvaluationContext((IDataObject)iEvaluableData));
        }
        return this.evaluate(new EvaluationContext(iEvaluableData, null));
    }

    public boolean evaluate(IEvaluationContext iEvaluationContext) {
        return this.isEmpty() || iEvaluationContext == null ? false : this.node.evaluate(iEvaluationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BooleanNode compile(boolean bl) {
        Class<scanner> clazz = scanner.class;
        synchronized (scanner.class) {
            scanner.setInput(this.expression);
            parser parser2 = new parser();
            Symbol symbol = null;
            try {
                symbol = parser2.parse();
            }
            catch (Exception exception) {
                if (bl) {
                    log.trace("Parsing condition failed: {}", (Object)this.expression);
                }
                log.warn("Parsing condition failed: {}", (Object)this.expression, (Object)exception);
            }
            return symbol != null ? (BooleanNode)symbol.value : null;
        }
    }

    public String toString() {
        return this.expression;
    }
}

