/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.util.expressions;

import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;

public abstract class ConditionUtil {
    private static final ALogger log = ALogger.getLogger(ConditionUtil.class);

    public static boolean requiresNumberValue(VR vR) {
        return vR == VR.US || vR == VR.DS || vR == VR.FL || vR == VR.FD || vR == VR.IS || vR == VR.SL || vR == VR.SS || vR == VR.UL;
    }

    public static boolean requiresNumberValue(Integer n) {
        TagDictionary tagDictionary = TagDictionary.getInstance();
        VR vR = null;
        if (tagDictionary.isPrivatTag(n)) {
            PrivateTag privateTag2 = tagDictionary.getPrivateTag(n);
            try {
                Field field = VR.class.getField(privateTag2.getVr());
                Object object = field.get(null);
                if (object instanceof VR) {
                    vR = (VR)object;
                }
            }
            catch (Exception exception) {
                log.warn("Cannot find VR object for: " + vR);
            }
        } else {
            vR = ElementDictionary.vrOf((int)n, null);
        }
        return ConditionUtil.requiresNumberValue(vR);
    }

    private ConditionUtil() {
    }
}

