/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.util.expressions;

import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.splitsort.DisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.FrameObjectDataComparator;
import com.agfa.pacs.impaxee.splitsort.model.xml.SortField;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.util.expressions.BooleanNode;
import com.tiani.util.expressions.CompareOperation;
import com.tiani.util.expressions.IEvaluableData;
import com.tiani.util.expressions.IEvaluationContext;
import com.tiani.util.expressions.StringNode;
import com.tiani.util.expressions.impl.ImpaxEETagNumberFetcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class StringAbstractPositionNode
implements BooleanNode,
CompareOperation {
    protected List<IFrameObjectData> prepare(IEvaluationContext iEvaluationContext, StringNode stringNode) {
        String string = stringNode.evaluate(new ImpaxEETagNumberFetcher());
        return this.prepareCollectionForComparison(string, iEvaluationContext);
    }

    public List<IFrameObjectData> prepareCollectionForComparison(String string, IEvaluationContext iEvaluationContext) {
        Integer n;
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        boolean bl = n == PrivateTagDictionary.displaySetNumberOfImagesTag || n == PrivateTagDictionary.seriesNumberOfImagesTag;
        SortField sortField = new SortField();
        sortField.setTag(n);
        SortField[] sortFieldArray = new SortField[]{sortField};
        IDisplaySet[] iDisplaySetArray = this.getDisplaySets(iEvaluationContext.getData());
        if (iDisplaySetArray != null) {
            Object object;
            if (bl) {
                object = Arrays.asList(iDisplaySetArray);
                Collections.sort(object, new DisplaySetComparator(sortFieldArray));
            }
            IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
            int n2 = iDisplaySetArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = iDisplaySetArray2[n3];
                IFrameObjectData iFrameObjectData = object.getOneObject();
                if (iFrameObjectData != null) {
                    arrayList.add(object.getOneObject());
                }
                ++n3;
            }
        }
        if (!bl) {
            Collections.sort(arrayList, new FrameObjectDataComparator(sortFieldArray));
        }
        return arrayList;
    }

    private IDisplaySet[] getDisplaySets(IEvaluableData iEvaluableData) {
        IEvaluableData iEvaluableData2;
        IStudyContainer iStudyContainer;
        IStudyData iStudyData;
        if (iEvaluableData instanceof IFrameObjectData) {
            IFrameObjectData iFrameObjectData = (IFrameObjectData)iEvaluableData;
            return this.getDisplaySets(iFrameObjectData.getMainFrame().getParent().getParent().getParent());
        }
        if (iEvaluableData instanceof ISeriesData) {
            ISeriesData iSeriesData = (ISeriesData)iEvaluableData;
            return this.getDisplaySets(iSeriesData.getParent().getParent());
        }
        if (iEvaluableData instanceof IStudyData) {
            return this.getDisplaySets(((IStudyData)iEvaluableData).getParent());
        }
        if (iEvaluableData instanceof DisplaySetEvaluable && (iStudyData = (iStudyContainer = ((DisplaySetEvaluable)(iEvaluableData2 = (DisplaySetEvaluable)iEvaluableData)).getStudyContainer()).getBaseStudy()) != null) {
            return this.getDisplaySets(iStudyData);
        }
        if (iEvaluableData instanceof IImageObjectData) {
            iEvaluableData2 = (IImageObjectData)iEvaluableData;
            return this.getDisplaySets(iEvaluableData2.getParent().getParent().getParent());
        }
        return null;
    }

    private IDisplaySet[] getDisplaySets(IPatientData iPatientData) {
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iPatientData.getKey());
        if (iPatientRepresentation != null) {
            return iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
        }
        return null;
    }
}

