/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.util.message;

import com.tiani.util.message.IMessageHandler;
import com.tiani.util.message.Message;
import java.text.MessageFormat;

public abstract class AbstractMessageHandler
implements IMessageHandler {
    protected Object substituteArguments(Object object, Object[] objectArray) {
        return this.substituteArguments(object, objectArray, null);
    }

    protected Object substituteArguments(Object object, Object[] objectArray, Throwable throwable) {
        if (!(object instanceof String) || this.isEmptyMessage(object)) {
            if (this.isEmptyMessage(object) && throwable != null) {
                object = Message.exceptionToString(this.getInnermostException(throwable));
            }
            return object;
        }
        String string = (String)object;
        if (objectArray != null && objectArray.length > 0) {
            string = MessageFormat.format(string, objectArray);
        }
        if (throwable != null) {
            string = String.valueOf(string) + "\n\n" + Message.exceptionToString(throwable);
        }
        return string;
    }

    private Throwable getInnermostException(Throwable throwable) {
        if (throwable != null) {
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
        }
        return throwable;
    }

    private boolean isEmptyMessage(Object object) {
        return object == null || object instanceof String && ((String)object).length() <= 0;
    }
}

