/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.iod.sr;

import com.agfa.pacs.listtext.dicomobject.CompositeInformationObject;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObject;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectException;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectFactory;
import com.agfa.pacs.listtext.dicomobject.IModuleContainer;
import com.agfa.pacs.listtext.dicomobject.module.ko.KeyObjectDocumentModule;
import com.agfa.pacs.listtext.dicomobject.module.ko.KeyObjectDocumentSeriesModule;
import com.agfa.pacs.listtext.dicomobject.module.sr.SRDocumentContentModule;
import com.agfa.pacs.logging.ALogger;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class KeyObjectSelectionDocumentInformationObject
extends CompositeInformationObject {
    private static final ALogger LOG = ALogger.getLogger(KeyObjectSelectionDocumentInformationObject.class);
    private KeyObjectDocumentSeriesModule series;
    private KeyObjectDocumentModule document;
    private SRDocumentContentModule content;

    @Override
    public void init(boolean bl) {
        super.init(bl);
        this.series = this.getModule(KeyObjectDocumentSeriesModule.class);
        this.document = this.getModule(KeyObjectDocumentModule.class);
        this.content = this.getModule(SRDocumentContentModule.class);
        if (bl) {
            this.series.setModality("KO");
            Date date = new Date();
            this.document.setContentDate(date);
            this.document.setContentTime(date);
        }
    }

    public SRDocumentContentModule getSRDocumentContent() {
        return this.content;
    }

    public KeyObjectDocumentModule getKeyObjectDocument() {
        return this.document;
    }

    public KeyObjectDocumentSeriesModule getKeyObjectDocumentSeries() {
        return this.series;
    }

    public static KeyObjectSelectionDocumentInformationObject createInstance(Attributes attributes) {
        try {
            return (KeyObjectSelectionDocumentInformationObject)DicomInformationObjectFactory.getInstance().createDicomInformationObject(attributes);
        }
        catch (DicomInformationObjectException dicomInformationObjectException) {
            LOG.error("Key object creation failed", (Throwable)dicomInformationObjectException);
            return null;
        }
    }

    public static KeyObjectSelectionDocumentInformationObject createInstance(DicomInformationObject dicomInformationObject) {
        try {
            return (KeyObjectSelectionDocumentInformationObject)DicomInformationObjectFactory.getInstance().createDicomInformationObject("1.2.840.10008.5.1.4.1.1.88.59", dicomInformationObject);
        }
        catch (DicomInformationObjectException dicomInformationObjectException) {
            LOG.error("Key object creation failed", (Throwable)dicomInformationObjectException);
            return null;
        }
    }

    public static KeyObjectSelectionDocumentInformationObject createInstance() {
        try {
            return (KeyObjectSelectionDocumentInformationObject)DicomInformationObjectFactory.getInstance().createDicomInformationObject("1.2.840.10008.5.1.4.1.1.88.59", (IModuleContainer)null);
        }
        catch (DicomInformationObjectException dicomInformationObjectException) {
            LOG.error("Key object creation failed", (Throwable)dicomInformationObjectException);
            return null;
        }
    }
}

