/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.preview;

import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.print.AbstractPrintContext;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.mapper.MapperFilmBox;
import com.agfa.pacs.listtext.print.mapper.MapperFilmSession;
import com.agfa.pacs.listtext.print.mapper.MapperImageBox;
import com.agfa.pacs.listtext.print.preview.PreviewPrintManagement;
import com.agfa.pacs.listtext.print.renderer.FilmBox;
import com.agfa.pacs.listtext.print.renderer.FilmBoxSheet;
import com.agfa.pacs.listtext.print.renderer.ImageBox;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class PreviewPrintContext
extends AbstractPrintContext {
    private MapperFilmSession mfs;
    private PreviewPrintManagement printManagement;
    private Map<MapperFilmBox, BufferedImage> previewImages;
    private volatile boolean cancel;
    private IPrintContext.Status status;
    private double progress;

    public PreviewPrintContext(PreviewPrintManagement previewPrintManagement, MapperFilmSession mapperFilmSession) {
        this.printManagement = previewPrintManagement;
        this.mfs = mapperFilmSession;
        this.previewImages = new HashMap<MapperFilmBox, BufferedImage>();
        this.cancel = false;
        this.progress = 0.0;
        this.status = IPrintContext.Status.NotStarted;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean isRunning() {
        return this.status == IPrintContext.Status.InProgress;
    }

    public double getProgress() {
        return this.progress;
    }

    public IPrintContext.Status getStatus() {
        return this.status;
    }

    public void run() {
        this.status = IPrintContext.Status.InProgress;
        int n = this.mfs.filmBoxes().size();
        int n2 = 1;
        for (MapperFilmBox mapperFilmBox : this.mfs.filmBoxes()) {
            if (this.cancel) break;
            this.progress = (double)n2 / (double)n;
            ++n2;
            try {
                FilmBox filmBox = new FilmBox();
                IDisplayFormat iDisplayFormat = mapperFilmBox.getDisplayFormat();
                filmBox.setFilmBoxLayout(iDisplayFormat.getFilmBoxLayout());
                FilmBoxSheet filmBoxSheet = new FilmBoxSheet(filmBox, iDisplayFormat.getFilmSize(), iDisplayFormat.getFilmBoxResolution(), this.mfs.getZoomRatio(), iDisplayFormat.isRotated(), null, 0, 0);
                filmBoxSheet.layout();
                if (this.cancel) break;
                mapperFilmBox.prepareRendering(true);
                if (this.cancel) break;
                int n3 = 0;
                while (n3 < mapperFilmBox.imageBoxes().size()) {
                    MapperImageBox mapperImageBox = (MapperImageBox)mapperFilmBox.imageBoxes().get(n3);
                    ImageBox imageBox = (ImageBox)filmBox.imageBoxes().get(n3);
                    imageBox.setDicomObjectRenderer(mapperImageBox.getDicomObjectRenderer());
                    PresentationSizeMode presentationSizeMode = mapperImageBox.getPresentationSizeMode();
                    imageBox.setIncludeMappings(mapperImageBox.isIncludeMappings());
                    imageBox.setMappingsOutside(mapperImageBox.isMappingsOutside());
                    if (presentationSizeMode == PresentationSizeMode.ScaleToFit) {
                        imageBox.setImageFitting(ImageBox.ImageFitting.Scale);
                    } else if (presentationSizeMode == PresentationSizeMode.TrueSize) {
                        imageBox.setImageFitting(ImageBox.ImageFitting.Crop);
                    }
                    ++n3;
                }
                if (this.cancel) break;
                BufferedImage bufferedImage = filmBoxSheet.createPreview(true, this.printManagement.getRenderingHints(), this.printManagement.getResolution());
                if (this.cancel) break;
                this.previewImages.put(mapperFilmBox, bufferedImage);
                this.notifyProgressed(IPrintContext.Status.Succeded, mapperFilmBox);
            }
            catch (Exception exception) {
                ALogger.getLogger(PreviewPrintContext.class).error("Could not render preview", (Throwable)exception);
                this.notifyProgressed(IPrintContext.Status.Failed, mapperFilmBox);
            }
        }
        this.status = this.cancel ? IPrintContext.Status.Canceled : IPrintContext.Status.Finished;
        this.notifyFinished(this.status);
    }

    public BufferedImage getPreviewImage(MapperFilmBox mapperFilmBox) {
        return this.previewImages.get(mapperFilmBox);
    }
}

