/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared;

import org.apache.commons.io.output.ByteArrayOutputStream;

public class BitWriter {
    private int buf = 0;
    private int bitsInBuf = 0;
    private ByteArrayOutputStream os = new ByteArrayOutputStream();

    public final void writeBit(int n) {
        if (this.bitsInBuf == 8) {
            this.os.write(this.buf);
            this.buf = 0;
            this.bitsInBuf = 0;
        }
        this.buf >>= 1;
        this.buf |= n << 7;
        ++this.bitsInBuf;
    }

    public final void flush() {
        if (this.bitsInBuf == 0) {
            return;
        }
        this.os.write(this.buf >> 8 - this.bitsInBuf);
        this.buf = 0;
        this.bitsInBuf = 0;
    }

    public final void writeBit(int n, int n2) {
        if (n2 == 1) {
            this.writeBit(n);
            return;
        }
        if (8 - this.bitsInBuf >= n2) {
            int n3 = n == 0 ? 0 : (1 << n2) - 1;
            this.buf >>= n2;
            this.buf |= n3 << 8 - n2;
            this.bitsInBuf += n2;
            return;
        }
        int n4 = n == 0 ? 0 : 255;
        int n5 = 8 - this.bitsInBuf;
        this.buf >>= n5;
        this.buf = (this.buf | n4 << this.bitsInBuf) & 0xFF;
        this.os.write(this.buf);
        n2 -= n5;
        while (n2 >= 8) {
            this.os.write(n4);
            n2 -= 8;
        }
        if (n2 > 0) {
            this.buf = n4 << 8 - n2 & 0xFF;
        }
        this.bitsInBuf = n2;
    }

    public final void writeBits(byte[] byArray, int n) {
        if (this.bitsInBuf == 0) {
            int n2 = n >> 3;
            this.os.write(byArray, 0, n2);
            int n3 = n & 7;
            this.buf = byArray[n2 - 1] << 8 - n3;
            this.bitsInBuf = n3;
        } else {
            int n4;
            int n5 = 8 - this.bitsInBuf;
            int n6 = 0;
            while (n > n5) {
                n4 = byArray[n6];
                this.buf >>= n5;
                this.buf |= n4 << this.bitsInBuf;
                this.os.write(this.buf);
                this.buf = n4;
                ++n6;
                n -= 8;
            }
            if (n > 0) {
                n4 = byArray[n6];
                this.buf = n4 << 8 - n;
                this.bitsInBuf = n;
            }
        }
    }

    public final void writeBits(byte[] byArray, int n, int n2) {
        if (this.bitsInBuf == 0) {
            int n3 = n2 >> 3;
            this.os.write(byArray, n, n3);
            int n4 = n2 & 7;
            this.buf = byArray[n + n3 - 1] << 8 - n4;
            this.bitsInBuf = n4;
        } else {
            int n5;
            int n6 = 8 - this.bitsInBuf;
            int n7 = n;
            while (n2 > n6) {
                n5 = byArray[n7];
                this.buf >>= n6;
                this.buf |= n5 << this.bitsInBuf;
                this.os.write(this.buf);
                this.buf = n5;
                ++n7;
                n2 -= 8;
            }
            if (n2 > 0) {
                n5 = byArray[n7];
                this.buf = n5 << 8 - n2;
                this.bitsInBuf = n2;
            }
        }
    }

    public final byte[] toBytes() {
        this.flush();
        return this.os.toByteArray();
    }
}

