/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.certificate;

import com.agfa.pacs.logging.ALogger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.ArrayUtils;

public class CompositeX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> trustManagers;

    public CompositeX509TrustManager(List<TrustManager> list) {
        ArrayList<X509TrustManager> arrayList = new ArrayList<X509TrustManager>();
        for (TrustManager trustManager : list) {
            if (trustManager instanceof X509TrustManager) {
                arrayList.add((X509TrustManager)trustManager);
                continue;
            }
            ALogger.getLogger(CompositeX509TrustManager.class).warn("Unsupported Trustmanager");
        }
        this.trustManagers = Collections.unmodifiableList(arrayList);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                x509TrustManager.checkClientTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {}
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {}
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = null;
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            x509CertificateArray = x509CertificateArray == null ? (X509Certificate[])ArrayUtils.clone((Object[])x509TrustManager.getAcceptedIssuers()) : (X509Certificate[])ArrayUtils.addAll(x509CertificateArray, (Object[])x509TrustManager.getAcceptedIssuers());
        }
        if (x509CertificateArray == null) {
            return new X509Certificate[0];
        }
        return x509CertificateArray;
    }
}

