/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.certificate;

import com.agfa.pacs.data.shared.certificate.CompositeX509TrustManager;
import com.agfa.pacs.data.shared.certificate.ICertificateProvider;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

public class CompoundCertificateProvider
implements ICertificateProvider {
    private List<ICertificateProvider> certificateProviders;

    public CompoundCertificateProvider(List<ICertificateProvider> list) {
        this.certificateProviders = list;
    }

    public KeyManager getKeyManager() {
        List list = this.certificateProviders.stream().map(iCertificateProvider -> iCertificateProvider.getKeyManager()).filter(keyManager -> keyManager != null).collect(Collectors.toList());
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (KeyManager)list.get(0);
        }
        throw new UnsupportedOperationException("Multiple keymanagers not supported");
    }

    public TrustManager getTrustManager() {
        List<TrustManager> list = this.certificateProviders.stream().map(iCertificateProvider -> iCertificateProvider.getTrustManager()).collect(Collectors.toList());
        return new CompositeX509TrustManager(list);
    }

    public char[] getKeyPairPassword() {
        if (this.certificateProviders.isEmpty()) {
            return null;
        }
        return this.certificateProviders.get(0).getKeyPairPassword();
    }
}

