/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.code;

import com.agfa.pacs.data.shared.Messages;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CodeDictionary {
    private static final ALogger log = ALogger.getLogger(CodeDictionary.class);
    private static final Map<String, CodeDictionary> dictionaries = Collections.synchronizedMap(new HashMap());
    private String id;
    private String name;

    public static CodeDictionary getDictionary(String string) {
        return dictionaries.get(string);
    }

    public CodeDictionary(String string, String string2) {
        this.id = string;
        this.name = string2;
        dictionaries.put(string, this);
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static String getLocalizedCodeMeaning(Code code) {
        try {
            String string = Messages.getString("Code." + code.getCodingSchemeDesignator() + '.' + code.getCodeValue());
            if (string != null) {
                return string;
            }
        }
        catch (Exception exception) {}
        return code.getCodeMeaning();
    }

    protected static List<Code> codes(Class<? extends CodeDictionary> clazz) {
        Field[] fieldArray;
        ArrayList<Code> arrayList = new ArrayList<Code>();
        Field[] fieldArray2 = fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (field.getType() == Code.class) {
                try {
                    arrayList.add((Code)field.get(null));
                }
                catch (Exception exception) {
                    log.error("Error accessing object " + field.toString(), (Throwable)exception);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public static class AcquisitionModality
    extends CodeDictionary {
        public static final Code CardiacElectrophysiology = new Code("DCM", "EPS", "Cardiac Electrophysiology");
        public static final Code ComputedRadiography = new Code("DCM", "CR", "Computed Radiography");
        public static final Code ComputedTomography = new Code("DCM", "CT", "Computed Tomography");
        public static final Code DigitalRadiography = new Code("DCM", "DX", "Digital Radiography");
        public static final Code Diaphanography = new Code("DCM", "DG", "Diaphanography");
        public static final Code Electrocardiography = new Code("DCM", "ECG", "Electrocardiography");
        public static final Code Endoscopy = new Code("DCM", "ES", "Endoscopy");
        public static final Code ExternalCameraPhotography = new Code("DCM", "XC", "External-camera Photography");
        public static final Code GeneralMicroscopy = new Code("DCM", "GM", "General Microscopy");
        public static final Code HemodynamicWaveform = new Code("DCM", "HD", "Hemodynamic Waveform");
        public static final Code IntraOralRadiography = new Code("DCM", "IO", "Intra-oral Radiography");
        public static final Code IntravascularUltrasound = new Code("DCM", "IVUS", "Intravascular Ultrasound");
        public static final Code MagneticResonance = new Code("DCM", "MR", "Magnetic Resonance");
        public static final Code Mammography = new Code("DCM", "MG", "Mammography");
        public static final Code NuclearMedicine = new Code("DCM", "NM", "Nuclear Medcine");
        public static final Code OphthalmicPhotography = new Code("DCM", "OP", "OphthalmicPhotography");
        public static final Code PanoramicXRay = new Code("DCM", "PX", "Panoramic X-Ray");
        public static final Code PositronEmissionTomography = new Code("DCM", "PT", "Positron Emission Tomography");
        public static final Code Radiofluoroscopy = new Code("DCM", "RF", "Radiofluoroscopy");
        public static final Code RadiographicImaging = new Code("DCM", "RG", "Radiographic Imaging");
        public static final Code RadiotherapyImage = new Code("DCM", "RTIMAGE", "Radiotherapy Image");
        public static final Code SlideMicroscopy = new Code("DCM", "SM", "Slide Microscopy");
        public static final Code Ultrasound = new Code("DCM", "US", "Ultrasound");
        public static final Code XRayAngiography = new Code("DCM", "XA", "X-Ray Angiography");
        public static final Code Other = new Code("DCM", "OT", "Other");
        public static final Code BiomagneticImaging = new Code("DCM", "BI", "Biomagnetic Imaging");
        public static final Code KeyObjectSelection = new Code("DCM", "KO", "Key Object Selection");
        public static final Code StructuredReport = new Code("DCM", "SR", "SR Document");
        public static final Code PresentationState = new Code("DCM", "PR", "Presentation State");
        public static final Code StereometricRelationship = new Code("DCM", "SMR", "Stereometric Relationship");
        public static final Code Audio = new Code("DCM", "AU", "Audio");
        public static final Code Thermography = new Code("DCM", "TG", "Thermography");
        public static final Code LaserSurfaceScan = new Code("DCM", "LS", "Laser Surface Scan");
        public static final Code HardCopy = new Code("DCM", "HC", "Hard Copy");
        public static final Code RadiotherapyPlan = new Code("DCM", "RTPLAN", "Radiotherapy Plan");
        public static final Code RadiotherapyDose = new Code("DCM", "RTDOSE", "Radiotherapy Dose");
        public static final Code RadiotherapyTreatmentRecord = new Code("DCM", "RTRECORD", "Radiotherapy Treatment Record");
        public static final Code RadiotherapyStructureSet = new Code("DCM", "RTSTRUCT", "Radiotherapy Structure Set");
        public static final Code SecondaryCapture = new Code("DCM", "SC", "Secondary Capture");

        public AcquisitionModality() {
            super("29", "Acquisition Modality");
        }

        public static List<Code> codes() {
            return AcquisitionModality.codes(AcquisitionModality.class);
        }

        public static Code getCodeForValue(String string) {
            for (Code code : AcquisitionModality.codes()) {
                if (!code.getCodeValue().equals(string)) continue;
                return code;
            }
            return null;
        }
    }

    public static class AgfaAuditEventTypeCodes
    extends CodeDictionary {
        public static final Code IncludeSecondaryCapturesInAnonymizedExport = new Code("AGFA", "110101", "Include Secondary Captures in Anonymized Export");

        public AgfaAuditEventTypeCodes() {
            super("A1101", "Agfa Audit Event Type Codes");
        }

        public static List<Code> codes() {
            return AgfaAuditEventTypeCodes.codes(AgfaAuditEventTypeCodes.class);
        }
    }

    public static class BestInSet
    extends CodeDictionary {
        public static final Code Study = new Code("DCM", "113014", "Study");
        public static final Code Series = new Code("DCM", "113015", "Series");
        public static final Code PerformedProcedureStep = new Code("DCM", "113016", "Performed Procedure Step");
        public static final Code StageView = new Code("DCM", "113017", "Stage-View");

        public BestInSet() {
            super("7012", "Best In Set");
        }

        public static List<Code> codes() {
            return BestInSet.codes(BestInSet.class);
        }
    }

    public static class ContributingEquipmentPurposes
    extends CodeDictionary {
        public static final Code AcquisitionEquipment = new Code("DCM", "121311", "Acquisition equipment");
        public static final Code ProcessingEqipment = new Code("DCM", "121312", "Processing equipment");
        public static final Code ModifyingEquipment = new Code("DCM", "121313", "Modifying equipment");
        public static final Code PortableMediaImporterEquipment = new Code("DCM", "MEDIM", "Portable media importer equipment");
        public static final Code FilmDigitizerEquipment = new Code("DCM", "FILMD", "Film digitizer equipment");
        public static final Code DocumentDigitizerEquipment = new Code("DCM", "DOCD", "document digitizer equipment");
        public static final Code VideoTapeDigitizerEqipment = new Code("DCM", "VIDD", "video tape digitizer equipment");

        public ContributingEquipmentPurposes() {
            super("7005", "Contributing Equipment Purposes of Reference");
        }

        public static List<Code> codes() {
            return ContributingEquipmentPurposes.codes(ContributingEquipmentPurposes.class);
        }
    }

    public static class DefaultSRContent
    extends CodeDictionary {
        public static final Code ReasonForProcedure = new Code("DCM", "111401", "Reason for Procecure");
        public static final Code ProcedureStudyUID = new Code("DCM", "121018", "Procedure Study Instance UID");
        public static final Code ProcedureCode = new Code("DCM", "121023", "Procedure Code");
        public static final Code LanguageOfContentItemAndDescendants = new Code("DCM", "121049", "Language of content item and descendants");
        public static final Code History = new Code("DCM", "121060", "History");
        public static final Code Request = new Code("DCM", "121062", "Request");
        public static final Code CurrentProcedureDescriptions = new Code("DCM", "121064", "Current Procedure Descriptions");
        public static final Code ProcedureDescription = new Code("DCM", "121065", "Procedure Description");
        public static final Code PriorProcedureDescription = new Code("DCM", "121066", "Prior Procedure Descriptions");
        public static final Code PreviousFindings = new Code("DCM", "121068", "Previous Findings");
        public static final Code PreviousFinding = new Code("DCM", "121069", "Previous Finding");
        public static final Code Findings = new Code("DCM", "121070", "Findings");
        public static final Code Finding = new Code("DCM", "121071", "Finding");
        public static final Code Impressions = new Code("DCM", "121072", "Impressions");
        public static final Code Impression = new Code("DCM", "121073", "Impression");
        public static final Code Recommendations = new Code("DCM", "121074", "Recommendations");
        public static final Code Recommendation = new Code("DCM", "121075", "Recommendation");
        public static final Code Conclusions = new Code("DCM", "121076", "Conclusions");
        public static final Code Conclusion = new Code("DCM", "121077", "Conclusion");
        public static final Code Addendum = new Code("DCM", "121078", "Addendum");
        public static final Code IndicationsForProcedure = new Code("DCM", "121109", "Indications for Procedure");
        public static final Code PatientRepresentation = new Code("DCM", "121110", "Patient Representation");
        public static final Code Summary = new Code("DCM", "121111", "Summary");
        public static final Code Complications = new Code("DCM", "121114", "Complications");
        public static final Code ComplicationOfProcedure = new Code("SRT", "DD-60002", "Complication of Procedure");

        public DefaultSRContent() {
            super("DEFAULT_SR_CONTENT", "Default SR Content Codes");
        }

        public static List<Code> codes() {
            return DefaultSRContent.codes(DefaultSRContent.class);
        }

        public static Code getCodeForValue(String string) {
            for (Code code : DefaultSRContent.codes()) {
                if (!code.getCodeValue().equals(string)) continue;
                return code;
            }
            return null;
        }
    }

    public static class GeneralPurposeWorkitemDefinition
    extends CodeDictionary {
        public static final Code ImageProcessing = new Code("DCM", "110001", "Image Processing");
        public static final Code QualityControl = new Code("DCM", "110002", "Quality Control");
        public static final Code ComputerAidedDiagnosis = new Code("DCM", "110003", "Computer Aided Diagnosis");
        public static final Code ComputerAidedDetection = new Code("DCM", "110004", "Computer Aided Detection");
        public static final Code Interpretation = new Code("DCM", "110005", "Interpretation");
        public static final Code Transcription = new Code("DCM", "110006", "Transcription");
        public static final Code ReportVerification = new Code("DCM", "110007", "Report Verification");
        public static final Code Print = new Code("DCM", "110008", "Print");
        public static final Code NoSubsequentWorkitems = new Code("DCM", "110009", "No subsequent Workitems");
        public static final Code MediaImport = new Code("DCM", "110013", "Media Import");

        public GeneralPurposeWorkitemDefinition() {
            super("9231", "General Purpose Workitem Definition");
        }

        public static List<Code> codes() {
            return GeneralPurposeWorkitemDefinition.codes(GeneralPurposeWorkitemDefinition.class);
        }
    }

    public static class ImageDerivation
    extends CodeDictionary {
        public static final Code LossyCompression = new Code("DCM", "113040", "Lossy Compression");

        public ImageDerivation() {
            super("7203", "Image Derivation");
        }

        public static List<Code> codes() {
            return ImageDerivation.codes(ImageDerivation.class);
        }
    }

    public static class KeyObjectSelectionDocumentTitle
    extends CodeDictionary {
        public static final Code OfInterest = new Code("DCM", "113000", "Of Interest");
        public static final Code RejectedForQualityReasons = new Code("DCM", "113001", "Rejected for Quality Reasons");
        public static final Code ForReferringProvider = new Code("DCM", "113002", "For Referring Provider");
        public static final Code ForSurgery = new Code("DCM", "113003", "For Surgery");
        public static final Code ForTeaching = new Code("DCM", "113004", "For Teaching");
        public static final Code ForConference = new Code("DCM", "113005", "For Conference");
        public static final Code ForTherapy = new Code("DCM", "113006", "For Therapy");
        public static final Code ForPatient = new Code("DCM", "113007", "For Patient");
        public static final Code ForPeerReview = new Code("DCM", "113008", "For Peer Review");
        public static final Code ForResearch = new Code("DCM", "113009", "For Research");
        public static final Code QualityIssue = new Code("DCM", "113010", "Quality Issue");
        public static final Code BestInSet = new Code("DCM", "113013", "Best In Set");
        public static final Code ForPrinting = new Code("DCM", "113018", "For Printing");
        public static final Code ForReportAttachment = new Code("DCM", "113020", "For Report Attachment");
        public static final Code Manifest = new Code("DCM", "113030", "Manifest");
        public static final Code SignedManifest = new Code("DCM", "113031", "Signed Manifest");
        public static final Code CompleteStudyContent = new Code("DCM", "113032", "Complete Study Content");
        public static final Code SignedCompleteStudyContent = new Code("DCM", "113033", "Signed Complete Study Content");
        public static final Code CompleteAcquisitionContent = new Code("DCM", "113034", "Complete Acquisition Content");
        public static final Code SignedCompleteAcquisitionContent = new Code("DCM", "113035", "Signed Complete Acquisition Content");
        public static final Code JVisionSession = new Code("JVISION", "1103", "Session (Tiani)");
        public static final Code ForXDS = new Code("JVISION", "1200", "For XDS");

        public KeyObjectSelectionDocumentTitle() {
            super("7010", "Key Object Selection Document Title");
        }

        public static List<Code> codes() {
            return KeyObjectSelectionDocumentTitle.codes(KeyObjectSelectionDocumentTitle.class);
        }
    }

    public static class NonDicomOutputTypes
    extends CodeDictionary {
        public static final Code Film = new Code("DCM", "110010", "Film");
        public static final Code Dictation = new Code("DCM", "110011", "Dictation");
        public static final Code Transcription = new Code("DCM", "110012", "Transcription");

        public NonDicomOutputTypes() {
            super("9232", "Non-DICOM Output Types");
        }

        public static List<Code> codes() {
            return NonDicomOutputTypes.codes(NonDicomOutputTypes.class);
        }
    }

    public static class ProcedureDiscontinuationReasons
    extends CodeDictionary {
        public static final Code DoctorCanceledProcedure = new Code("DCM", "110500", "Doctor canceled procedure");
        public static final Code EquipmentFailure = new Code("DCM", "110501", "Equipment failure");
        public static final Code IncorrectProcedureOrdered = new Code("DCM", "110502", "Incorrect procedure ordered");
        public static final Code PatientAllergicToMediaContrast = new Code("DCM", "110503", "Patient allergic to media/contrast");
        public static final Code PatientDied = new Code("DCM", "110504", "Patient died");
        public static final Code PatientRefusedToContinueProcedure = new Code("DCM", "110505", "Patient refused  to continue procedure");
        public static final Code PatientTakenForTreatmentOrSurgery = new Code("DCM", "110506", "Patient taken for treatment or surgery");
        public static final Code PatientDidNotArrive = new Code("DCM", "110507", "Patient did not arrive");
        public static final Code PatientPregnant = new Code("DCM", "110508", "Patient pregnant");
        public static final Code ChangeOfProcedureForCorrectCharging = new Code("DCM", "110509", "Change of procedure for correct charging");
        public static final Code DuplicateOrder = new Code("DCM", "110510", "Duplicate order");
        public static final Code NursingUnitCancel = new Code("DCM", "110511", "Nursing unit cancel");
        public static final Code IncorrectSideOrdered = new Code("DCM", "110512", "Incorrect side ordered");
        public static final Code DiscontinuedForUnspecificReason = new Code("DCM", "110513", "Discontinued for unspecific reason");
        public static final Code IncorrectWorklistEntrySelected = new Code("DCM", "110514", "Incorrect worklist entry selected");
        public static final Code PatientConditionPreventedContinuing = new Code("DCM", "110515", "Patient condition prevented continuing");
        public static final Code EquipmentChange = new Code("DCM", "110516", "Equipment change");
        public static final Code ObjectsIncorrectlyFormatted = new Code("DCM", "110521", "Objects incorrectly formatted");
        public static final Code ObjectTypesNotSupported = new Code("DCM", "110522", "Object types not supported");
        public static final Code ObjectSetIncomplete = new Code("DCM", "110523", "Object set incomplete");
        public static final Code MediaFailure = new Code("DCM", "110524", "Media failure");

        public ProcedureDiscontinuationReasons() {
            super("9300", "Procedure Discontinuation Reasons");
        }

        public static List<Code> codes() {
            return ProcedureDiscontinuationReasons.codes(ProcedureDiscontinuationReasons.class);
        }
    }

    public static class ReferencedImagePurposes
    extends CodeDictionary {
        public static final Code Localizer = new Code("DCM", "121311", "Localizer");
        public static final Code BiopsyLocalizer = new Code("DCM", "121312", "Biopsy localizer");
        public static final Code OtherPartialViews = new Code("DCM", "121313", "Other partial views");
        public static final Code OtherImageOrBiplanePair = new Code("DCM", "121314", "Other image or biplane pair");
        public static final Code OtherImageOrStereoscopicPair = new Code("DCM", "121315", "Other image or stereoscopic pair");
        public static final Code ImageRelatedToStandaloneObject = new Code("DCM", "121316", "Image related to standalone object");
        public static final Code Spectroscopy = new Code("DCM", "121317", "Spectroscopy");

        public ReferencedImagePurposes() {
            super("7201", "Referenced Image Purposes of Reference");
        }

        public static List<Code> codes() {
            return ReferencedImagePurposes.codes(ReferencedImagePurposes.class);
        }
    }

    public static class RejectedForQualityReasons
    extends CodeDictionary {
        public static final Code ImageArtefacts = new Code("DCM", "111207", "Image artefact(s)");
        public static final Code GridArtefacts = new Code("DCM", "111208", "Grid artefact(s)");
        public static final Code Positioning = new Code("DCM", "111209", "Positioning");
        public static final Code MotionBlur = new Code("DCM", "111210", "Motion blur");
        public static final Code UnderExposed = new Code("DCM", "111211", "Under exposed");
        public static final Code OverExposed = new Code("DCM", "111212", "Over exposed");
        public static final Code NoImage = new Code("DCM", "111213", "No image");
        public static final Code DetectorArtefacts = new Code("DCM", "111214", "Detector artefact(s)");
        public static final Code OtherArtefacts = new Code("DCM", "111215", "Artefact(s) other than grid or detector artefact");
        public static final Code MechanicalFailure = new Code("DCM", "111216", "Mechanical failure");
        public static final Code ElectricalFailure = new Code("DCM", "111217", "Electrical failure");
        public static final Code SoftwareFailure = new Code("DCM", "111218", "Software failure");
        public static final Code InappropriateImageProcessing = new Code("DCM", "111219", "Inappropriate image processing");
        public static final Code OtherFailure = new Code("DCM", "111220", "Other failure");
        public static final Code UnknownFailure = new Code("DCM", "111221", "Unknown failure");
        public static final Code DoubleExposure = new Code("DCM", "113026", "Double exposure");

        public RejectedForQualityReasons() {
            super("7011", "Rejected For Quality Reasons");
        }

        public static List<Code> codes() {
            return RejectedForQualityReasons.codes(RejectedForQualityReasons.class);
        }
    }

    public static class SourceImagePurposes
    extends CodeDictionary {
        public static final Code UncompressedPredecessor = new Code("DCM", "121320", "Uncompressed predecessor");
        public static final Code MaskImageForImageProcessingOperation = new Code("DCM", "121321", "Mask image for image processing operation");
        public static final Code SourceImageForImageProcessingOperation = new Code("DCM", "121322", "Source image for image processing operation");
        public static final Code SourceImageForMontage = new Code("DCM", "121329", "Source image for montage");
        public static final Code LossyCompressedPredecessor = new Code("DCM", "121330", "Lossy compressed predecessor");

        public SourceImagePurposes() {
            super("7202", "Source Image Purposes of Reference");
        }

        public static List<Code> codes() {
            return SourceImagePurposes.codes(SourceImagePurposes.class);
        }
    }

    public static class TianiKeyObjectSelectionDocumentTitle
    extends CodeDictionary {
        public static final Code OfInterest = new Code("999TIANI", "113000", "Of Interest (Tiani)");
        public static final Code ForPrinting = new Code("999TIANI", "990001", "For Printing (Tiani)");
        public static final Code ForPrinting2 = new Code("999TIANI", "113018", "For Printing (Tiani)");
        public static final Code ForConference = new Code("999TIANI", "113005", "For Conference (Tiani)");
        public static final Code SequenceGroup = new Code("TIANI", "1001", "Sequence Group (Tiani)");
        public static final Code Session = new Code("JVISION", "1103", "Session (Tiani)");

        public TianiKeyObjectSelectionDocumentTitle() {
            super("T7010", "Tiani Key Object Selection Document Title");
        }

        public static List<Code> codes() {
            return TianiKeyObjectSelectionDocumentTitle.codes(TianiKeyObjectSelectionDocumentTitle.class);
        }
    }

    public static class YesNo
    extends CodeDictionary {
        public static final Code Yes = new Code("SRT", "R-0038D", "Yes");
        public static final Code No = new Code("SRT", "R-00339D", "No");
        public static final Code Undetermined = new Code("SRT", "R-0038A", "Undetermined");

        public YesNo() {
            super("230", "Yes-No");
        }

        public static List<Code> codes() {
            return YesNo.codes(YesNo.class);
        }
    }
}

