/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.code;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.dcm4che3.data.Attributes;

public class MammoCode {
    private static final ALogger LOGGER = ALogger.getLogger(MammoCode.class);
    public static final String MAMMO_DESIGNATOR = "SNM3";
    public static final String DEFAULT_DESIGNATOR = "SRT";
    private final Code[] codes;
    private final String viewCode;
    public static final MammoCode MedioLateral = new MammoCode("R-10224", "medio-lateral", "ML");
    public static final MammoCode MedioLateralOblique = new MammoCode("R-10226", "medio-lateral oblique", "MLO");
    public static final MammoCode LateralMedial = new MammoCode("R-10228", "latero-medial", "LM");
    public static final MammoCode LateralMedialOblique = new MammoCode("R-10230", "latero-medial oblique", "LMO");
    public static final MammoCode CranioCaudal = new MammoCode("R-10242", "cranio-caudal", "CC");
    public static final MammoCode CranioCaudalFromBelow = new MammoCode("R-10244", "caudo-cranial (from below)", "FB");
    public static final MammoCode SuperoLateralToInferomedialOblique = new MammoCode("R-102D0", "superolateral to inferomedial oblique", "SIO");
    public static final MammoCode InferomedialToSuperolateralOblique = new MammoCode("R-40AAA", "inferomedial to superolateral oblique", "ISO");
    public static final MammoCode CranioCaudalExaggeratedLaterally = new MammoCode("R-1024A", "cranio-caudal exaggerated laterally", "XCCL");
    public static final MammoCode CranioCaudalExaggeratedMedially = new MammoCode("R-1024B", "cranio-caudal exaggerated medially", "XCCM");
    public static final MammoCode CranioCaudalExaggeratedRetired = new MammoCode("R-102CF", "cranio-caudal exaggerated", "XCC");
    public static final MammoCode CranioCaudalExaggeratedLaterallyRetired = new MammoCode("Y-X1770", "cranio-caudal exaggerated laterally", "XCCL");
    public static final MammoCode CranioCaudalExaggeratedMediallyRetired = new MammoCode("Y-X1771", "cranio-caudal exaggerated medially", "XCCM");
    private static final List<MammoCode> MAMMO_CODES = Collections.unmodifiableList(MammoCode.initMammoCodes());

    MammoCode(String string, String string2, String string3) {
        this.codes = MammoCode.createMammoCodes(string, string2);
        this.viewCode = string3;
    }

    public String getViewCode() {
        return this.viewCode;
    }

    public String getCodeValue() {
        return this.codes[0].getCodeValue();
    }

    private static Code[] createMammoCodes(String string, String string2) {
        return new Code[]{new Code(MAMMO_DESIGNATOR, string, string2), new Code(DEFAULT_DESIGNATOR, string, string2)};
    }

    private static List<MammoCode> initMammoCodes() {
        Field[] fieldArray;
        ArrayList<MammoCode> arrayList = new ArrayList<MammoCode>();
        Field[] fieldArray2 = fieldArray = MammoCode.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (field.getType() == MammoCode.class) {
                try {
                    arrayList.add((MammoCode)field.get(null));
                }
                catch (Exception exception) {
                    LOGGER.error("Error accessing object: " + field, (Throwable)exception);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public static MammoCode getMammoCode(Attributes attributes) {
        Code code = Code.create((Attributes)attributes, (int)5505568);
        if (code != null) {
            for (MammoCode mammoCode : MAMMO_CODES) {
                if (!mammoCode.isEquivalent(code)) continue;
                return mammoCode;
            }
        }
        return null;
    }

    public static Iterable<MammoCode> getMammoCodes() {
        return MAMMO_CODES;
    }

    boolean isEquivalent(Code code) {
        return ArrayUtils.contains((Object[])this.codes, (Object)code);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        MammoCode mammoCode = (MammoCode)object;
        return Objects.equals(this.getCodeValue(), mammoCode.getCodeValue());
    }

    public int hashCode() {
        return this.getCodeValue().hashCode();
    }
}

