/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.code;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.MammoCode;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class MammoViewModifier {
    private static final ALogger LOGGER = ALogger.getLogger(MammoViewModifier.class);
    private final MammoCode mammoCode;
    private final ViewCodeLocation viewCodeLocation;
    public static final MammoViewModifier Cleavage = new MammoViewModifier("R-102D2", "Cleavage", "CV", ViewCodeLocation.REPLACEMENT);
    public static final MammoViewModifier AxillaryTail = new MammoViewModifier("R-102D1", "Axillary Tail", "AT", ViewCodeLocation.REPLACEMENT);
    public static final MammoViewModifier RolledLateral = new MammoViewModifier("R-102D3", "Rolled Lateral", "RL", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier RolledMedial = new MammoViewModifier("R-102D4", "Rolled Medial", "RM", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier RolledInferior = new MammoViewModifier("R-102CA", "Rolled Inferior", "RI", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier RolledSuperior = new MammoViewModifier("R-102C9", "Rolled Superior", "RS", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier ImplantDisplaced = new MammoViewModifier("R-102D5", "Implant Displaced", "ID", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier Magnification = new MammoViewModifier("R-102D6", "Magnification", "M", ViewCodeLocation.PREFIX);
    public static final MammoViewModifier SpotCompression = new MammoViewModifier("R-102D7", "Spot Compression", "S", ViewCodeLocation.PREFIX);
    public static final MammoViewModifier Tangential = new MammoViewModifier("R-102C2", "Tangential", "TAN", ViewCodeLocation.REPLACEMENT);
    public static final MammoViewModifier NippleInProfile = new MammoViewModifier("R-40AB3", "Nipple in profile", "NP", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier AnteriorCompression = new MammoViewModifier("P2-00161", "Anterior compression", "AC", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier InfraMammaryFold = new MammoViewModifier("R-40ABE", "Infra-mammary fold", "IMF", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier AxillaryTissue = new MammoViewModifier("R-40AB2", "Axillary tissue", "AX", ViewCodeLocation.SUFFIX);
    private static final Map<String, MammoViewModifier> mapOfViewCodeToModifiers = new HashMap<String, MammoViewModifier>();
    private static final List<MammoViewModifier> codes = Collections.unmodifiableList(MammoViewModifier.initViewModifiers());

    private MammoViewModifier(String string, String string2, String string3, ViewCodeLocation viewCodeLocation) {
        this.mammoCode = new MammoCode(string, string2, string3);
        this.viewCodeLocation = viewCodeLocation;
    }

    public ViewCodeLocation getViewCodeLocation() {
        return this.viewCodeLocation;
    }

    public String getCodeValue() {
        return this.mammoCode.getCodeValue();
    }

    public MammoCode getMammoCode() {
        return this.mammoCode;
    }

    private static List<MammoViewModifier> initViewModifiers() {
        Field[] fieldArray;
        ArrayList<MammoViewModifier> arrayList = new ArrayList<MammoViewModifier>();
        Field[] fieldArray2 = fieldArray = MammoViewModifier.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (field.getType() == MammoViewModifier.class) {
                try {
                    MammoViewModifier mammoViewModifier = (MammoViewModifier)field.get(null);
                    mapOfViewCodeToModifiers.put(mammoViewModifier.getMammoCode().getViewCode(), mammoViewModifier);
                    arrayList.add(mammoViewModifier);
                }
                catch (Exception exception) {
                    LOGGER.error("Error accessing object: " + field, (Throwable)exception);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private static List<Code> getViewModifierCodes(Attributes attributes) {
        List list = null;
        Sequence sequence = attributes.getSequence(5505568);
        if (sequence != null && !sequence.isEmpty()) {
            list = Code.createList((Attributes)((Attributes)sequence.get(0)), (int)5505570);
        }
        if (list == null || list.isEmpty()) {
            list = Code.createList((Attributes)attributes, (int)5505570);
        }
        return list;
    }

    public static List<MammoViewModifier> getViewModifiers(Attributes attributes) {
        List<Code> list = MammoViewModifier.getViewModifierCodes(attributes);
        ArrayList<MammoViewModifier> arrayList = new ArrayList<MammoViewModifier>(list.size());
        for (Code code : list) {
            for (MammoViewModifier mammoViewModifier : codes) {
                if (!mammoViewModifier.mammoCode.isEquivalent(code)) continue;
                arrayList.add(mammoViewModifier);
            }
        }
        return arrayList;
    }

    public static Iterable<MammoViewModifier> getViewModifiers() {
        return codes;
    }

    public static MammoViewModifier getModifierForCodeValue(String string) {
        return mapOfViewCodeToModifiers.get(string);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        MammoViewModifier mammoViewModifier = (MammoViewModifier)object;
        return Objects.equals(this.mammoCode, mammoViewModifier.mammoCode);
    }

    public int hashCode() {
        return this.mammoCode.hashCode();
    }

    public static enum ViewCodeLocation {
        PREFIX,
        SUFFIX,
        REPLACEMENT;

    }
}

