/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.WaitDicomDataListenerAdapter;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.util.Waitable;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public abstract class AbstractWaitDicom
implements Waitable {
    protected static final ALogger LOGGER = ALogger.getLogger(WaitDicomDataListenerAdapter.class);
    protected final List<Waitable> waitables = new ArrayList<Waitable>();

    public synchronized IDicomDataListener addListener(IDicomDataListener iDicomDataListener) {
        AbstractDicomWaiter abstractDicomWaiter = this.createWaitable(iDicomDataListener);
        this.waitables.add(abstractDicomWaiter);
        return abstractDicomWaiter;
    }

    protected abstract AbstractDicomWaiter createWaitable(IDicomDataListener var1);

    @Override
    public synchronized void waitUntilFinished() {
        for (Waitable waitable : this.waitables) {
            waitable.waitUntilFinished();
        }
    }

    protected static abstract class AbstractDicomWaiter
    implements IDicomDataListener,
    Waitable {
        protected boolean finished;
        protected final IDicomDataListener listener;

        public AbstractDicomWaiter(IDicomDataListener iDicomDataListener) {
            this.listener = iDicomDataListener;
            this.finished = false;
        }

        @Override
        public synchronized void dicomDataError(String string, String string2, Throwable throwable) {
            this.listener.dicomDataError(string, string2, throwable);
            this.finished = true;
            this.notifyAll();
        }

        @Override
        public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
            this.listener.pixelDataAvailable(string, iPixelDataInfo, n);
        }

        @Override
        public void pixelDataError(String string, int n, String string2, Throwable throwable) {
            this.listener.pixelDataError(string, n, string2, throwable);
        }

        @Override
        public void postPixelDicomDataAvailable(String string, Attributes attributes) {
            this.listener.postPixelDicomDataAvailable(string, attributes);
        }

        @Override
        public synchronized void waitUntilFinished() {
            while (!this.finished) {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warn("Waiting for DICOM data interrupted.", (Throwable)interruptedException);
                    continue;
                }
                break;
            }
            return;
        }
    }
}

