/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.data.shared.dicom.AgfaDicomInputStream;
import com.agfa.pacs.logging.ALogger;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.SafeClose;

public class DicomObjectReader {
    private static final ALogger log = ALogger.getLogger(DicomObjectReader.class);

    public static Attributes readDicomObject(ByteArrayContainer byteArrayContainer) {
        AgfaDicomInputStream agfaDicomInputStream = null;
        try {
            String string = null;
            ByteArrayInputStream byteArrayInputStream = null;
            byte[] byArray = byteArrayContainer.getData();
            int n = byteArrayContainer.getDataLength();
            if (byArray[n - 1] == 66 && byArray[n - 2] == 7) {
                int n2 = byArray[n - 3];
                byte[] byArray2 = new byte[n2];
                int n3 = n - n2 - 3;
                int n4 = 0;
                while (n4 < n2) {
                    byArray2[n4] = byArray[n3 + n4];
                    ++n4;
                }
                string = new String(byArray2);
                byteArrayInputStream = new ByteArrayInputStream(byArray, byteArrayContainer.getOffset(), n - n2 - 3);
            } else {
                byteArrayInputStream = new ByteArrayInputStream(byArray, byteArrayContainer.getOffset(), n);
            }
            agfaDicomInputStream = string == null ? new AgfaDicomInputStream(byteArrayInputStream) : new AgfaDicomInputStream(byteArrayInputStream, string);
            Attributes attributes = agfaDicomInputStream.readDataset(-1, -1);
            if (string != null) {
                attributes.setString(131088, VR.UI, string);
            } else if (agfaDicomInputStream.getFileMetaInformation() != null) {
                attributes.setString(131088, VR.UI, agfaDicomInputStream.getFileMetaInformation().getString(131088));
            }
            Attributes attributes2 = attributes;
            SafeClose.close((Closeable)((Object)agfaDicomInputStream));
            return attributes2;
        }
        catch (IOException iOException) {
            log.error("Could not parse dicom object", (Throwable)iOException);
            return null;
        }
        finally {
            SafeClose.close(agfaDicomInputStream);
        }
    }
}

