/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.cache.ByteArrayContainer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class GrowableBufferedInputStream
extends FilterInputStream {
    private static final int defaultBufferSize = 65536;
    private static final int minimalBufferSize = 8192;
    protected volatile byte[] buf = new byte[65536];
    private static final AtomicReferenceFieldUpdater<GrowableBufferedInputStream, byte[]> bufUpdater = AtomicReferenceFieldUpdater.newUpdater(GrowableBufferedInputStream.class, byte[].class, "buf");
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;
    private boolean bufferingMode = true;

    private InputStream getInIfOpen() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream == null) {
            throw new IOException("Stream closed");
        }
        return inputStream;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] byArray = this.buf;
        if (byArray == null) {
            throw new IOException("Stream closed");
        }
        return byArray;
    }

    public GrowableBufferedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private void fill() throws IOException {
        int n;
        byte[] byArray = this.getBufIfOpen();
        if (this.markpos < 0 && !this.bufferingMode) {
            this.pos = 0;
        } else if (this.pos >= byArray.length) {
            if (this.markpos > 0 && !this.bufferingMode) {
                n = this.pos - this.markpos;
                System.arraycopy(byArray, this.markpos, byArray, 0, n);
                this.pos = n;
                this.markpos = 0;
            } else if (byArray.length >= this.marklimit && !this.bufferingMode) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                n = this.pos * 2;
                if (!this.bufferingMode && n > this.marklimit) {
                    n = this.marklimit;
                }
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, this.pos);
                if (!bufUpdater.compareAndSet(this, byArray, byArray2)) {
                    throw new IOException("Stream closed");
                }
                byArray = byArray2;
            }
        }
        this.count = this.pos;
        n = this.getInIfOpen().read(byArray, this.pos, byArray.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    public synchronized ByteArrayContainer getCurrentBuffer(boolean bl, boolean bl2) {
        this.bufferingMode = false;
        int n = this.pos;
        if (bl) {
            while (true) {
                if (bl2) {
                    if (this.buf[n - 1] == 127 && this.buf[n] == -32) {
                        --n;
                        break;
                    }
                } else if (this.buf[n - 1] == -32 && this.buf[n] == 127) {
                    --n;
                    break;
                }
                --n;
            }
        }
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer(this.buf, 0, n);
        int n2 = 8192 > this.count - this.pos ? 8192 : this.count - this.pos;
        byte[] byArray = new byte[n2];
        if (this.count - this.pos > 0) {
            System.arraycopy(this.buf, this.pos, byArray, 0, this.count - this.pos);
        }
        this.count -= this.pos;
        this.pos = 0;
        this.marklimit = 0;
        this.markpos = -1;
        this.buf = byArray;
        return byteArrayContainer;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            if (!this.bufferingMode && n2 >= this.getBufIfOpen().length && this.markpos < 0) {
                return this.getInIfOpen().read(byArray, n, n2);
            }
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.getBufIfOpen(), this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream;
        this.getBufIfOpen();
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        do {
            int n4;
            if ((n4 = this.read1(byArray, n + n3, n2 - n3)) <= 0) {
                return n3 == 0 ? n4 : n3;
            }
            if ((n3 += n4) < n2) continue;
            return n3;
        } while ((inputStream = this.in) == null || inputStream.available() > 0);
        return n3;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        this.getBufIfOpen();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.count - this.pos;
        if (l2 <= 0L) {
            if (this.markpos < 0) {
                return this.getInIfOpen().skip(l);
            }
            this.fill();
            l2 = this.count - this.pos;
            if (l2 <= 0L) {
                return 0L;
            }
        }
        long l3 = l2 < l ? l2 : l;
        this.pos = (int)((long)this.pos + l3);
        return l3;
    }

    @Override
    public synchronized int available() throws IOException {
        return this.getInIfOpen().available() + (this.count - this.pos);
    }

    @Override
    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getBufIfOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    @Override
    public void close() throws IOException {
        block5: {
            byte[] byArray;
            block4: {
                if (!true) break block4;
                byArray = this.buf;
                if (this.buf == null) break block5;
            }
            do {
                if (bufUpdater.compareAndSet(this, byArray, null)) {
                    InputStream inputStream = this.in;
                    this.in = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    return;
                }
                byArray = this.buf;
            } while (this.buf != null);
        }
    }
}

