/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.pixel.DatasetImagePixel;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataReader;
import com.agfa.pacs.data.shared.pixel.encoder.PixelDataEncoderFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomOutputStream;

public class OutputStreamDicomDataWriter
implements IDicomDataListener {
    private static final ALogger log = ALogger.getLogger(OutputStreamDicomDataWriter.class);
    private DicomOutputStream dicomOutputStream;
    private boolean pixelsStarted;
    private boolean encapsulated;
    private int numberOfFrames;
    private int pixelDataLength;
    private final boolean writeMetaInfo;
    private final OutputStream outputStream;
    private int bitsStored;
    private String transferSyntaxUID;

    public OutputStreamDicomDataWriter(OutputStream outputStream, boolean bl) {
        this.outputStream = outputStream;
        this.writeMetaInfo = bl;
        this.pixelsStarted = false;
        this.numberOfFrames = 0;
    }

    public void setTransferSyntaxUID(String string) {
        this.transferSyntaxUID = string;
    }

    @Override
    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        try {
            if (this.transferSyntaxUID == null) {
                this.transferSyntaxUID = attributes.getString(131088);
                if (this.transferSyntaxUID == null) {
                    this.transferSyntaxUID = "1.2.840.10008.1.2.1";
                }
            }
            this.removeFileMetaInformation(attributes);
            if (this.writeMetaInfo) {
                this.dicomOutputStream = new DicomOutputStream(this.outputStream, "1.2.840.10008.1.2.1");
                this.dicomOutputStream.writeFileMetaInformation(attributes.createFileMetaInformation(this.transferSyntaxUID));
            } else {
                this.dicomOutputStream = new DicomOutputStream(this.outputStream, this.transferSyntaxUID);
            }
            this.dicomOutputStream.writeDataset(null, attributes);
            this.encapsulated = UIDUtilities.isTransferSyntaxType(this.transferSyntaxUID, UIDType.Encapsulated);
            this.bitsStored = attributes.getInt(2621697, 0);
            if (bl) {
                int n;
                this.numberOfFrames = 1;
                if (attributes.contains(0x280008) && (n = attributes.getInt(0x280008, 0)) > 1) {
                    this.numberOfFrames = n;
                }
            }
        }
        catch (IOException iOException) {
            log.error("DicomDataAvailable", (Throwable)iOException);
        }
    }

    @Override
    public void postPixelDicomDataAvailable(String string, Attributes attributes) {
    }

    private void removeFileMetaInformation(Attributes attributes) {
        attributes.remove(131072);
        attributes.remove(131073);
        attributes.remove(131074);
        attributes.remove(131075);
        attributes.remove(131088);
        attributes.remove(131090);
        attributes.remove(131091);
        attributes.remove(131094);
        attributes.remove(131328);
        attributes.remove(131330);
    }

    public void streamEncapsulatedPixelData(InputStream inputStream, int n) {
        if (this.pixelsStarted || !this.encapsulated) {
            throw new IllegalStateException();
        }
        try {
            this.dicomOutputStream.writeHeader(2145386512, VR.OB, -1);
            this.dicomOutputStream.writeHeader(-73728, null, 0);
            this.pixelsStarted = true;
            this.dicomOutputStream.writeHeader(-73728, null, n + 1 & 0xFFFFFFFE);
            StreamUtil.copyStream((InputStream)inputStream, (OutputStream)this.dicomOutputStream);
            if ((n & 1) != 0) {
                this.dicomOutputStream.write(0);
            }
        }
        catch (Exception exception) {
            log.error("PixelDataAvailable", (Throwable)exception);
        }
    }

    @Override
    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        block18: {
            PixelDataReader pixelDataReader = new PixelDataReader(iPixelDataInfo);
            ByteArrayContainer byteArrayContainer = null;
            try {
                Object object;
                Object object2 = pixelDataReader.getData();
                if (object2 instanceof ByteArrayContainer) {
                    byteArrayContainer = (ByteArrayContainer)object2;
                } else {
                    object = PixelDataEncoderFactory.getInstance().createPixelDataEncoder(this.transferSyntaxUID);
                    byteArrayContainer = new ByteArrayContainer(object.encode(new DatasetImagePixel(iPixelDataInfo.getDescription()), object2));
                }
                if (this.numberOfFrames <= 0) {
                    return;
                }
                try {
                    if (!this.pixelsStarted) {
                        if (this.encapsulated) {
                            this.dicomOutputStream.writeHeader(2145386512, VR.OB, -1);
                            this.dicomOutputStream.writeHeader(-73728, null, 0);
                        } else {
                            this.pixelDataLength = this.bitsStored == 1 && "1.2.840.10008.5.1.4.1.1.66.4".equals(iPixelDataInfo.getDescription().getString(524310)) ? byteArrayContainer.getDataLength() : this.numberOfFrames * byteArrayContainer.getDataLength();
                            if (this.bitsStored > 8) {
                                this.dicomOutputStream.writeHeader(2145386512, VR.OW, this.pixelDataLength + 1 & 0xFFFFFFFE);
                            } else {
                                this.dicomOutputStream.writeHeader(2145386512, VR.OB, this.pixelDataLength + 1 & 0xFFFFFFFE);
                            }
                        }
                        this.pixelsStarted = true;
                    }
                    if (this.encapsulated) {
                        this.dicomOutputStream.writeHeader(-73728, null, byteArrayContainer.getDataLength() + 1 & 0xFFFFFFFE);
                        this.dicomOutputStream.write(byteArrayContainer.getData(), byteArrayContainer.getOffset(), byteArrayContainer.getDataLength());
                        if ((byteArrayContainer.getDataLength() & 1) != 0) {
                            this.dicomOutputStream.write(0);
                        }
                        break block18;
                    }
                    if (iPixelDataInfo.getDescription().bigEndian() && this.bitsStored > 8) {
                        object = new byte[byteArrayContainer.getDataLength()];
                        System.arraycopy(byteArrayContainer.getData(), byteArrayContainer.getOffset(), object, 0, byteArrayContainer.getDataLength());
                        OutputStreamDicomDataWriter.swapByteArray((byte[])object);
                        this.dicomOutputStream.write((byte[])object);
                        break block18;
                    }
                    this.dicomOutputStream.write(byteArrayContainer.getData(), byteArrayContainer.getOffset(), byteArrayContainer.getDataLength());
                }
                catch (Exception exception) {
                    log.error("PixelDataAvailable", (Throwable)exception);
                }
            }
            finally {
                if (byteArrayContainer != null) {
                    pixelDataReader.releaseData();
                }
                byteArrayContainer = null;
            }
        }
    }

    @Override
    public void pixelDataError(String string, int n, String string2, Throwable throwable) {
        log.error("pixelDataError", throwable);
    }

    private static void swapByteArray(byte[] byArray) {
        if (byArray.length % 2 == 1) {
            throw new IllegalArgumentException("OW with uneven bytes");
        }
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n + 1];
            byArray[n + 1] = byArray[n];
            byArray[n] = by;
            n += 2;
        }
    }

    @Override
    public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        try {
            if (this.pixelsStarted) {
                if (this.encapsulated) {
                    this.dicomOutputStream.writeHeader(-73507, null, 0);
                } else if ((this.pixelDataLength & 1) != 0) {
                    this.dicomOutputStream.write(0);
                }
            }
            if (attributes != null) {
                this.dicomOutputStream.writeDataset(null, attributes);
            }
            this.dicomOutputStream.flush();
        }
        catch (IOException iOException) {
            log.error("DicomDataFinished", (Throwable)iOException);
        }
    }

    @Override
    public void dicomDataError(String string, String string2, Throwable throwable) {
        log.error("Dicom Data Error", throwable);
    }
}

