/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.data.shared.data.AbstractWaitDicom;
import com.agfa.pacs.data.shared.data.ErrorCollector;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import org.dcm4che3.data.Attributes;

public class WaitDicomDataAvailable
extends AbstractWaitDicom {
    protected final ErrorCollector errorCollector;

    public WaitDicomDataAvailable(ErrorCollector.ErrorAcceptor errorAcceptor) {
        this.errorCollector = new ErrorCollector(errorAcceptor);
    }

    @Override
    public AbstractWaitDicom.AbstractDicomWaiter createWaitable(IDicomDataListener iDicomDataListener) {
        return new DicomDataAvailableWaiter(iDicomDataListener, this.errorCollector);
    }

    public boolean hasErrors() {
        return this.errorCollector.getNumberOfErrors() > 0;
    }

    private static class DicomDataAvailableWaiter
    extends AbstractWaitDicom.AbstractDicomWaiter {
        private final ErrorCollector errorCollector;

        private DicomDataAvailableWaiter(IDicomDataListener iDicomDataListener, ErrorCollector errorCollector) {
            super(iDicomDataListener);
            this.errorCollector = errorCollector;
        }

        @Override
        public synchronized void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
            this.listener.dicomDataAvailable(string, attributes, bl);
            this.finished = true;
            this.notifyAll();
        }

        @Override
        public synchronized void dicomDataError(String string, String string2, Throwable throwable) {
            this.errorCollector.reportError(string2, throwable);
            super.dicomDataError(string, string2, throwable);
        }

        @Override
        public void pixelDataError(String string, int n, String string2, Throwable throwable) {
            this.errorCollector.reportError(string2, throwable);
            super.pixelDataError(string, n, string2, throwable);
        }

        @Override
        public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
            this.listener.dicomDataFinished(string, status, attributes);
        }
    }
}

