/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data.cache;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;

public abstract class DicomCacheFactory {
    private static DicomCacheFactory implementation;

    protected DicomCacheFactory() {
    }

    public static synchronized DicomCacheFactory getInstance() {
        if (implementation == null) {
            DicomCacheFactory.initialize();
        }
        return implementation;
    }

    public IDicomCache getDicomCache() {
        return implementation.getDicomCacheInt();
    }

    protected abstract IDicomCache getDicomCacheInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)DicomCacheFactory.class.getName()));
            implementation = (DicomCacheFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + DicomCacheFactory.class.getName(), reflectiveOperationException);
        }
    }
}

