/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data.cache;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.tools.IDisposable;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public interface IDicomCache {
    public static final String EXT_PT = "com.agfa.pacs.data.shared.DicomCache";
    public static final String DICOM_OBJECT_PREFIX = "D";
    public static final byte MAGIC1 = 7;
    public static final byte MAGIC2 = 66;
    public static final char PIXELDATA_FRAME_SEPARATOR = 'F';

    public boolean hasInstance(String var1, String var2, int var3);

    public boolean hasInstance(String var1, String var2);

    public boolean hasInstanceAndFrame(String var1, String var2, int var3);

    public boolean hasDataset(String var1, String var2);

    public Attributes getDataset(String var1, String var2);

    public Attributes getDataset(CacheID var1);

    public void removeInstance(String var1, String var2, int var3);

    public void removeDataset(String var1, String var2);

    public IPixelDataInfo getPixelDataInfo(String var1, String var2, int var3, Attributes var4);

    public IPixelDataInfo getPixelDataInfo(String var1, String var2, int var3, Attributes var4, String var5);

    public void putDataset(String var1, String var2, ByteArrayContainer var3, String var4);

    public Date getCacheTimestamp(String var1);

    public void putDataset(String var1, String var2, Attributes var3);

    public CacheID putPixelDataInfo(String var1, String var2, int var3, ByteArrayContainer var4);

    public IPixelDataInfo registerPixelData(String var1, int var2, IPixelDataInfo var3);

    public boolean cachesMetadata();

    public void registerStudyUsage(String var1, IDisposable var2);

    public void unregisterStudyUsage(String var1, IDisposable var2);

    public void registerStudyUsage(Map<String, WeakReference<IDisposable>> var1);

    public void unregisterStudyUsage(Map<String, WeakReference<IDisposable>> var1);

    public StudyState getCachingState(String var1);

    public void setCachingState(String var1, StudyState var2);

    public void setStudySizeEstimate(String var1, int var2);

    public void flushStudy(String var1);

    public static enum StudyState {
        COMPLETE(1.0),
        LIGHTWEIGHT_COMPLETE(0.5),
        PARTIAL(0.5),
        NOT(0.0);

        private final double percentage;

        private StudyState(double d) {
            this.percentage = d;
        }

        public double getPercentage() {
            return this.percentage;
        }
    }
}

