/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.dicom;

import java.io.IOException;
import java.io.InputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.TagUtils;

public class AgfaDicomInputStream
extends DicomInputStream {
    private VR origVR = null;

    public AgfaDicomInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public AgfaDicomInputStream(InputStream inputStream, String string) throws IOException {
        super(inputStream, string);
    }

    private VR getVR() {
        VR vR = this.vr();
        if (this.tag() == 0x240024) {
            return this.origVR;
        }
        return vR;
    }

    public void readValue(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
        int n = this.length();
        VR vR = this.getVR();
        if (vR == VR.SQ || n <= -1) {
            super.readValue(dicomInputStream, attributes);
        } else {
            int n2 = this.tag();
            byte[] byArray = this.readValue();
            if (!TagUtils.isGroupLength((int)n2)) {
                boolean bl = this.bigEndian();
                if (bl != attributes.bigEndian()) {
                    vR.toggleEndian(byArray, false);
                }
                attributes.setBytes(n2, vR, byArray);
            } else if (n2 == 131072) {
                this.setFileMetaInformationGroupLength(byArray);
            }
        }
    }

    public int readHeader() throws IOException {
        int n = super.readHeader();
        this.origVR = this.vr();
        return n;
    }
}

