/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.dicom;

import com.agfa.pacs.data.shared.IPatientHierarchy;
import com.agfa.pacs.data.shared.Messages;
import com.agfa.pacs.data.shared.dicom.DicomEnum;

public enum Level implements DicomEnum,
IPatientHierarchy
{
    Patient("PATIENT"),
    Study("STUDY"),
    Series("SERIES"),
    Object("OBJECT");

    private final String dicomId;
    private final String infoName;
    private final String TO_STRING_KEY = "Level." + this.name();

    private Level(String string2) {
        this.dicomId = string2;
        this.infoName = String.valueOf(this.name()) + "Info";
    }

    public String dicom() {
        return this.dicomId;
    }

    @Override
    public int getLevel() {
        return this.ordinal();
    }

    public static Level get(String string) {
        Level[] levelArray = Level.values();
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            if (level.dicom().equals(string)) {
                return level;
            }
            ++n2;
        }
        return null;
    }

    public static Level get(int n) {
        Level[] levelArray = Level.values();
        int n2 = levelArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Level level = levelArray[n3];
            if (level.ordinal() == n) {
                return level;
            }
            ++n3;
        }
        return null;
    }

    public static Level get(IPatientHierarchy iPatientHierarchy) {
        return Level.get(iPatientHierarchy.getLevel());
    }

    public String toString() {
        return Messages.getString(this.TO_STRING_KEY);
    }

    public String getInfoName() {
        return this.infoName;
    }
}

