/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.export;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingElementWrapper;
import com.agfa.pacs.logging.ALogger;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;

public abstract class ProcessingElementFactory {
    private static final ALogger log = ALogger.getLogger(ProcessingElementFactory.class);
    private static ProcessingElementFactory implementation;

    static ProcessingElementWrapper getProcessingElementWrapper(String string) {
        if (implementation == null) {
            ProcessingElementFactory.initialize();
        }
        return implementation.getProcessingElementInt(string);
    }

    public static IProcessingElement getProcessingElement(String string) {
        if (implementation == null) {
            ProcessingElementFactory.initialize();
        }
        try {
            return implementation.getProcessingElementInt(string.toUpperCase(Locale.ENGLISH)).createProcessor();
        }
        catch (CoreException coreException) {
            log.error("Could not instantiate processor:" + string, (Throwable)coreException);
            return null;
        }
    }

    static Set<String> getProcessingTypes() {
        if (implementation == null) {
            ProcessingElementFactory.initialize();
        }
        return implementation.getProcessingTypesInt();
    }

    protected abstract ProcessingElementWrapper getProcessingElementInt(String var1);

    protected abstract Set<String> getProcessingTypesInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)ProcessingElementFactory.class.getName()));
            implementation = (ProcessingElementFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + ProcessingElementFactory.class.getName(), reflectiveOperationException);
        }
    }
}

