/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.hw;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.hw.DicomRetrieverProviderProxy;
import com.agfa.pacs.data.shared.hw.IDicomRetrieverProvider;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DicomRetrieverProviderFactory {
    private static DicomRetrieverProviderFactory implementation;
    private Map<Class<?>, IDicomRetrieverProvider> providerCache = new ConcurrentHashMap();

    public static synchronized DicomRetrieverProviderFactory getInstance() {
        if (implementation == null) {
            DicomRetrieverProviderFactory.initialize();
        }
        return implementation;
    }

    public IDicomRetrieverProvider getProvider(IInstanceInfo iInstanceInfo) {
        if (iInstanceInfo == null) {
            return null;
        }
        IDicomRetrieverProvider iDicomRetrieverProvider = null;
        if (this.providerCache != null) {
            iDicomRetrieverProvider = this.providerCache.get(iInstanceInfo.getClass());
        }
        if (iDicomRetrieverProvider != null && iDicomRetrieverProvider.canRetrieve(iInstanceInfo)) {
            return iDicomRetrieverProvider;
        }
        List<DicomRetrieverProviderProxy> list = implementation.getIDicomRetrieverFactoriesInt();
        for (DicomRetrieverProviderProxy dicomRetrieverProviderProxy : list) {
            if (!dicomRetrieverProviderProxy.canRetrieve(iInstanceInfo)) continue;
            if (this.providerCache != null) {
                this.providerCache.put(iInstanceInfo.getClass(), dicomRetrieverProviderProxy.getProvider());
            }
            return dicomRetrieverProviderProxy;
        }
        return null;
    }

    public boolean canRetrieve(IInstanceInfo iInstanceInfo) {
        IDicomRetrieverProvider iDicomRetrieverProvider = this.getProvider(iInstanceInfo);
        return iDicomRetrieverProvider != null;
    }

    protected abstract List<DicomRetrieverProviderProxy> getIDicomRetrieverFactoriesInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)DicomRetrieverProviderFactory.class.getName()));
            implementation = (DicomRetrieverProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + DicomRetrieverProviderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

