/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.hw;

import com.agfa.pacs.data.shared.hw.IDicomRetriever;
import com.agfa.pacs.data.shared.hw.IDicomRetrieverProvider;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.logging.ALogger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class DicomRetrieverProviderProxy
implements IDicomRetrieverProvider {
    private IDicomRetrieverProvider provider = null;
    private IConfigurationElement configElem = null;

    public DicomRetrieverProviderProxy(IConfigurationElement iConfigurationElement) {
        this.configElem = iConfigurationElement;
    }

    private void createProvider() {
        try {
            this.provider = (IDicomRetrieverProvider)this.configElem.createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            ALogger.getLogger(DicomRetrieverProviderProxy.class).warn("Could not create provider", (Throwable)coreException);
        }
    }

    public IDicomRetrieverProvider getProvider() {
        if (this.provider == null) {
            this.createProvider();
        }
        return this.provider;
    }

    @Override
    public boolean canRetrieve(IInstanceInfo iInstanceInfo) {
        if (this.provider == null) {
            this.createProvider();
        }
        return this.provider.canRetrieve(iInstanceInfo);
    }

    @Override
    public IDicomRetriever createDicomRetriever() {
        if (this.provider == null) {
            this.createProvider();
        }
        return this.provider.createDicomRetriever();
    }

    public int getPriority() {
        String string = this.configElem.getAttribute("priority");
        if (string == null || string.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            ALogger.getLogger(DicomRetrieverProviderProxy.class).warn("Priority could not be parsed", (Throwable)numberFormatException);
            return 0;
        }
    }
}

