/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.hw;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;

public class HttpConnectionErrorException
extends IOException {
    private static final long serialVersionUID = -8336127028269426073L;
    public static final String COMMENT_GENERIC_SLOW = "WaitForGenericSlowImageRetrieval";
    public static final String COMMENT_AGGREGATED_HEADER_CREATION = "WaitForAggregatedHeaderCreation";
    public static final String COMMENT_CMOVE_RESPONSE = "WaitForCMoveResponse";
    public static final String COMMENT_HOLO = "WaitForPACSArchivedStudy";
    public static final String DELAYED_RESULT_CODE = "ERR_DELAYED_RESULT";
    public static final String ERR_NO_PIXEL_DATA = "ERR_NO_PIXEL_DATA";
    public static final String ERR_INSTANCE_UNAVAILABLE = "ERR_INSTANCE_UNAVAILABLE";
    private final int responseCode;
    private final String responseComment;

    public HttpConnectionErrorException(int n, String string, String string2) {
        super(string2);
        this.responseCode = n;
        this.responseComment = string;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseComment() {
        return this.responseComment;
    }

    public static StringBuilder compileResponseMessage(HttpURLConnection httpURLConnection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(httpURLConnection.getResponseMessage());
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream != null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                while (bufferedReader.ready()) {
                    stringBuilder.append('\n');
                    stringBuilder.append(bufferedReader.readLine());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return stringBuilder;
    }

    private static String parseResponseMessage(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains(COMMENT_HOLO)) {
            return COMMENT_HOLO;
        }
        if (string.contains(COMMENT_CMOVE_RESPONSE)) {
            return COMMENT_CMOVE_RESPONSE;
        }
        if (string.contains(COMMENT_AGGREGATED_HEADER_CREATION)) {
            return COMMENT_AGGREGATED_HEADER_CREATION;
        }
        if (string.contains(COMMENT_GENERIC_SLOW)) {
            return COMMENT_GENERIC_SLOW;
        }
        if (string.contains(DELAYED_RESULT_CODE)) {
            return DELAYED_RESULT_CODE;
        }
        if (string.contains(ERR_NO_PIXEL_DATA)) {
            return ERR_NO_PIXEL_DATA;
        }
        if (string.contains(ERR_INSTANCE_UNAVAILABLE)) {
            return ERR_INSTANCE_UNAVAILABLE;
        }
        return null;
    }

    public boolean isPersistentFailure() {
        return HttpConnectionErrorException.isPersistentFailure(this.responseComment);
    }

    public static boolean isPersistentFailure(String string) {
        return ERR_NO_PIXEL_DATA.equals(string);
    }

    public boolean isUnexpected() {
        return HttpConnectionErrorException.isUnexpected(this.responseComment);
    }

    public static boolean isUnexpected(String string) {
        return string != null && !COMMENT_HOLO.equals(string) && !COMMENT_CMOVE_RESPONSE.equals(string) && !string.contains(DELAYED_RESULT_CODE);
    }

    public static boolean isUnexpected(HttpURLConnection httpURLConnection) throws IOException {
        CharSequence charSequence;
        String string = httpURLConnection.getHeaderField("X-WadoErrorCode");
        if (string != null && !HttpConnectionErrorException.isUnexpected((String)(charSequence = HttpConnectionErrorException.parseResponseMessage(string)))) {
            return false;
        }
        charSequence = HttpConnectionErrorException.compileResponseMessage(httpURLConnection);
        String string2 = HttpConnectionErrorException.parseResponseMessage(((StringBuilder)charSequence).toString());
        return HttpConnectionErrorException.isUnexpected(string2);
    }

    public static String getResponseComment(HttpURLConnection httpURLConnection) throws IOException {
        String string = httpURLConnection.getHeaderField("X-WadoErrorCode");
        if (string != null) {
            return HttpConnectionErrorException.parseResponseMessage(string);
        }
        StringBuilder stringBuilder = HttpConnectionErrorException.compileResponseMessage(httpURLConnection);
        return HttpConnectionErrorException.parseResponseMessage(stringBuilder.toString());
    }

    @Override
    public String toString() {
        return "HTTP-" + this.responseCode + ": " + this.responseComment;
    }
}

