/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.icon.impl;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IMemorySensitiveCache;
import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.IIconProviderListener;
import com.agfa.pacs.data.shared.icon.IconException;
import java.awt.image.BufferedImage;

public abstract class AbstractIconInfo
implements IIconInfo {
    private static final IMemorySensitiveCache cache = DataCacheProviderFactory.getMemorySensitiveCache();
    private CacheID cacheID = cache.createNewTemporaryCacheID();
    protected boolean isDefaultIcon = false;

    protected abstract BufferedImage getImageInt() throws IconException;

    @Override
    public BufferedImage getImage() throws IconException {
        BufferedImage bufferedImage = (BufferedImage)cache.getContentObject(this.cacheID);
        if (bufferedImage == null) {
            bufferedImage = this.getImageInt();
        }
        return bufferedImage;
    }

    protected abstract BufferedImage getImageAsyncInt(IIconProviderListener var1) throws IconException;

    @Override
    public BufferedImage getImageAsync(IIconProviderListener iIconProviderListener) throws IconException {
        BufferedImage bufferedImage = (BufferedImage)cache.getContentObject(this.cacheID);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        return this.getImageAsyncInt(iIconProviderListener);
    }

    @Override
    public boolean isDefaultIcon() {
        return this.isDefaultIcon;
    }

    @Override
    public void release(BufferedImage bufferedImage) {
        bufferedImage.flush();
        cache.putContentObject((Object)bufferedImage, this.cacheID);
    }
}

