/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.icon.impl;

import com.agfa.pacs.data.shared.icon.IIconProviderListener;
import com.agfa.pacs.data.shared.icon.IconException;
import com.agfa.pacs.data.shared.icon.impl.AbstractIconInfo;
import com.agfa.pacs.data.shared.lut.ColorLookupTableSource;
import com.agfa.pacs.data.shared.lut.IColorLookupTableSource;
import com.agfa.pacs.data.shared.lut.ILookupTable;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import org.dcm4che3.data.Attributes;

public class ImagePixelIconInfo
extends AbstractIconInfo {
    private static final ALogger LOGGER = ALogger.getLogger(ImagePixelIconInfo.class);
    protected Attributes imagePixel;

    public ImagePixelIconInfo(Attributes attributes) {
        this.imagePixel = attributes;
    }

    protected BufferedImage toBufferedImage() throws IconException {
        BufferedImage bufferedImage;
        block5: {
            byte[] byArray;
            int n;
            String string;
            int n2;
            int n3;
            block6: {
                block4: {
                    n3 = this.imagePixel.getInt(2621456, 0);
                    n2 = this.imagePixel.getInt(2621457, 0);
                    string = this.imagePixel.getString(2621444, null);
                    bufferedImage = null;
                    n = n3 * n2;
                    try {
                        byArray = this.imagePixel.getBytes(2145386512);
                    }
                    catch (IOException iOException) {
                        throw new IconException(iOException);
                    }
                    if (!"RGB".equals(string)) break block4;
                    bufferedImage = new BufferedImage(n2, n3, 1);
                    int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    int n4 = 0;
                    while (n4 < n) {
                        nArray[n4] = (byArray[n4 * 3] << 16) + (byArray[n4 * 3 + 1] << 8) + byArray[n4 * 3 + 2];
                        ++n4;
                    }
                    break block5;
                }
                if (!"PALETTE COLOR".equals(string)) break block6;
                bufferedImage = this.paintPaletteColorImage(byArray, n3, n2);
                break block5;
            }
            if (!"MONOCHROME2".equals(string)) break block5;
            bufferedImage = new BufferedImage(n2, n3, 10);
            byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            int n5 = 0;
            while (n5 < n) {
                byArray2[n5] = byArray[n5];
                ++n5;
            }
        }
        return bufferedImage;
    }

    private BufferedImage paintPaletteColorImage(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n2, n, 1);
        ColorLookupTableSource colorLookupTableSource = new ColorLookupTableSource(this.imagePixel);
        ILookupTable iLookupTable = colorLookupTableSource.getLookupTable(IColorLookupTableSource.Channel.Red);
        ILookupTable iLookupTable2 = colorLookupTableSource.getLookupTable(IColorLookupTableSource.Channel.Green);
        ILookupTable iLookupTable3 = colorLookupTableSource.getLookupTable(IColorLookupTableSource.Channel.Blue);
        int n3 = this.imagePixel.getInt(2621697, 0);
        if (iLookupTable == null || iLookupTable2 == null || iLookupTable3 == null) {
            LOGGER.warn("Missing palette color LUT");
        } else if (n3 != 8) {
            LOGGER.warn("Unsupported palette color LUT (expected bits stored = 8; was {})", (Object)n3);
        } else {
            boolean bl = this.imagePixel.getInt(2621699, 0) == 1;
            int[] nArray = iLookupTable.getFullLUT(n3, bl);
            int[] nArray2 = iLookupTable2.getFullLUT(n3, bl);
            int[] nArray3 = iLookupTable3.getFullLUT(n3, bl);
            int[] nArray4 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int n4 = n * n2;
            int n5 = 0;
            while (n5 < n4) {
                nArray4[n5] = (nArray[byArray[n5] & 0xFF] << 16) + (nArray2[byArray[n5] & 0xFF] << 8) + nArray3[byArray[n5] & 0xFF];
                ++n5;
            }
        }
        return bufferedImage;
    }

    @Override
    protected BufferedImage getImageAsyncInt(IIconProviderListener iIconProviderListener) throws IconException {
        return this.toBufferedImage();
    }

    @Override
    protected BufferedImage getImageInt() throws IconException {
        return this.toBufferedImage();
    }

    public void release() {
    }

    @Override
    public boolean isDefaultIcon() {
        return false;
    }
}

