/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.icon.impl;

import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.IIconProviderListener;
import com.agfa.pacs.data.shared.icon.IconException;
import com.agfa.pacs.data.shared.icon.impl.AbstractIconInfo;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public class URLIconInfo
extends AbstractIconInfo {
    private static final MediaTracker tracker = new MediaTracker(new Component(){});
    private static final ImageIconLoader iconLoader = new ImageIconLoader();
    private static final ALogger log = ALogger.getLogger(URLIconInfo.class);
    private URL url = null;

    static {
        new Thread((Runnable)iconLoader, "IconLoader").start();
    }

    public URLIconInfo(URL uRL, boolean bl) {
        this.url = uRL;
        this.isDefaultIcon = bl;
    }

    private BufferedImage toBufferedImage() throws IconException {
        BufferedImage bufferedImage = null;
        Image image = Toolkit.getDefaultToolkit().createImage(this.url);
        try {
            try {
                tracker.addImage(image, image.hashCode());
                tracker.waitForID(image.hashCode());
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
                bufferedImage.getGraphics().drawImage(image, 0, 0, null);
            }
            catch (Exception exception) {
                throw new IconException("Cannot load Icon", exception);
            }
        }
        finally {
            tracker.removeImage(image, image.hashCode());
            image.flush();
        }
        return bufferedImage;
    }

    @Override
    protected BufferedImage getImageInt() throws IconException {
        return this.toBufferedImage();
    }

    @Override
    protected BufferedImage getImageAsyncInt(IIconProviderListener iIconProviderListener) throws IconException {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(this.url);
            iconLoader.add(image, iIconProviderListener, this);
        }
        catch (Exception exception) {
            throw new IconException("Cannot load Icon", exception);
        }
        return null;
    }

    public void release() {
    }

    @Override
    public boolean isDefaultIcon() {
        return this.isDefaultIcon || this.url == null;
    }

    static class ImageIconLoader
    implements Runnable {
        private BlockingQueue<IconToListenersBunch> queue = new LinkedBlockingQueue<IconToListenersBunch>();
        private Map<IconToListenersBunch, IconToListenersBunch> queueMap = new ConcurrentHashMap<IconToListenersBunch, IconToListenersBunch>();

        ImageIconLoader() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        IconToListenersBunch iconToListenersBunch;
                        if ((iconToListenersBunch = this.queue.take()) != null) {
                            this.queueMap.remove(iconToListenersBunch);
                        }
                        if (iconToListenersBunch == null || iconToListenersBunch.isOutDated()) continue;
                        this.processItem(iconToListenersBunch);
                    }
                }
                catch (InterruptedException interruptedException) {
                    log.warn("Interrupted", (Throwable)interruptedException);
                    continue;
                }
                break;
            }
        }

        private void processItem(IconToListenersBunch iconToListenersBunch) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = iconToListenersBunch.ii.toBufferedImage();
                this.informListeners(iconToListenersBunch.getListeners(), iconToListenersBunch.getIconInformation(), bufferedImage);
            }
            catch (IconException iconException) {
                log.warn("Error loading icons", (Throwable)iconException);
            }
        }

        private void informListeners(List<IIconProviderListener> list, IIconInfo iIconInfo, BufferedImage bufferedImage) {
            for (IIconProviderListener iIconProviderListener : list) {
                if (iIconProviderListener == null) continue;
                iIconProviderListener.iconAvailable(null, iIconInfo, bufferedImage);
            }
        }

        public void add(Image image, IIconProviderListener iIconProviderListener, URLIconInfo uRLIconInfo) {
            IconToListenersBunch iconToListenersBunch = new IconToListenersBunch(image, iIconProviderListener, uRLIconInfo);
            IconToListenersBunch iconToListenersBunch2 = this.queueMap.get(iconToListenersBunch);
            if (iconToListenersBunch2 != null) {
                for (IIconProviderListener iIconProviderListener2 : iconToListenersBunch2.getListeners()) {
                    iconToListenersBunch.addListener(iIconProviderListener2);
                }
                iconToListenersBunch2.setOutDated(true);
            }
            if (this.queue.offer(iconToListenersBunch)) {
                this.queueMap.put(iconToListenersBunch, iconToListenersBunch);
            }
        }

        static class IconToListenersBunch {
            private Image image;
            private List<IIconProviderListener> listeners;
            private URLIconInfo ii;
            private boolean outDated = false;

            public IconToListenersBunch(Image image, IIconProviderListener iIconProviderListener, URLIconInfo uRLIconInfo) {
                this.image = image;
                this.listeners = new CopyOnWriteArrayList<IIconProviderListener>();
                this.listeners.add(iIconProviderListener);
                this.ii = uRLIconInfo;
            }

            public Image getImage() {
                return this.image;
            }

            public void setImage(Image image) {
                this.image = image;
            }

            public List<IIconProviderListener> getListeners() {
                return this.listeners;
            }

            public void addListener(IIconProviderListener iIconProviderListener) {
                if (!this.listeners.contains(iIconProviderListener)) {
                    this.listeners.add(iIconProviderListener);
                }
            }

            public IIconInfo getIconInformation() {
                return this.ii;
            }

            public void setIi(URLIconInfo uRLIconInfo) {
                this.ii = uRLIconInfo;
            }

            public boolean equals(Object object) {
                if (object != null && object instanceof IconToListenersBunch) {
                    IconToListenersBunch iconToListenersBunch = (IconToListenersBunch)object;
                    return this.ii == iconToListenersBunch.getIconInformation() && this.image == iconToListenersBunch.getImage();
                }
                return false;
            }

            public int hashCode() {
                return this.ii.hashCode() + this.image.hashCode();
            }

            public boolean isOutDated() {
                return this.outDated;
            }

            public void setOutDated(boolean bl) {
                this.outDated = bl;
            }
        }
    }
}

