/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.instanceinfo;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.logging.ALogger;
import java.util.Locale;
import org.dcm4che3.data.Attributes;

public enum Availability implements DicomEnum
{
    LOCAL("LOCAL", true),
    ONLINE("ONLINE", true),
    REMOTE_ONLINE("ONLINE", false),
    NEARLINE("NEARLINE", true),
    REMOTE_NEARLINE("NEARLINE", false),
    OFFLINE("OFFLINE", false),
    UNAVAILABLE("UNAVAILABLE", false);

    private final String dicomId;
    private final boolean hasRetrieveAET;
    private String toolTip;
    private static Availability LAST_FAST_RETRIEVE;

    static {
        LAST_FAST_RETRIEVE = ONLINE;
        try {
            String string = ConfigurationProviderFactory.getConfig().getString("com.agfa.pacs.data.base.fastDicomAvailability");
            LAST_FAST_RETRIEVE = Availability.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ALogger.getLogger(Availability.class).error("Could not read configuration", (Throwable)illegalArgumentException);
        }
    }

    public boolean isFastRetrievable() {
        return this != ONLINE && LAST_FAST_RETRIEVE.compareTo(this) >= 0;
    }

    public boolean isSlowRetrievable() {
        return LAST_FAST_RETRIEVE.compareTo(this) < 0 && OFFLINE.compareTo(this) > 0;
    }

    public boolean isSlow() {
        return LAST_FAST_RETRIEVE.compareTo(this) < 0;
    }

    public boolean isNotRetrievable() {
        return OFFLINE.compareTo(this) <= 0;
    }

    public String getToolTip() {
        if (this == ONLINE) {
            return null;
        }
        return this.toolTip;
    }

    public String toString() {
        return this.toolTip;
    }

    private Availability(String string2, boolean bl) {
        this.dicomId = string2;
        this.hasRetrieveAET = bl;
        String string3 = this.name();
        string3 = string3.replace('_', ' ');
        String[] stringArray = string3.split("\\ ");
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string4 = stringArray2[n3];
            stringBuilder.append(string4.substring(0, 1)).append(string4.substring(1).toLowerCase(Locale.ENGLISH)).append(' ');
            ++n3;
        }
        this.toolTip = stringBuilder.toString();
    }

    public String dicom() {
        return this.dicomId;
    }

    public static Availability get(Attributes attributes, String string) {
        String string2;
        int n;
        int n2;
        Object[] objectArray;
        boolean bl;
        String string3 = attributes.getString(524374, null);
        String[] stringArray = attributes.getStrings(524372);
        boolean bl2 = bl = string == null;
        if (stringArray == null) {
            bl = true;
            string = null;
        }
        if (string != null) {
            objectArray = stringArray;
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                string2 = objectArray[n];
                if (string2.equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        objectArray = Availability.values();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            string2 = objectArray[n];
            if (((Availability)((Object)string2)).dicomId.equals(string3) && (!((Availability)((Object)string2)).hasRetrieveAET || bl)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public static Availability getForNonDicom(String string) {
        Availability[] availabilityArray = Availability.values();
        int n = availabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Availability availability = availabilityArray[n2];
            if (availability.hasRetrieveAET && availability.dicomId.equals(string)) {
                return availability;
            }
            ++n2;
        }
        return ONLINE;
    }

    public static Availability[] getConfigurableAvailabilities() {
        return new Availability[]{ONLINE, REMOTE_ONLINE, NEARLINE, REMOTE_NEARLINE};
    }
}

